/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Looper;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.trackselection.TrackSelectionOverrides;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.BundleableUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public class TrackSelectionParameters
implements Bundleable {
    public static final TrackSelectionParameters DEFAULT_WITHOUT_CONTEXT;
    @Deprecated
    public static final TrackSelectionParameters DEFAULT;
    public final int maxVideoWidth;
    public final int maxVideoHeight;
    public final int maxVideoFrameRate;
    public final int maxVideoBitrate;
    public final int minVideoWidth;
    public final int minVideoHeight;
    public final int minVideoFrameRate;
    public final int minVideoBitrate;
    public final int viewportWidth;
    public final int viewportHeight;
    public final boolean viewportOrientationMayChange;
    public final ImmutableList<String> preferredVideoMimeTypes;
    public final int preferredVideoRoleFlags;
    public final ImmutableList<String> preferredAudioLanguages;
    public final int preferredAudioRoleFlags;
    public final int maxAudioChannelCount;
    public final int maxAudioBitrate;
    public final ImmutableList<String> preferredAudioMimeTypes;
    public final ImmutableList<String> preferredTextLanguages;
    public final int preferredTextRoleFlags;
    public final boolean selectUndeterminedTextLanguage;
    public final boolean forceLowestBitrate;
    public final boolean forceHighestSupportedBitrate;
    public final TrackSelectionOverrides trackSelectionOverrides;
    public final ImmutableSet<Integer> disabledTrackTypes;
    private static final int FIELD_PREFERRED_AUDIO_LANGUAGES = 1;
    private static final int FIELD_PREFERRED_AUDIO_ROLE_FLAGS = 2;
    private static final int FIELD_PREFERRED_TEXT_LANGUAGES = 3;
    private static final int FIELD_PREFERRED_TEXT_ROLE_FLAGS = 4;
    private static final int FIELD_SELECT_UNDETERMINED_TEXT_LANGUAGE = 5;
    private static final int FIELD_MAX_VIDEO_WIDTH = 6;
    private static final int FIELD_MAX_VIDEO_HEIGHT = 7;
    private static final int FIELD_MAX_VIDEO_FRAMERATE = 8;
    private static final int FIELD_MAX_VIDEO_BITRATE = 9;
    private static final int FIELD_MIN_VIDEO_WIDTH = 10;
    private static final int FIELD_MIN_VIDEO_HEIGHT = 11;
    private static final int FIELD_MIN_VIDEO_FRAMERATE = 12;
    private static final int FIELD_MIN_VIDEO_BITRATE = 13;
    private static final int FIELD_VIEWPORT_WIDTH = 14;
    private static final int FIELD_VIEWPORT_HEIGHT = 15;
    private static final int FIELD_VIEWPORT_ORIENTATION_MAY_CHANGE = 16;
    private static final int FIELD_PREFERRED_VIDEO_MIMETYPES = 17;
    private static final int FIELD_MAX_AUDIO_CHANNEL_COUNT = 18;
    private static final int FIELD_MAX_AUDIO_BITRATE = 19;
    private static final int FIELD_PREFERRED_AUDIO_MIME_TYPES = 20;
    private static final int FIELD_FORCE_LOWEST_BITRATE = 21;
    private static final int FIELD_FORCE_HIGHEST_SUPPORTED_BITRATE = 22;
    private static final int FIELD_SELECTION_OVERRIDE_KEYS = 23;
    private static final int FIELD_SELECTION_OVERRIDE_VALUES = 24;
    private static final int FIELD_DISABLED_TRACK_TYPE = 25;
    private static final int FIELD_PREFERRED_VIDEO_ROLE_FLAGS = 26;
    public static final Bundleable.Creator<TrackSelectionParameters> CREATOR;

    public static TrackSelectionParameters getDefaults(Context context) {
        return new Builder(context).build();
    }

    protected TrackSelectionParameters(Builder builder) {
        this.maxVideoWidth = builder.maxVideoWidth;
        this.maxVideoHeight = builder.maxVideoHeight;
        this.maxVideoFrameRate = builder.maxVideoFrameRate;
        this.maxVideoBitrate = builder.maxVideoBitrate;
        this.minVideoWidth = builder.minVideoWidth;
        this.minVideoHeight = builder.minVideoHeight;
        this.minVideoFrameRate = builder.minVideoFrameRate;
        this.minVideoBitrate = builder.minVideoBitrate;
        this.viewportWidth = builder.viewportWidth;
        this.viewportHeight = builder.viewportHeight;
        this.viewportOrientationMayChange = builder.viewportOrientationMayChange;
        this.preferredVideoMimeTypes = builder.preferredVideoMimeTypes;
        this.preferredVideoRoleFlags = builder.preferredVideoRoleFlags;
        this.preferredAudioLanguages = builder.preferredAudioLanguages;
        this.preferredAudioRoleFlags = builder.preferredAudioRoleFlags;
        this.maxAudioChannelCount = builder.maxAudioChannelCount;
        this.maxAudioBitrate = builder.maxAudioBitrate;
        this.preferredAudioMimeTypes = builder.preferredAudioMimeTypes;
        this.preferredTextLanguages = builder.preferredTextLanguages;
        this.preferredTextRoleFlags = builder.preferredTextRoleFlags;
        this.selectUndeterminedTextLanguage = builder.selectUndeterminedTextLanguage;
        this.forceLowestBitrate = builder.forceLowestBitrate;
        this.forceHighestSupportedBitrate = builder.forceHighestSupportedBitrate;
        this.trackSelectionOverrides = builder.trackSelectionOverrides;
        this.disabledTrackTypes = builder.disabledTrackTypes;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackSelectionParameters other = (TrackSelectionParameters)obj;
        return this.maxVideoWidth == other.maxVideoWidth && this.maxVideoHeight == other.maxVideoHeight && this.maxVideoFrameRate == other.maxVideoFrameRate && this.maxVideoBitrate == other.maxVideoBitrate && this.minVideoWidth == other.minVideoWidth && this.minVideoHeight == other.minVideoHeight && this.minVideoFrameRate == other.minVideoFrameRate && this.minVideoBitrate == other.minVideoBitrate && this.viewportOrientationMayChange == other.viewportOrientationMayChange && this.viewportWidth == other.viewportWidth && this.viewportHeight == other.viewportHeight && this.preferredVideoMimeTypes.equals(other.preferredVideoMimeTypes) && this.preferredVideoRoleFlags == other.preferredVideoRoleFlags && this.preferredAudioLanguages.equals(other.preferredAudioLanguages) && this.preferredAudioRoleFlags == other.preferredAudioRoleFlags && this.maxAudioChannelCount == other.maxAudioChannelCount && this.maxAudioBitrate == other.maxAudioBitrate && this.preferredAudioMimeTypes.equals(other.preferredAudioMimeTypes) && this.preferredTextLanguages.equals(other.preferredTextLanguages) && this.preferredTextRoleFlags == other.preferredTextRoleFlags && this.selectUndeterminedTextLanguage == other.selectUndeterminedTextLanguage && this.forceLowestBitrate == other.forceLowestBitrate && this.forceHighestSupportedBitrate == other.forceHighestSupportedBitrate && this.trackSelectionOverrides.equals(other.trackSelectionOverrides) && this.disabledTrackTypes.equals(other.disabledTrackTypes);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.maxVideoWidth;
        result = 31 * result + this.maxVideoHeight;
        result = 31 * result + this.maxVideoFrameRate;
        result = 31 * result + this.maxVideoBitrate;
        result = 31 * result + this.minVideoWidth;
        result = 31 * result + this.minVideoHeight;
        result = 31 * result + this.minVideoFrameRate;
        result = 31 * result + this.minVideoBitrate;
        result = 31 * result + (this.viewportOrientationMayChange ? 1 : 0);
        result = 31 * result + this.viewportWidth;
        result = 31 * result + this.viewportHeight;
        result = 31 * result + this.preferredVideoMimeTypes.hashCode();
        result = 31 * result + this.preferredVideoRoleFlags;
        result = 31 * result + this.preferredAudioLanguages.hashCode();
        result = 31 * result + this.preferredAudioRoleFlags;
        result = 31 * result + this.maxAudioChannelCount;
        result = 31 * result + this.maxAudioBitrate;
        result = 31 * result + this.preferredAudioMimeTypes.hashCode();
        result = 31 * result + this.preferredTextLanguages.hashCode();
        result = 31 * result + this.preferredTextRoleFlags;
        result = 31 * result + (this.selectUndeterminedTextLanguage ? 1 : 0);
        result = 31 * result + (this.forceLowestBitrate ? 1 : 0);
        result = 31 * result + (this.forceHighestSupportedBitrate ? 1 : 0);
        result = 31 * result + this.trackSelectionOverrides.hashCode();
        result = 31 * result + this.disabledTrackTypes.hashCode();
        return result;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(TrackSelectionParameters.keyForField(6), this.maxVideoWidth);
        bundle.putInt(TrackSelectionParameters.keyForField(7), this.maxVideoHeight);
        bundle.putInt(TrackSelectionParameters.keyForField(8), this.maxVideoFrameRate);
        bundle.putInt(TrackSelectionParameters.keyForField(9), this.maxVideoBitrate);
        bundle.putInt(TrackSelectionParameters.keyForField(10), this.minVideoWidth);
        bundle.putInt(TrackSelectionParameters.keyForField(11), this.minVideoHeight);
        bundle.putInt(TrackSelectionParameters.keyForField(12), this.minVideoFrameRate);
        bundle.putInt(TrackSelectionParameters.keyForField(13), this.minVideoBitrate);
        bundle.putInt(TrackSelectionParameters.keyForField(14), this.viewportWidth);
        bundle.putInt(TrackSelectionParameters.keyForField(15), this.viewportHeight);
        bundle.putBoolean(TrackSelectionParameters.keyForField(16), this.viewportOrientationMayChange);
        bundle.putStringArray(TrackSelectionParameters.keyForField(17), (String[])this.preferredVideoMimeTypes.toArray((Object[])new String[0]));
        bundle.putInt(TrackSelectionParameters.keyForField(26), this.preferredVideoRoleFlags);
        bundle.putStringArray(TrackSelectionParameters.keyForField(1), (String[])this.preferredAudioLanguages.toArray((Object[])new String[0]));
        bundle.putInt(TrackSelectionParameters.keyForField(2), this.preferredAudioRoleFlags);
        bundle.putInt(TrackSelectionParameters.keyForField(18), this.maxAudioChannelCount);
        bundle.putInt(TrackSelectionParameters.keyForField(19), this.maxAudioBitrate);
        bundle.putStringArray(TrackSelectionParameters.keyForField(20), (String[])this.preferredAudioMimeTypes.toArray((Object[])new String[0]));
        bundle.putStringArray(TrackSelectionParameters.keyForField(3), (String[])this.preferredTextLanguages.toArray((Object[])new String[0]));
        bundle.putInt(TrackSelectionParameters.keyForField(4), this.preferredTextRoleFlags);
        bundle.putBoolean(TrackSelectionParameters.keyForField(5), this.selectUndeterminedTextLanguage);
        bundle.putBoolean(TrackSelectionParameters.keyForField(21), this.forceLowestBitrate);
        bundle.putBoolean(TrackSelectionParameters.keyForField(22), this.forceHighestSupportedBitrate);
        bundle.putBundle(TrackSelectionParameters.keyForField(23), this.trackSelectionOverrides.toBundle());
        bundle.putIntArray(TrackSelectionParameters.keyForField(25), Ints.toArray(this.disabledTrackTypes));
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    static {
        DEFAULT = DEFAULT_WITHOUT_CONTEXT = new Builder().build();
        CREATOR = bundle -> new Builder(bundle).build();
    }

    public static class Builder {
        private int maxVideoWidth;
        private int maxVideoHeight;
        private int maxVideoFrameRate;
        private int maxVideoBitrate;
        private int minVideoWidth;
        private int minVideoHeight;
        private int minVideoFrameRate;
        private int minVideoBitrate;
        private int viewportWidth;
        private int viewportHeight;
        private boolean viewportOrientationMayChange;
        private ImmutableList<String> preferredVideoMimeTypes;
        private int preferredVideoRoleFlags;
        private ImmutableList<String> preferredAudioLanguages;
        private int preferredAudioRoleFlags;
        private int maxAudioChannelCount;
        private int maxAudioBitrate;
        private ImmutableList<String> preferredAudioMimeTypes;
        private ImmutableList<String> preferredTextLanguages;
        private int preferredTextRoleFlags;
        private boolean selectUndeterminedTextLanguage;
        private boolean forceLowestBitrate;
        private boolean forceHighestSupportedBitrate;
        private TrackSelectionOverrides trackSelectionOverrides;
        private ImmutableSet<Integer> disabledTrackTypes;

        @Deprecated
        public Builder() {
            this.maxVideoWidth = Integer.MAX_VALUE;
            this.maxVideoHeight = Integer.MAX_VALUE;
            this.maxVideoFrameRate = Integer.MAX_VALUE;
            this.maxVideoBitrate = Integer.MAX_VALUE;
            this.viewportWidth = Integer.MAX_VALUE;
            this.viewportHeight = Integer.MAX_VALUE;
            this.viewportOrientationMayChange = true;
            this.preferredVideoMimeTypes = ImmutableList.of();
            this.preferredVideoRoleFlags = 0;
            this.preferredAudioLanguages = ImmutableList.of();
            this.preferredAudioRoleFlags = 0;
            this.maxAudioChannelCount = Integer.MAX_VALUE;
            this.maxAudioBitrate = Integer.MAX_VALUE;
            this.preferredAudioMimeTypes = ImmutableList.of();
            this.preferredTextLanguages = ImmutableList.of();
            this.preferredTextRoleFlags = 0;
            this.selectUndeterminedTextLanguage = false;
            this.forceLowestBitrate = false;
            this.forceHighestSupportedBitrate = false;
            this.trackSelectionOverrides = TrackSelectionOverrides.EMPTY;
            this.disabledTrackTypes = ImmutableSet.of();
        }

        public Builder(Context context) {
            this();
            this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
            this.setViewportSizeToPhysicalDisplaySize(context, true);
        }

        protected Builder(TrackSelectionParameters initialValues) {
            this.init(initialValues);
        }

        protected Builder(Bundle bundle) {
            this.maxVideoWidth = bundle.getInt(TrackSelectionParameters.keyForField(6), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxVideoWidth);
            this.maxVideoHeight = bundle.getInt(TrackSelectionParameters.keyForField(7), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxVideoHeight);
            this.maxVideoFrameRate = bundle.getInt(TrackSelectionParameters.keyForField(8), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxVideoFrameRate);
            this.maxVideoBitrate = bundle.getInt(TrackSelectionParameters.keyForField(9), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxVideoBitrate);
            this.minVideoWidth = bundle.getInt(TrackSelectionParameters.keyForField(10), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.minVideoWidth);
            this.minVideoHeight = bundle.getInt(TrackSelectionParameters.keyForField(11), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.minVideoHeight);
            this.minVideoFrameRate = bundle.getInt(TrackSelectionParameters.keyForField(12), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.minVideoFrameRate);
            this.minVideoBitrate = bundle.getInt(TrackSelectionParameters.keyForField(13), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.minVideoBitrate);
            this.viewportWidth = bundle.getInt(TrackSelectionParameters.keyForField(14), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.viewportWidth);
            this.viewportHeight = bundle.getInt(TrackSelectionParameters.keyForField(15), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.viewportHeight);
            this.viewportOrientationMayChange = bundle.getBoolean(TrackSelectionParameters.keyForField(16), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.viewportOrientationMayChange);
            this.preferredVideoMimeTypes = ImmutableList.copyOf((Object[])((String[])MoreObjects.firstNonNull((Object)bundle.getStringArray(TrackSelectionParameters.keyForField(17)), (Object)new String[0])));
            this.preferredVideoRoleFlags = bundle.getInt(TrackSelectionParameters.keyForField(26), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.preferredVideoRoleFlags);
            String[] preferredAudioLanguages1 = (String[])MoreObjects.firstNonNull((Object)bundle.getStringArray(TrackSelectionParameters.keyForField(1)), (Object)new String[0]);
            this.preferredAudioLanguages = Builder.normalizeLanguageCodes(preferredAudioLanguages1);
            this.preferredAudioRoleFlags = bundle.getInt(TrackSelectionParameters.keyForField(2), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.preferredAudioRoleFlags);
            this.maxAudioChannelCount = bundle.getInt(TrackSelectionParameters.keyForField(18), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxAudioChannelCount);
            this.maxAudioBitrate = bundle.getInt(TrackSelectionParameters.keyForField(19), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.maxAudioBitrate);
            this.preferredAudioMimeTypes = ImmutableList.copyOf((Object[])((String[])MoreObjects.firstNonNull((Object)bundle.getStringArray(TrackSelectionParameters.keyForField(20)), (Object)new String[0])));
            this.preferredTextLanguages = Builder.normalizeLanguageCodes((String[])MoreObjects.firstNonNull((Object)bundle.getStringArray(TrackSelectionParameters.keyForField(3)), (Object)new String[0]));
            this.preferredTextRoleFlags = bundle.getInt(TrackSelectionParameters.keyForField(4), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.preferredTextRoleFlags);
            this.selectUndeterminedTextLanguage = bundle.getBoolean(TrackSelectionParameters.keyForField(5), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.selectUndeterminedTextLanguage);
            this.forceLowestBitrate = bundle.getBoolean(TrackSelectionParameters.keyForField(21), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.forceLowestBitrate);
            this.forceHighestSupportedBitrate = bundle.getBoolean(TrackSelectionParameters.keyForField(22), TrackSelectionParameters.DEFAULT_WITHOUT_CONTEXT.forceHighestSupportedBitrate);
            this.trackSelectionOverrides = BundleableUtil.fromNullableBundle(TrackSelectionOverrides.CREATOR, bundle.getBundle(TrackSelectionParameters.keyForField(23)), TrackSelectionOverrides.EMPTY);
            this.disabledTrackTypes = ImmutableSet.copyOf((Collection)Ints.asList((int[])((int[])MoreObjects.firstNonNull((Object)bundle.getIntArray(TrackSelectionParameters.keyForField(25)), (Object)new int[0]))));
        }

        @EnsuresNonNull(value={"preferredVideoMimeTypes", "preferredAudioLanguages", "preferredAudioMimeTypes", "preferredTextLanguages", "trackSelectionOverrides", "disabledTrackTypes"})
        private void init(@UnknownInitialization Builder this, TrackSelectionParameters parameters) {
            this.maxVideoWidth = parameters.maxVideoWidth;
            this.maxVideoHeight = parameters.maxVideoHeight;
            this.maxVideoFrameRate = parameters.maxVideoFrameRate;
            this.maxVideoBitrate = parameters.maxVideoBitrate;
            this.minVideoWidth = parameters.minVideoWidth;
            this.minVideoHeight = parameters.minVideoHeight;
            this.minVideoFrameRate = parameters.minVideoFrameRate;
            this.minVideoBitrate = parameters.minVideoBitrate;
            this.viewportWidth = parameters.viewportWidth;
            this.viewportHeight = parameters.viewportHeight;
            this.viewportOrientationMayChange = parameters.viewportOrientationMayChange;
            this.preferredVideoMimeTypes = parameters.preferredVideoMimeTypes;
            this.preferredVideoRoleFlags = parameters.preferredVideoRoleFlags;
            this.preferredAudioLanguages = parameters.preferredAudioLanguages;
            this.preferredAudioRoleFlags = parameters.preferredAudioRoleFlags;
            this.maxAudioChannelCount = parameters.maxAudioChannelCount;
            this.maxAudioBitrate = parameters.maxAudioBitrate;
            this.preferredAudioMimeTypes = parameters.preferredAudioMimeTypes;
            this.preferredTextLanguages = parameters.preferredTextLanguages;
            this.preferredTextRoleFlags = parameters.preferredTextRoleFlags;
            this.selectUndeterminedTextLanguage = parameters.selectUndeterminedTextLanguage;
            this.forceLowestBitrate = parameters.forceLowestBitrate;
            this.forceHighestSupportedBitrate = parameters.forceHighestSupportedBitrate;
            this.trackSelectionOverrides = parameters.trackSelectionOverrides;
            this.disabledTrackTypes = parameters.disabledTrackTypes;
        }

        protected Builder set(TrackSelectionParameters parameters) {
            this.init(parameters);
            return this;
        }

        public Builder setMaxVideoSizeSd() {
            return this.setMaxVideoSize(1279, 719);
        }

        public Builder clearVideoSizeConstraints() {
            return this.setMaxVideoSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Builder setMaxVideoSize(int maxVideoWidth, int maxVideoHeight) {
            this.maxVideoWidth = maxVideoWidth;
            this.maxVideoHeight = maxVideoHeight;
            return this;
        }

        public Builder setMaxVideoFrameRate(int maxVideoFrameRate) {
            this.maxVideoFrameRate = maxVideoFrameRate;
            return this;
        }

        public Builder setMaxVideoBitrate(int maxVideoBitrate) {
            this.maxVideoBitrate = maxVideoBitrate;
            return this;
        }

        public Builder setMinVideoSize(int minVideoWidth, int minVideoHeight) {
            this.minVideoWidth = minVideoWidth;
            this.minVideoHeight = minVideoHeight;
            return this;
        }

        public Builder setMinVideoFrameRate(int minVideoFrameRate) {
            this.minVideoFrameRate = minVideoFrameRate;
            return this;
        }

        public Builder setMinVideoBitrate(int minVideoBitrate) {
            this.minVideoBitrate = minVideoBitrate;
            return this;
        }

        public Builder setViewportSizeToPhysicalDisplaySize(Context context, boolean viewportOrientationMayChange) {
            Point viewportSize = Util.getCurrentDisplayModeSize(context);
            return this.setViewportSize(viewportSize.x, viewportSize.y, viewportOrientationMayChange);
        }

        public Builder clearViewportSizeConstraints() {
            return this.setViewportSize(Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }

        public Builder setViewportSize(int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange) {
            this.viewportWidth = viewportWidth;
            this.viewportHeight = viewportHeight;
            this.viewportOrientationMayChange = viewportOrientationMayChange;
            return this;
        }

        public Builder setPreferredVideoMimeType(@Nullable String mimeType) {
            return mimeType == null ? this.setPreferredVideoMimeTypes(new String[0]) : this.setPreferredVideoMimeTypes(mimeType);
        }

        public Builder setPreferredVideoMimeTypes(String ... mimeTypes) {
            this.preferredVideoMimeTypes = ImmutableList.copyOf((Object[])mimeTypes);
            return this;
        }

        public Builder setPreferredVideoRoleFlags(int preferredVideoRoleFlags) {
            this.preferredVideoRoleFlags = preferredVideoRoleFlags;
            return this;
        }

        public Builder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            return preferredAudioLanguage == null ? this.setPreferredAudioLanguages(new String[0]) : this.setPreferredAudioLanguages(preferredAudioLanguage);
        }

        public Builder setPreferredAudioLanguages(String ... preferredAudioLanguages) {
            this.preferredAudioLanguages = Builder.normalizeLanguageCodes(preferredAudioLanguages);
            return this;
        }

        public Builder setPreferredAudioRoleFlags(int preferredAudioRoleFlags) {
            this.preferredAudioRoleFlags = preferredAudioRoleFlags;
            return this;
        }

        public Builder setMaxAudioChannelCount(int maxAudioChannelCount) {
            this.maxAudioChannelCount = maxAudioChannelCount;
            return this;
        }

        public Builder setMaxAudioBitrate(int maxAudioBitrate) {
            this.maxAudioBitrate = maxAudioBitrate;
            return this;
        }

        public Builder setPreferredAudioMimeType(@Nullable String mimeType) {
            return mimeType == null ? this.setPreferredAudioMimeTypes(new String[0]) : this.setPreferredAudioMimeTypes(mimeType);
        }

        public Builder setPreferredAudioMimeTypes(String ... mimeTypes) {
            this.preferredAudioMimeTypes = ImmutableList.copyOf((Object[])mimeTypes);
            return this;
        }

        public Builder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            if (Util.SDK_INT >= 19) {
                this.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(context);
            }
            return this;
        }

        public Builder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            return preferredTextLanguage == null ? this.setPreferredTextLanguages(new String[0]) : this.setPreferredTextLanguages(preferredTextLanguage);
        }

        public Builder setPreferredTextLanguages(String ... preferredTextLanguages) {
            this.preferredTextLanguages = Builder.normalizeLanguageCodes(preferredTextLanguages);
            return this;
        }

        public Builder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
            this.preferredTextRoleFlags = preferredTextRoleFlags;
            return this;
        }

        public Builder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            this.selectUndeterminedTextLanguage = selectUndeterminedTextLanguage;
            return this;
        }

        public Builder setForceLowestBitrate(boolean forceLowestBitrate) {
            this.forceLowestBitrate = forceLowestBitrate;
            return this;
        }

        public Builder setForceHighestSupportedBitrate(boolean forceHighestSupportedBitrate) {
            this.forceHighestSupportedBitrate = forceHighestSupportedBitrate;
            return this;
        }

        public Builder setTrackSelectionOverrides(TrackSelectionOverrides trackSelectionOverrides) {
            this.trackSelectionOverrides = trackSelectionOverrides;
            return this;
        }

        public Builder setDisabledTrackTypes(Set<Integer> disabledTrackTypes) {
            this.disabledTrackTypes = ImmutableSet.copyOf(disabledTrackTypes);
            return this;
        }

        public TrackSelectionParameters build() {
            return new TrackSelectionParameters(this);
        }

        @RequiresApi(value=19)
        private void setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettingsV19(Context context) {
            if (Util.SDK_INT < 23 && Looper.myLooper() == null) {
                return;
            }
            CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
            if (captioningManager == null || !captioningManager.isEnabled()) {
                return;
            }
            this.preferredTextRoleFlags = 1088;
            Locale preferredLocale = captioningManager.getLocale();
            if (preferredLocale != null) {
                this.preferredTextLanguages = ImmutableList.of((Object)Util.getLocaleLanguageTag(preferredLocale));
            }
        }

        private static ImmutableList<String> normalizeLanguageCodes(String[] preferredTextLanguages) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (String language : Assertions.checkNotNull(preferredTextLanguages)) {
                listBuilder.add((Object)Util.normalizeLanguageCode(Assertions.checkNotNull(language)));
            }
            return listBuilder.build();
        }
    }
}

