/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.id3;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;

public final class ApicFrame
extends Id3Frame {
    public static final String ID = "APIC";
    public final String mimeType;
    @Nullable
    public final String description;
    public final int pictureType;
    public final byte[] pictureData;
    public static final Parcelable.Creator<ApicFrame> CREATOR = new Parcelable.Creator<ApicFrame>(){

        public ApicFrame createFromParcel(Parcel in) {
            return new ApicFrame(in);
        }

        public ApicFrame[] newArray(int size) {
            return new ApicFrame[size];
        }
    };

    public ApicFrame(String mimeType, @Nullable String description, int pictureType, byte[] pictureData) {
        super(ID);
        this.mimeType = mimeType;
        this.description = description;
        this.pictureType = pictureType;
        this.pictureData = pictureData;
    }

    ApicFrame(Parcel in) {
        super(ID);
        this.mimeType = Util.castNonNull(in.readString());
        this.description = in.readString();
        this.pictureType = in.readInt();
        this.pictureData = Util.castNonNull(in.createByteArray());
    }

    @Override
    public void populateMediaMetadata(MediaMetadata.Builder builder) {
        builder.maybeSetArtworkData(this.pictureData, this.pictureType);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApicFrame other = (ApicFrame)obj;
        return this.pictureType == other.pictureType && Util.areEqual(this.mimeType, other.mimeType) && Util.areEqual(this.description, other.description) && Arrays.equals(this.pictureData, other.pictureData);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.pictureType;
        result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.pictureData);
        return result;
    }

    @Override
    public String toString() {
        String string = this.id;
        String string2 = this.mimeType;
        String string3 = this.description;
        return new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(": mimeType=").append(string2).append(", description=").append(string3).toString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mimeType);
        dest.writeString(this.description);
        dest.writeInt(this.pictureType);
        dest.writeByteArray(this.pictureData);
    }
}

