/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.MediaMetadata;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.device.DeviceInfo;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.video.VideoSize;
import java.util.List;

public class ForwardingPlayer
implements Player {
    private final Player player;

    public ForwardingPlayer(Player player) {
        this.player = player;
    }

    @Override
    public Looper getApplicationLooper() {
        return this.player.getApplicationLooper();
    }

    @Override
    @Deprecated
    public void addListener(Player.EventListener listener) {
        this.player.addListener(new ForwardingEventListener(this, listener));
    }

    @Override
    public void addListener(Player.Listener listener) {
        this.player.addListener(new ForwardingListener(this, listener));
    }

    @Override
    @Deprecated
    public void removeListener(Player.EventListener listener) {
        this.player.removeListener(new ForwardingEventListener(this, listener));
    }

    @Override
    public void removeListener(Player.Listener listener) {
        this.player.removeListener(new ForwardingListener(this, listener));
    }

    @Override
    public void setMediaItems(List<MediaItem> mediaItems) {
        this.player.setMediaItems(mediaItems);
    }

    @Override
    public void setMediaItems(List<MediaItem> mediaItems, boolean resetPosition) {
        this.player.setMediaItems(mediaItems, resetPosition);
    }

    @Override
    public void setMediaItems(List<MediaItem> mediaItems, int startWindowIndex, long startPositionMs) {
        this.player.setMediaItems(mediaItems, startWindowIndex, startPositionMs);
    }

    @Override
    public void setMediaItem(MediaItem mediaItem) {
        this.player.setMediaItem(mediaItem);
    }

    @Override
    public void setMediaItem(MediaItem mediaItem, long startPositionMs) {
        this.player.setMediaItem(mediaItem, startPositionMs);
    }

    @Override
    public void setMediaItem(MediaItem mediaItem, boolean resetPosition) {
        this.player.setMediaItem(mediaItem, resetPosition);
    }

    @Override
    public void addMediaItem(MediaItem mediaItem) {
        this.player.addMediaItem(mediaItem);
    }

    @Override
    public void addMediaItem(int index, MediaItem mediaItem) {
        this.player.addMediaItem(index, mediaItem);
    }

    @Override
    public void addMediaItems(List<MediaItem> mediaItems) {
        this.player.addMediaItems(mediaItems);
    }

    @Override
    public void addMediaItems(int index, List<MediaItem> mediaItems) {
        this.player.addMediaItems(index, mediaItems);
    }

    @Override
    public void moveMediaItem(int currentIndex, int newIndex) {
        this.player.moveMediaItem(currentIndex, newIndex);
    }

    @Override
    public void moveMediaItems(int fromIndex, int toIndex, int newIndex) {
        this.player.moveMediaItems(fromIndex, toIndex, newIndex);
    }

    @Override
    public void removeMediaItem(int index) {
        this.player.removeMediaItem(index);
    }

    @Override
    public void removeMediaItems(int fromIndex, int toIndex) {
        this.player.removeMediaItems(fromIndex, toIndex);
    }

    @Override
    public void clearMediaItems() {
        this.player.clearMediaItems();
    }

    @Override
    public boolean isCommandAvailable(int command) {
        return this.player.isCommandAvailable(command);
    }

    @Override
    public Player.Commands getAvailableCommands() {
        return this.player.getAvailableCommands();
    }

    @Override
    public void prepare() {
        this.player.prepare();
    }

    @Override
    public int getPlaybackState() {
        return this.player.getPlaybackState();
    }

    @Override
    public int getPlaybackSuppressionReason() {
        return this.player.getPlaybackSuppressionReason();
    }

    @Override
    public boolean isPlaying() {
        return this.player.isPlaying();
    }

    @Override
    @Nullable
    public PlaybackException getPlayerError() {
        return this.player.getPlayerError();
    }

    @Override
    public void play() {
        this.player.play();
    }

    @Override
    public void pause() {
        this.player.pause();
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.player.setRepeatMode(repeatMode);
    }

    @Override
    public int getRepeatMode() {
        return this.player.getRepeatMode();
    }

    @Override
    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.player.setShuffleModeEnabled(shuffleModeEnabled);
    }

    @Override
    public boolean getShuffleModeEnabled() {
        return this.player.getShuffleModeEnabled();
    }

    @Override
    public boolean isLoading() {
        return this.player.isLoading();
    }

    @Override
    public void seekToDefaultPosition() {
        this.player.seekToDefaultPosition();
    }

    @Override
    public void seekToDefaultPosition(int windowIndex) {
        this.player.seekToDefaultPosition(windowIndex);
    }

    @Override
    public void seekTo(long positionMs) {
        this.player.seekTo(positionMs);
    }

    @Override
    public void seekTo(int windowIndex, long positionMs) {
        this.player.seekTo(windowIndex, positionMs);
    }

    @Override
    public long getSeekBackIncrement() {
        return this.player.getSeekBackIncrement();
    }

    @Override
    public void seekBack() {
        this.player.seekBack();
    }

    @Override
    public long getSeekForwardIncrement() {
        return this.player.getSeekForwardIncrement();
    }

    @Override
    public void seekForward() {
        this.player.seekForward();
    }

    @Override
    @Deprecated
    public boolean hasPrevious() {
        return this.player.hasPrevious();
    }

    @Override
    public boolean hasPreviousWindow() {
        return this.player.hasPreviousWindow();
    }

    @Override
    @Deprecated
    public void previous() {
        this.player.previous();
    }

    @Override
    public void seekToPreviousWindow() {
        this.player.seekToPreviousWindow();
    }

    @Override
    public void seekToPrevious() {
        this.player.seekToPrevious();
    }

    @Override
    public int getMaxSeekToPreviousPosition() {
        return this.player.getMaxSeekToPreviousPosition();
    }

    @Override
    @Deprecated
    public boolean hasNext() {
        return this.player.hasNext();
    }

    @Override
    public boolean hasNextWindow() {
        return this.player.hasNextWindow();
    }

    @Override
    @Deprecated
    public void next() {
        this.player.next();
    }

    @Override
    public void seekToNextWindow() {
        this.player.seekToNextWindow();
    }

    @Override
    public void seekToNext() {
        this.player.seekToNext();
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.player.setPlaybackParameters(playbackParameters);
    }

    @Override
    public void setPlaybackSpeed(float speed) {
        this.player.setPlaybackSpeed(speed);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.player.getPlaybackParameters();
    }

    @Override
    public void stop() {
        this.player.stop();
    }

    @Override
    @Deprecated
    public void stop(boolean reset) {
        this.player.stop(reset);
    }

    @Override
    public void release() {
        this.player.release();
    }

    @Override
    public TrackGroupArray getCurrentTrackGroups() {
        return this.player.getCurrentTrackGroups();
    }

    @Override
    public TrackSelectionArray getCurrentTrackSelections() {
        return this.player.getCurrentTrackSelections();
    }

    @Override
    @Deprecated
    public List<Metadata> getCurrentStaticMetadata() {
        return this.player.getCurrentStaticMetadata();
    }

    @Override
    public MediaMetadata getMediaMetadata() {
        return this.player.getMediaMetadata();
    }

    @Override
    public MediaMetadata getPlaylistMetadata() {
        return this.player.getPlaylistMetadata();
    }

    @Override
    public void setPlaylistMetadata(MediaMetadata mediaMetadata) {
        this.player.setPlaylistMetadata(mediaMetadata);
    }

    @Override
    @Nullable
    public Object getCurrentManifest() {
        return this.player.getCurrentManifest();
    }

    @Override
    public Timeline getCurrentTimeline() {
        return this.player.getCurrentTimeline();
    }

    @Override
    public int getCurrentPeriodIndex() {
        return this.player.getCurrentPeriodIndex();
    }

    @Override
    public int getCurrentWindowIndex() {
        return this.player.getCurrentWindowIndex();
    }

    @Override
    public int getNextWindowIndex() {
        return this.player.getNextWindowIndex();
    }

    @Override
    public int getPreviousWindowIndex() {
        return this.player.getPreviousWindowIndex();
    }

    @Override
    @Nullable
    public MediaItem getCurrentMediaItem() {
        return this.player.getCurrentMediaItem();
    }

    @Override
    public int getMediaItemCount() {
        return this.player.getMediaItemCount();
    }

    @Override
    public MediaItem getMediaItemAt(int index) {
        return this.player.getMediaItemAt(index);
    }

    @Override
    public long getDuration() {
        return this.player.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        return this.player.getBufferedPosition();
    }

    @Override
    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    @Override
    public long getTotalBufferedDuration() {
        return this.player.getTotalBufferedDuration();
    }

    @Override
    public boolean isCurrentWindowDynamic() {
        return this.player.isCurrentWindowDynamic();
    }

    @Override
    public boolean isCurrentWindowLive() {
        return this.player.isCurrentWindowLive();
    }

    @Override
    public long getCurrentLiveOffset() {
        return this.player.getCurrentLiveOffset();
    }

    @Override
    public boolean isCurrentWindowSeekable() {
        return this.player.isCurrentWindowSeekable();
    }

    @Override
    public boolean isPlayingAd() {
        return this.player.isPlayingAd();
    }

    @Override
    public int getCurrentAdGroupIndex() {
        return this.player.getCurrentAdGroupIndex();
    }

    @Override
    public int getCurrentAdIndexInAdGroup() {
        return this.player.getCurrentAdIndexInAdGroup();
    }

    @Override
    public long getContentDuration() {
        return this.player.getContentDuration();
    }

    @Override
    public long getContentPosition() {
        return this.player.getContentPosition();
    }

    @Override
    public long getContentBufferedPosition() {
        return this.player.getContentBufferedPosition();
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        return this.player.getAudioAttributes();
    }

    @Override
    public void setVolume(float audioVolume) {
        this.player.setVolume(audioVolume);
    }

    @Override
    public float getVolume() {
        return this.player.getVolume();
    }

    @Override
    public VideoSize getVideoSize() {
        return this.player.getVideoSize();
    }

    @Override
    public void clearVideoSurface() {
        this.player.clearVideoSurface();
    }

    @Override
    public void clearVideoSurface(@Nullable Surface surface) {
        this.player.clearVideoSurface(surface);
    }

    @Override
    public void setVideoSurface(@Nullable Surface surface) {
        this.player.setVideoSurface(surface);
    }

    @Override
    public void setVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.player.setVideoSurfaceHolder(surfaceHolder);
    }

    @Override
    public void clearVideoSurfaceHolder(@Nullable SurfaceHolder surfaceHolder) {
        this.player.clearVideoSurfaceHolder(surfaceHolder);
    }

    @Override
    public void setVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.player.setVideoSurfaceView(surfaceView);
    }

    @Override
    public void clearVideoSurfaceView(@Nullable SurfaceView surfaceView) {
        this.player.clearVideoSurfaceView(surfaceView);
    }

    @Override
    public void setVideoTextureView(@Nullable TextureView textureView) {
        this.player.setVideoTextureView(textureView);
    }

    @Override
    public void clearVideoTextureView(@Nullable TextureView textureView) {
        this.player.clearVideoTextureView(textureView);
    }

    @Override
    public List<Cue> getCurrentCues() {
        return this.player.getCurrentCues();
    }

    @Override
    public DeviceInfo getDeviceInfo() {
        return this.player.getDeviceInfo();
    }

    @Override
    public int getDeviceVolume() {
        return this.player.getDeviceVolume();
    }

    @Override
    public boolean isDeviceMuted() {
        return this.player.isDeviceMuted();
    }

    @Override
    public void setDeviceVolume(int volume) {
        this.player.setDeviceVolume(volume);
    }

    @Override
    public void increaseDeviceVolume() {
        this.player.increaseDeviceVolume();
    }

    @Override
    public void decreaseDeviceVolume() {
        this.player.decreaseDeviceVolume();
    }

    @Override
    public void setDeviceMuted(boolean muted) {
        this.player.setDeviceMuted(muted);
    }

    public Player getWrappedPlayer() {
        return this.player;
    }

    private static final class ForwardingListener
    extends ForwardingEventListener
    implements Player.Listener {
        private final Player.Listener listener;

        public ForwardingListener(ForwardingPlayer forwardingPlayer, Player.Listener listener) {
            super(forwardingPlayer, listener);
            this.listener = listener;
        }

        @Override
        public void onVideoSizeChanged(VideoSize videoSize) {
            this.listener.onVideoSizeChanged(videoSize);
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            this.listener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        }

        @Override
        public void onSurfaceSizeChanged(int width, int height) {
            this.listener.onSurfaceSizeChanged(width, height);
        }

        @Override
        public void onRenderedFirstFrame() {
            this.listener.onRenderedFirstFrame();
        }

        @Override
        public void onAudioSessionIdChanged(int audioSessionId) {
            this.listener.onAudioSessionIdChanged(audioSessionId);
        }

        @Override
        public void onAudioAttributesChanged(AudioAttributes audioAttributes) {
            this.listener.onAudioAttributesChanged(audioAttributes);
        }

        @Override
        public void onVolumeChanged(float volume) {
            this.listener.onVolumeChanged(volume);
        }

        @Override
        public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
            this.listener.onSkipSilenceEnabledChanged(skipSilenceEnabled);
        }

        @Override
        public void onCues(List<Cue> cues) {
            this.listener.onCues(cues);
        }

        @Override
        public void onMetadata(Metadata metadata) {
            this.listener.onMetadata(metadata);
        }

        @Override
        public void onDeviceInfoChanged(DeviceInfo deviceInfo) {
            this.listener.onDeviceInfoChanged(deviceInfo);
        }

        @Override
        public void onDeviceVolumeChanged(int volume, boolean muted) {
            this.listener.onDeviceVolumeChanged(volume, muted);
        }
    }

    private static class ForwardingEventListener
    implements Player.EventListener {
        private final ForwardingPlayer forwardingPlayer;
        private final Player.EventListener eventListener;

        private ForwardingEventListener(ForwardingPlayer forwardingPlayer, Player.EventListener eventListener) {
            this.forwardingPlayer = forwardingPlayer;
            this.eventListener = eventListener;
        }

        @Override
        public void onTimelineChanged(Timeline timeline, int reason) {
            this.eventListener.onTimelineChanged(timeline, reason);
        }

        @Override
        public void onMediaItemTransition(@Nullable MediaItem mediaItem, int reason) {
            this.eventListener.onMediaItemTransition(mediaItem, reason);
        }

        @Override
        public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
            this.eventListener.onTracksChanged(trackGroups, trackSelections);
        }

        @Override
        @Deprecated
        public void onStaticMetadataChanged(List<Metadata> metadataList) {
            this.eventListener.onStaticMetadataChanged(metadataList);
        }

        @Override
        public void onMediaMetadataChanged(MediaMetadata mediaMetadata) {
            this.eventListener.onMediaMetadataChanged(mediaMetadata);
        }

        @Override
        public void onPlaylistMetadataChanged(MediaMetadata mediaMetadata) {
            this.eventListener.onPlaylistMetadataChanged(mediaMetadata);
        }

        @Override
        public void onIsLoadingChanged(boolean isLoading) {
            this.eventListener.onIsLoadingChanged(isLoading);
        }

        @Override
        public void onLoadingChanged(boolean isLoading) {
            this.eventListener.onIsLoadingChanged(isLoading);
        }

        @Override
        public void onAvailableCommandsChanged(Player.Commands availableCommands) {
            this.eventListener.onAvailableCommandsChanged(availableCommands);
        }

        @Override
        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            this.eventListener.onPlayerStateChanged(playWhenReady, playbackState);
        }

        @Override
        public void onPlaybackStateChanged(int playbackState) {
            this.eventListener.onPlaybackStateChanged(playbackState);
        }

        @Override
        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            this.eventListener.onPlayWhenReadyChanged(playWhenReady, reason);
        }

        @Override
        public void onPlaybackSuppressionReasonChanged(int playbackSuppressionReason) {
            this.eventListener.onPlaybackSuppressionReasonChanged(playbackSuppressionReason);
        }

        @Override
        public void onIsPlayingChanged(boolean isPlaying) {
            this.eventListener.onIsPlayingChanged(isPlaying);
        }

        @Override
        public void onRepeatModeChanged(int repeatMode) {
            this.eventListener.onRepeatModeChanged(repeatMode);
        }

        @Override
        public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
            this.eventListener.onShuffleModeEnabledChanged(shuffleModeEnabled);
        }

        @Override
        public void onPlayerError(PlaybackException error) {
            this.eventListener.onPlayerError(error);
        }

        @Override
        public void onPlayerErrorChanged(@Nullable PlaybackException error) {
            this.eventListener.onPlayerErrorChanged(error);
        }

        @Override
        public void onPositionDiscontinuity(int reason) {
            this.eventListener.onPositionDiscontinuity(reason);
        }

        @Override
        public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
            this.eventListener.onPositionDiscontinuity(oldPosition, newPosition, reason);
        }

        @Override
        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
            this.eventListener.onPlaybackParametersChanged(playbackParameters);
        }

        @Override
        public void onSeekBackIncrementChanged(long seekBackIncrementMs) {
            this.eventListener.onSeekBackIncrementChanged(seekBackIncrementMs);
        }

        @Override
        public void onSeekForwardIncrementChanged(long seekForwardIncrementMs) {
            this.eventListener.onSeekForwardIncrementChanged(seekForwardIncrementMs);
        }

        @Override
        public void onMaxSeekToPreviousPositionChanged(int maxSeekToPreviousPositionMs) {
            this.eventListener.onMaxSeekToPreviousPositionChanged(maxSeekToPreviousPositionMs);
        }

        @Override
        public void onSeekProcessed() {
            this.eventListener.onSeekProcessed();
        }

        @Override
        public void onEvents(Player player, Player.Events events) {
            this.eventListener.onEvents(this.forwardingPlayer, events);
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ForwardingEventListener)) {
                return false;
            }
            ForwardingEventListener that = (ForwardingEventListener)o;
            if (!this.forwardingPlayer.equals(that.forwardingPlayer)) {
                return false;
            }
            return this.eventListener.equals(that.eventListener);
        }

        public int hashCode() {
            int result = this.forwardingPlayer.hashCode();
            result = 31 * result + this.eventListener.hashCode();
            return result;
        }
    }
}

