/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.util.SparseBooleanArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;

public final class FlagSet {
    private final SparseBooleanArray flags;

    private FlagSet(SparseBooleanArray flags) {
        this.flags = flags;
    }

    public boolean contains(int flag) {
        return this.flags.get(flag);
    }

    public boolean containsAny(int ... flags) {
        for (int flag : flags) {
            if (!this.contains(flag)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.flags.size();
    }

    public int get(int index) {
        Assertions.checkIndex(index, 0, this.size());
        return this.flags.keyAt(index);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlagSet)) {
            return false;
        }
        FlagSet that = (FlagSet)o;
        return this.flags.equals((Object)that.flags);
    }

    public int hashCode() {
        return this.flags.hashCode();
    }

    public static final class Builder {
        private final SparseBooleanArray flags = new SparseBooleanArray();
        private boolean buildCalled;

        public Builder add(int flag) {
            Assertions.checkState(!this.buildCalled);
            this.flags.append(flag, true);
            return this;
        }

        public Builder addIf(int flag, boolean condition) {
            if (condition) {
                return this.add(flag);
            }
            return this;
        }

        public Builder addAll(int ... flags) {
            for (int flag : flags) {
                this.add(flag);
            }
            return this;
        }

        public Builder addAll(FlagSet flags) {
            for (int i = 0; i < flags.size(); ++i) {
                this.add(flags.get(i));
            }
            return this;
        }

        public Builder remove(int flag) {
            Assertions.checkState(!this.buildCalled);
            this.flags.delete(flag);
            return this;
        }

        public Builder removeIf(int flag, boolean condition) {
            if (condition) {
                return this.remove(flag);
            }
            return this;
        }

        public Builder removeAll(int ... flags) {
            for (int flag : flags) {
                this.remove(flag);
            }
            return this;
        }

        public FlagSet build() {
            Assertions.checkState(!this.buildCalled);
            this.buildCalled = true;
            return new FlagSet(this.flags);
        }
    }
}

