/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public final class BundleableUtils {
    @Nullable
    public static Bundle toNullableBundle(@Nullable Bundleable bundleable) {
        return bundleable == null ? null : bundleable.toBundle();
    }

    @Nullable
    public static <T extends Bundleable> T fromNullableBundle(Bundleable.Creator<T> creator, @Nullable Bundle bundle) {
        return bundle == null ? null : (T)creator.fromBundle(bundle);
    }

    public static <T extends Bundleable> T fromNullableBundle(Bundleable.Creator<T> creator, @Nullable Bundle bundle, T defaultValue) {
        return bundle == null ? defaultValue : creator.fromBundle(bundle);
    }

    public static <T extends Bundleable> ImmutableList<Bundle> toBundleList(List<T> bundleableList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < bundleableList.size(); ++i) {
            Bundleable bundleable = (Bundleable)bundleableList.get(i);
            builder.add((Object)bundleable.toBundle());
        }
        return builder.build();
    }

    public static <T extends Bundleable> ImmutableList<T> fromBundleList(Bundleable.Creator<T> creator, List<Bundle> bundleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < bundleList.size(); ++i) {
            Bundle bundle = bundleList.get(i);
            T bundleable = creator.fromBundle(bundle);
            builder.add(bundleable);
        }
        return builder.build();
    }

    public static <T extends Bundleable> ArrayList<Bundle> toBundleArrayList(List<T> bundleableList) {
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(bundleableList.size());
        for (int i = 0; i < bundleableList.size(); ++i) {
            arrayList.add(((Bundleable)bundleableList.get(i)).toBundle());
        }
        return arrayList;
    }

    private BundleableUtils() {
    }
}

