/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PlaybackException
extends Exception
implements Bundleable {
    public static final int ERROR_CODE_UNSPECIFIED = 1000;
    public static final int ERROR_CODE_REMOTE_ERROR = 1001;
    public static final int ERROR_CODE_BEHIND_LIVE_WINDOW = 1002;
    public static final int ERROR_CODE_TIMEOUT = 1003;
    public static final int ERROR_CODE_FAILED_RUNTIME_CHECK = 1004;
    public static final int ERROR_CODE_IO_UNSPECIFIED = 2000;
    public static final int ERROR_CODE_IO_NETWORK_CONNECTION_FAILED = 2001;
    public static final int ERROR_CODE_IO_NETWORK_CONNECTION_TIMEOUT = 2002;
    public static final int ERROR_CODE_IO_INVALID_HTTP_CONTENT_TYPE = 2003;
    public static final int ERROR_CODE_IO_BAD_HTTP_STATUS = 2004;
    public static final int ERROR_CODE_IO_FILE_NOT_FOUND = 2005;
    public static final int ERROR_CODE_IO_NO_PERMISSION = 2006;
    public static final int ERROR_CODE_IO_CLEARTEXT_NOT_PERMITTED = 2007;
    public static final int ERROR_CODE_IO_READ_POSITION_OUT_OF_RANGE = 2008;
    public static final int ERROR_CODE_PARSING_CONTAINER_MALFORMED = 3001;
    public static final int ERROR_CODE_PARSING_MANIFEST_MALFORMED = 3002;
    public static final int ERROR_CODE_PARSING_CONTAINER_UNSUPPORTED = 3003;
    public static final int ERROR_CODE_PARSING_MANIFEST_UNSUPPORTED = 3004;
    public static final int ERROR_CODE_DECODER_INIT_FAILED = 4001;
    public static final int ERROR_CODE_DECODER_QUERY_FAILED = 4002;
    public static final int ERROR_CODE_DECODING_FAILED = 4003;
    public static final int ERROR_CODE_DECODING_FORMAT_EXCEEDS_CAPABILITIES = 4004;
    public static final int ERROR_CODE_DECODING_FORMAT_UNSUPPORTED = 4005;
    public static final int ERROR_CODE_AUDIO_TRACK_INIT_FAILED = 5001;
    public static final int ERROR_CODE_AUDIO_TRACK_WRITE_FAILED = 5002;
    public static final int ERROR_CODE_DRM_UNSPECIFIED = 6000;
    public static final int ERROR_CODE_DRM_SCHEME_UNSUPPORTED = 6001;
    public static final int ERROR_CODE_DRM_PROVISIONING_FAILED = 6002;
    public static final int ERROR_CODE_DRM_CONTENT_ERROR = 6003;
    public static final int ERROR_CODE_DRM_LICENSE_ACQUISITION_FAILED = 6004;
    public static final int ERROR_CODE_DRM_DISALLOWED_OPERATION = 6005;
    public static final int ERROR_CODE_DRM_SYSTEM_ERROR = 6006;
    public static final int ERROR_CODE_DRM_DEVICE_REVOKED = 6007;
    public static final int ERROR_CODE_DRM_LICENSE_EXPIRED = 6008;
    public static final int CUSTOM_ERROR_CODE_BASE = 1000000;
    public final int errorCode;
    public final long timestampMs;
    private static final int FIELD_INT_ERROR_CODE = 0;
    private static final int FIELD_LONG_TIMESTAMP_MS = 1;
    private static final int FIELD_STRING_MESSAGE = 2;
    private static final int FIELD_STRING_CAUSE_CLASS_NAME = 3;
    private static final int FIELD_STRING_CAUSE_MESSAGE = 4;
    protected static final int FIELD_CUSTOM_ID_BASE = 1000;
    public static final Bundleable.Creator<PlaybackException> CREATOR = PlaybackException::new;

    public static String getErrorCodeName(int errorCode) {
        switch (errorCode) {
            case 1000: {
                return "ERROR_CODE_UNSPECIFIED";
            }
            case 1001: {
                return "ERROR_CODE_REMOTE_ERROR";
            }
            case 1002: {
                return "ERROR_CODE_BEHIND_LIVE_WINDOW";
            }
            case 1003: {
                return "ERROR_CODE_TIMEOUT";
            }
            case 1004: {
                return "ERROR_CODE_FAILED_RUNTIME_CHECK";
            }
            case 2000: {
                return "ERROR_CODE_IO_UNSPECIFIED";
            }
            case 2001: {
                return "ERROR_CODE_IO_NETWORK_CONNECTION_FAILED";
            }
            case 2002: {
                return "ERROR_CODE_IO_NETWORK_CONNECTION_TIMEOUT";
            }
            case 2003: {
                return "ERROR_CODE_IO_INVALID_HTTP_CONTENT_TYPE";
            }
            case 2004: {
                return "ERROR_CODE_IO_BAD_HTTP_STATUS";
            }
            case 2005: {
                return "ERROR_CODE_IO_FILE_NOT_FOUND";
            }
            case 2006: {
                return "ERROR_CODE_IO_NO_PERMISSION";
            }
            case 2007: {
                return "ERROR_CODE_IO_CLEARTEXT_NOT_PERMITTED";
            }
            case 2008: {
                return "ERROR_CODE_IO_READ_POSITION_OUT_OF_RANGE";
            }
            case 3001: {
                return "ERROR_CODE_PARSING_CONTAINER_MALFORMED";
            }
            case 3002: {
                return "ERROR_CODE_PARSING_MANIFEST_MALFORMED";
            }
            case 3003: {
                return "ERROR_CODE_PARSING_CONTAINER_UNSUPPORTED";
            }
            case 3004: {
                return "ERROR_CODE_PARSING_MANIFEST_UNSUPPORTED";
            }
            case 4001: {
                return "ERROR_CODE_DECODER_INIT_FAILED";
            }
            case 4002: {
                return "ERROR_CODE_DECODER_QUERY_FAILED";
            }
            case 4003: {
                return "ERROR_CODE_DECODING_FAILED";
            }
            case 4004: {
                return "ERROR_CODE_DECODING_FORMAT_EXCEEDS_CAPABILITIES";
            }
            case 4005: {
                return "ERROR_CODE_DECODING_FORMAT_UNSUPPORTED";
            }
            case 5001: {
                return "ERROR_CODE_AUDIO_TRACK_INIT_FAILED";
            }
            case 5002: {
                return "ERROR_CODE_AUDIO_TRACK_WRITE_FAILED";
            }
            case 6000: {
                return "ERROR_CODE_DRM_UNSPECIFIED";
            }
            case 6001: {
                return "ERROR_CODE_DRM_SCHEME_UNSUPPORTED";
            }
            case 6002: {
                return "ERROR_CODE_DRM_PROVISIONING_FAILED";
            }
            case 6003: {
                return "ERROR_CODE_DRM_CONTENT_ERROR";
            }
            case 6004: {
                return "ERROR_CODE_DRM_LICENSE_ACQUISITION_FAILED";
            }
            case 6005: {
                return "ERROR_CODE_DRM_DISALLOWED_OPERATION";
            }
            case 6006: {
                return "ERROR_CODE_DRM_SYSTEM_ERROR";
            }
            case 6007: {
                return "ERROR_CODE_DRM_DEVICE_REVOKED";
            }
            case 6008: {
                return "ERROR_CODE_DRM_LICENSE_EXPIRED";
            }
        }
        if (errorCode >= 1000000) {
            return "custom error code";
        }
        return "invalid error code";
    }

    public final String getErrorCodeName() {
        return PlaybackException.getErrorCodeName(this.errorCode);
    }

    public PlaybackException(@Nullable String message, @Nullable Throwable cause, int errorCode) {
        this(message, cause, errorCode, Clock.DEFAULT.elapsedRealtime());
    }

    protected PlaybackException(Bundle bundle) {
        this(bundle.getString(PlaybackException.keyForField(2)), PlaybackException.getCauseFromBundle(bundle), bundle.getInt(PlaybackException.keyForField(0), 1000), bundle.getLong(PlaybackException.keyForField(1), SystemClock.elapsedRealtime()));
    }

    protected PlaybackException(@Nullable String message, @Nullable Throwable cause, int errorCode, long timestampMs) {
        super(message, cause);
        this.errorCode = errorCode;
        this.timestampMs = timestampMs;
    }

    @CallSuper
    public boolean errorInfoEquals(@Nullable PlaybackException other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Throwable thisCause = this.getCause();
        Throwable thatCause = other.getCause();
        if (thisCause != null && thatCause != null) {
            if (!Util.areEqual(thisCause.getMessage(), thatCause.getMessage())) {
                return false;
            }
            if (!Util.areEqual(thisCause.getClass(), thatCause.getClass())) {
                return false;
            }
        } else if (thisCause != null || thatCause != null) {
            return false;
        }
        return this.errorCode == other.errorCode && Util.areEqual(this.getMessage(), other.getMessage()) && this.timestampMs == other.timestampMs;
    }

    @Override
    @CallSuper
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(PlaybackException.keyForField(0), this.errorCode);
        bundle.putLong(PlaybackException.keyForField(1), this.timestampMs);
        bundle.putString(PlaybackException.keyForField(2), this.getMessage());
        Throwable cause = this.getCause();
        if (cause != null) {
            bundle.putString(PlaybackException.keyForField(3), cause.getClass().getName());
            bundle.putString(PlaybackException.keyForField(4), cause.getMessage());
        }
        return bundle;
    }

    protected static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    private static Throwable createThrowable(Class<?> clazz, @Nullable String message) throws Exception {
        return (Throwable)clazz.getConstructor(String.class).newInstance(message);
    }

    private static RemoteException createRemoteException(@Nullable String message) {
        return new RemoteException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Throwable getCauseFromBundle(Bundle bundle) {
        String causeClassName = bundle.getString(PlaybackException.keyForField(3));
        String causeMessage = bundle.getString(PlaybackException.keyForField(4));
        Throwable cause = null;
        if (!TextUtils.isEmpty((CharSequence)causeClassName)) {
            try {
                Class<?> clazz = Class.forName(causeClassName, true, PlaybackException.class.getClassLoader());
                if (Throwable.class.isAssignableFrom(clazz)) {
                    cause = PlaybackException.createThrowable(clazz, causeMessage);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (cause == null) {
                    cause = PlaybackException.createRemoteException(causeMessage);
                }
            }
        }
        return cause;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

