/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CodecSpecificDataUtil {
    private static final byte[] NAL_START_CODE = new byte[]{0, 0, 0, 1};

    public static Pair<Integer, Integer> parseAlacAudioSpecificConfig(byte[] audioSpecificConfig) {
        ParsableByteArray byteArray = new ParsableByteArray(audioSpecificConfig);
        byteArray.setPosition(9);
        int channelCount = byteArray.readUnsignedByte();
        byteArray.setPosition(20);
        int sampleRate = byteArray.readUnsignedIntToInt();
        return Pair.create((Object)sampleRate, (Object)channelCount);
    }

    public static List<byte[]> buildCea708InitializationData(boolean isWideAspectRatio) {
        byte[] byArray;
        if (isWideAspectRatio) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 1;
        } else {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        }
        return Collections.singletonList(byArray);
    }

    public static boolean parseCea708InitializationData(List<byte[]> initializationData) {
        return initializationData.size() == 1 && initializationData.get(0).length == 1 && initializationData.get(0)[0] == 1;
    }

    public static String buildAvcCodecString(int profileIdc, int constraintsFlagsAndReservedZero2Bits, int levelIdc) {
        return String.format("avc1.%02X%02X%02X", profileIdc, constraintsFlagsAndReservedZero2Bits, levelIdc);
    }

    public static byte[] buildNalUnit(byte[] data, int offset, int length) {
        byte[] nalUnit = new byte[length + NAL_START_CODE.length];
        System.arraycopy(NAL_START_CODE, 0, nalUnit, 0, NAL_START_CODE.length);
        System.arraycopy(data, offset, nalUnit, NAL_START_CODE.length, length);
        return nalUnit;
    }

    @Nullable
    public static byte[][] splitNalUnits(byte[] data) {
        if (!CodecSpecificDataUtil.isNalStartCode(data, 0)) {
            return null;
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int nalUnitIndex = 0;
        do {
            starts.add(nalUnitIndex);
        } while ((nalUnitIndex = CodecSpecificDataUtil.findNalStartCode(data, nalUnitIndex + NAL_START_CODE.length)) != -1);
        byte[][] split = new byte[starts.size()][];
        for (int i = 0; i < starts.size(); ++i) {
            int startIndex = (Integer)starts.get(i);
            int endIndex = i < starts.size() - 1 ? (Integer)starts.get(i + 1) : data.length;
            byte[] nal = new byte[endIndex - startIndex];
            System.arraycopy(data, startIndex, nal, 0, nal.length);
            split[i] = nal;
        }
        return split;
    }

    private static int findNalStartCode(byte[] data, int index) {
        int endIndex = data.length - NAL_START_CODE.length;
        for (int i = index; i <= endIndex; ++i) {
            if (!CodecSpecificDataUtil.isNalStartCode(data, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isNalStartCode(byte[] data, int index) {
        if (data.length - index <= NAL_START_CODE.length) {
            return false;
        }
        for (int j = 0; j < NAL_START_CODE.length; ++j) {
            if (data[index + j] == NAL_START_CODE[j]) continue;
            return false;
        }
        return true;
    }

    private CodecSpecificDataUtil() {
    }
}

