/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.os.PersistableBundle;
import android.util.Base64;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.JobInfoSchedulerService;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.SchedulerConfig;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.util.PriorityMapping;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.zip.Adler32;

@RequiresApi(api=21)
public class JobInfoScheduler
implements WorkScheduler {
    private static final String LOG_TAG = "JobInfoScheduler";
    static final String ATTEMPT_NUMBER = "attemptNumber";
    static final String BACKEND_NAME = "backendName";
    static final String EVENT_PRIORITY = "priority";
    static final String EXTRAS = "extras";
    private final Context context;
    private final EventStore eventStore;
    private final SchedulerConfig config;

    public JobInfoScheduler(Context applicationContext, EventStore eventStore, SchedulerConfig config) {
        this.context = applicationContext;
        this.eventStore = eventStore;
        this.config = config;
    }

    @VisibleForTesting
    int getJobId(TransportContext transportContext) {
        Adler32 checksum = new Adler32();
        checksum.update(this.context.getPackageName().getBytes(Charset.forName("UTF-8")));
        checksum.update(transportContext.getBackendName().getBytes(Charset.forName("UTF-8")));
        checksum.update(ByteBuffer.allocate(4).putInt(PriorityMapping.toInt(transportContext.getPriority())).array());
        if (transportContext.getExtras() != null) {
            checksum.update(transportContext.getExtras());
        }
        return (int)checksum.getValue();
    }

    private boolean isJobServiceOn(JobScheduler scheduler, int jobId, int attemptNumber) {
        for (JobInfo jobInfo : scheduler.getAllPendingJobs()) {
            int existingAttemptNumber = jobInfo.getExtras().getInt(ATTEMPT_NUMBER);
            if (jobInfo.getId() != jobId) continue;
            return existingAttemptNumber >= attemptNumber;
        }
        return false;
    }

    @Override
    public void schedule(TransportContext transportContext, int attemptNumber) {
        this.schedule(transportContext, attemptNumber, false);
    }

    @Override
    public void schedule(TransportContext transportContext, int attemptNumber, boolean force) {
        ComponentName serviceComponent = new ComponentName(this.context, JobInfoSchedulerService.class);
        JobScheduler jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
        int jobId = this.getJobId(transportContext);
        if (!force && this.isJobServiceOn(jobScheduler, jobId, attemptNumber)) {
            Logging.d(LOG_TAG, "Upload for context %s is already scheduled. Returning...", (Object)transportContext);
            return;
        }
        long nextCallTime = this.eventStore.getNextCallTime(transportContext);
        boolean hasPendingEvents = force && this.eventStore.hasPendingEventsFor(transportContext);
        JobInfo.Builder builder = this.config.configureJob(new JobInfo.Builder(jobId, serviceComponent), transportContext.getPriority(), nextCallTime, attemptNumber, hasPendingEvents);
        PersistableBundle bundle = new PersistableBundle();
        bundle.putInt(ATTEMPT_NUMBER, attemptNumber);
        bundle.putString(BACKEND_NAME, transportContext.getBackendName());
        bundle.putInt(EVENT_PRIORITY, PriorityMapping.toInt(transportContext.getPriority()));
        if (transportContext.getExtras() != null) {
            bundle.putString(EXTRAS, Base64.encodeToString((byte[])transportContext.getExtras(), (int)0));
        }
        builder.setExtras(bundle);
        Logging.d(LOG_TAG, "Scheduling upload for context %s with jobId=%d in %dms(Backend next call timestamp %d). Attempt %d", transportContext, jobId, this.config.getScheduleDelay(transportContext.getPriority(), nextCallTime, attemptNumber, hasPendingEvents), nextCallTime, attemptNumber);
        jobScheduler.schedule(builder.build());
    }
}

