/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import com.google.android.datatransport.runtime.logging.Logging;
import java.util.concurrent.Executor;

class SafeLoggingExecutor
implements Executor {
    private final Executor delegate;

    SafeLoggingExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(new SafeLoggingRunnable(command));
    }

    static class SafeLoggingRunnable
    implements Runnable {
        private final Runnable delegate;

        SafeLoggingRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Exception e) {
                Logging.e("Executor", "Background execution failure.", e);
            }
        }
    }
}

