/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.backends;

import androidx.annotation.Nullable;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import java.util.Arrays;

final class AutoValue_BackendRequest
extends BackendRequest {
    private final Iterable<EventInternal> events;
    private final byte[] extras;

    private AutoValue_BackendRequest(Iterable<EventInternal> events, @Nullable byte[] extras) {
        this.events = events;
        this.extras = extras;
    }

    @Override
    public Iterable<EventInternal> getEvents() {
        return this.events;
    }

    @Override
    @Nullable
    public byte[] getExtras() {
        return this.extras;
    }

    public String toString() {
        return "BackendRequest{events=" + this.events + ", extras=" + Arrays.toString(this.extras) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackendRequest) {
            BackendRequest that = (BackendRequest)o;
            return this.events.equals(that.getEvents()) && Arrays.equals(this.extras, that instanceof AutoValue_BackendRequest ? ((AutoValue_BackendRequest)that).extras : that.getExtras());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.events.hashCode();
        h$ *= 1000003;
        return h$ ^= Arrays.hashCode(this.extras);
    }

    static final class Builder
    extends BackendRequest.Builder {
        private Iterable<EventInternal> events;
        private byte[] extras;

        Builder() {
        }

        @Override
        public BackendRequest.Builder setEvents(Iterable<EventInternal> events) {
            if (events == null) {
                throw new NullPointerException("Null events");
            }
            this.events = events;
            return this;
        }

        @Override
        public BackendRequest.Builder setExtras(@Nullable byte[] extras) {
            this.extras = extras;
            return this;
        }

        @Override
        public BackendRequest build() {
            String missing = "";
            if (this.events == null) {
                missing = missing + " events";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BackendRequest(this.events, this.extras);
        }
    }
}

