/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime.scheduling.jobscheduling;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.datatransport.runtime.EventInternal;
import com.google.android.datatransport.runtime.TransportContext;
import com.google.android.datatransport.runtime.backends.BackendRegistry;
import com.google.android.datatransport.runtime.backends.BackendRequest;
import com.google.android.datatransport.runtime.backends.BackendResponse;
import com.google.android.datatransport.runtime.backends.TransportBackend;
import com.google.android.datatransport.runtime.logging.Logging;
import com.google.android.datatransport.runtime.scheduling.jobscheduling.WorkScheduler;
import com.google.android.datatransport.runtime.scheduling.persistence.EventStore;
import com.google.android.datatransport.runtime.scheduling.persistence.PersistedEvent;
import com.google.android.datatransport.runtime.synchronization.SynchronizationException;
import com.google.android.datatransport.runtime.synchronization.SynchronizationGuard;
import com.google.android.datatransport.runtime.time.Clock;
import com.google.android.datatransport.runtime.time.WallTime;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class Uploader {
    private static final String LOG_TAG = "Uploader";
    private final Context context;
    private final BackendRegistry backendRegistry;
    private final EventStore eventStore;
    private final WorkScheduler workScheduler;
    private final Executor executor;
    private final SynchronizationGuard guard;
    private final Clock clock;

    @Inject
    public Uploader(Context context, BackendRegistry backendRegistry, EventStore eventStore, WorkScheduler workScheduler, Executor executor, SynchronizationGuard guard, @WallTime Clock clock) {
        this.context = context;
        this.backendRegistry = backendRegistry;
        this.eventStore = eventStore;
        this.workScheduler = workScheduler;
        this.executor = executor;
        this.guard = guard;
        this.clock = clock;
    }

    boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public void upload(TransportContext transportContext, int attemptNumber, Runnable callback) {
        this.executor.execute(() -> {
            try {
                this.guard.runCriticalSection(this.eventStore::cleanUp);
                if (!this.isNetworkAvailable()) {
                    this.guard.runCriticalSection(() -> {
                        this.workScheduler.schedule(transportContext, attemptNumber + 1);
                        return null;
                    });
                } else {
                    this.logAndUpdateState(transportContext, attemptNumber);
                }
            }
            catch (SynchronizationException e) {
                this.workScheduler.schedule(transportContext, attemptNumber + 1);
            }
            finally {
                callback.run();
            }
        });
    }

    void logAndUpdateState(TransportContext transportContext, int attemptNumber) {
        BackendResponse response;
        TransportBackend backend = this.backendRegistry.get(transportContext.getBackendName());
        Iterable persistedEvents = this.guard.runCriticalSection(() -> this.eventStore.loadBatch(transportContext));
        if (!persistedEvents.iterator().hasNext()) {
            return;
        }
        if (backend == null) {
            Logging.d(LOG_TAG, "Unknown backend for %s, deleting event batch for it...", (Object)transportContext);
            response = BackendResponse.fatalError();
        } else {
            ArrayList<EventInternal> eventInternals = new ArrayList<EventInternal>();
            for (PersistedEvent persistedEvent : persistedEvents) {
                eventInternals.add(persistedEvent.getEvent());
            }
            response = backend.send(BackendRequest.builder().setEvents(eventInternals).setExtras(transportContext.getExtras()).build());
        }
        this.guard.runCriticalSection(() -> {
            if (response.getStatus() == BackendResponse.Status.TRANSIENT_ERROR) {
                this.eventStore.recordFailure(persistedEvents);
                this.workScheduler.schedule(transportContext, attemptNumber + 1);
            } else {
                this.eventStore.recordSuccess(persistedEvents);
                if (response.getStatus() == BackendResponse.Status.OK) {
                    this.eventStore.recordNextCallTime(transportContext, this.clock.getTime() + response.getNextRequestWaitMillis());
                }
                if (this.eventStore.hasPendingEventsFor(transportContext)) {
                    this.workScheduler.schedule(transportContext, 1, true);
                }
            }
            return null;
        });
    }
}

