/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.agera.database;

import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import com.google.android.agera.Function;
import com.google.android.agera.Merger;
import com.google.android.agera.Preconditions;
import com.google.android.agera.Result;
import com.google.android.agera.Supplier;
import com.google.android.agera.database.SqlDeleteRequest;
import com.google.android.agera.database.SqlInsertRequest;
import com.google.android.agera.database.SqlRequest;
import com.google.android.agera.database.SqlUpdateRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SqlDatabaseFunctions {
    @NonNull
    public static <T> Function<SqlRequest, Result<List<T>>> databaseQueryFunction(@NonNull Supplier<Result<SQLiteDatabase>> database, @NonNull Function<Cursor, T> rowMap) {
        return new DatabaseFunction<SqlRequest, List<T>>(database, new DatabaseQueryMerger(rowMap));
    }

    @NonNull
    public static Function<SqlInsertRequest, Result<Long>> databaseInsertFunction(@NonNull Supplier<Result<SQLiteDatabase>> database) {
        return new DatabaseFunction<SqlInsertRequest, Long>(database, new DatabaseInsertMerger());
    }

    @NonNull
    public static Function<SqlUpdateRequest, Result<Integer>> databaseUpdateFunction(@NonNull Supplier<Result<SQLiteDatabase>> database) {
        return new DatabaseFunction<SqlUpdateRequest, Integer>(database, new DatabaseUpdateMerger());
    }

    @NonNull
    public static Function<SqlDeleteRequest, Result<Integer>> databaseDeleteFunction(@NonNull Supplier<Result<SQLiteDatabase>> database) {
        return new DatabaseFunction<SqlDeleteRequest, Integer>(database, new DatabaseDeleteMerger());
    }

    private SqlDatabaseFunctions() {
    }

    static final class DatabaseFunction<R, T>
    implements Function<R, Result<T>> {
        @NonNull
        private final Supplier<Result<SQLiteDatabase>> databaseSupplier;
        @NonNull
        private final Merger<SQLiteDatabase, R, Result<T>> databaseWithSqlArgument;

        DatabaseFunction(@NonNull Supplier<Result<SQLiteDatabase>> databaseSupplier, @NonNull Merger<SQLiteDatabase, R, Result<T>> databaseWithSqlArgumentMerger) {
            this.databaseSupplier = (Supplier)Preconditions.checkNotNull(databaseSupplier);
            this.databaseWithSqlArgument = (Merger)Preconditions.checkNotNull(databaseWithSqlArgumentMerger);
        }

        @NonNull
        public Result<T> apply(@NonNull R sqlArguments) {
            return ((Result)this.databaseSupplier.get()).ifSucceededAttemptMerge(sqlArguments, this.databaseWithSqlArgument);
        }
    }

    private static final class DatabaseQueryMerger<T>
    implements Merger<SQLiteDatabase, SqlRequest, Result<List<T>>> {
        @NonNull
        private final Function<Cursor, T> cursorToItem;

        private DatabaseQueryMerger(@NonNull Function<Cursor, T> cursorToItem) {
            this.cursorToItem = (Function)Preconditions.checkNotNull(cursorToItem);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NonNull
        public Result<List<T>> merge(@NonNull SQLiteDatabase database, @NonNull SqlRequest input) {
            try (Cursor cursor = database.rawQuery(input.sql, input.arguments);){
                int count = cursor.getCount();
                if (count == 0) {
                    Result result = Result.success(Collections.emptyList());
                    return result;
                }
                ArrayList<Object> items = new ArrayList<Object>(count);
                while (cursor.moveToNext()) {
                    items.add(this.cursorToItem.apply((Object)cursor));
                }
                Result result = Result.success(items);
                return result;
            }
            catch (SQLException e) {
                return Result.failure((Throwable)e);
            }
        }
    }

    private static final class DatabaseDeleteMerger
    implements Merger<SQLiteDatabase, SqlDeleteRequest, Result<Integer>> {
        private DatabaseDeleteMerger() {
        }

        @NonNull
        public Result<Integer> merge(@NonNull SQLiteDatabase database, @NonNull SqlDeleteRequest input) {
            try {
                return Result.success((Object)database.delete(input.table, input.where, input.arguments));
            }
            catch (SQLException e) {
                return Result.failure((Throwable)e);
            }
        }
    }

    private static final class DatabaseUpdateMerger
    implements Merger<SQLiteDatabase, SqlUpdateRequest, Result<Integer>> {
        private DatabaseUpdateMerger() {
        }

        @NonNull
        public Result<Integer> merge(@NonNull SQLiteDatabase database, @NonNull SqlUpdateRequest input) {
            try {
                return Result.success((Object)database.updateWithOnConflict(input.table, input.contentValues, input.where, input.arguments, input.conflictAlgorithm));
            }
            catch (SQLException e) {
                return Result.failure((Throwable)e);
            }
        }
    }

    private static final class DatabaseInsertMerger
    implements Merger<SQLiteDatabase, SqlInsertRequest, Result<Long>> {
        private DatabaseInsertMerger() {
        }

        @NonNull
        public Result<Long> merge(@NonNull SQLiteDatabase database, @NonNull SqlInsertRequest input) {
            try {
                return Result.success((Object)database.insertWithOnConflict(input.table, null, input.contentValues, input.conflictAlgorithm));
            }
            catch (SQLException e) {
                return Result.failure((Throwable)e);
            }
        }
    }
}

