/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModelNameUtils {
    private static final Pattern GEMINI_2_PATTERN = Pattern.compile("^gemini-2\\..*");
    private static final Pattern PATH_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/publishers/[^/]+/models/(.+)$");
    private static final Pattern APIGEE_PATTERN = Pattern.compile("^apigee/(?:[^/]+/)?(?:[^/]+/)?(.+)$");

    public static boolean isGemini2Model(String modelString) {
        if (modelString == null) {
            return false;
        }
        String modelName = ModelNameUtils.extractModelName(modelString);
        return GEMINI_2_PATTERN.matcher(modelName).matches();
    }

    private static String extractModelName(String modelString) {
        Matcher matcher = PATH_PATTERN.matcher(modelString);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        Matcher apigeeMatcher = APIGEE_PATTERN.matcher(modelString);
        if (apigeeMatcher.matches()) {
            return apigeeMatcher.group(1);
        }
        return modelString;
    }

    private ModelNameUtils() {
    }
}

