/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.utils;

import com.google.adk.agents.InvocationContext;
import com.google.adk.sessions.Session;
import com.google.common.collect.ImmutableSet;
import com.google.genai.JsonSerializable;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InstructionUtils {
    private static final Pattern INSTRUCTION_PLACEHOLDER_PATTERN = Pattern.compile("\\{+[^\\{\\}]*\\}+");

    private InstructionUtils() {
    }

    public static Single<String> injectSessionState(InvocationContext context, String template) {
        if (template == null) {
            return Single.error((Throwable)new NullPointerException("template cannot be null"));
        }
        if (context == null) {
            return Single.error((Throwable)new NullPointerException("context cannot be null"));
        }
        Matcher matcher = INSTRUCTION_PLACEHOLDER_PATTERN.matcher(template);
        ArrayList<Object> parts = new ArrayList<Object>();
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                parts.add(Single.just((Object)template.substring(lastEnd, matcher.start())));
            }
            MatchResult matchResult = matcher.toMatchResult();
            parts.add(InstructionUtils.resolveMatchAsync(context, matchResult));
            lastEnd = matcher.end();
        }
        if (lastEnd < template.length()) {
            parts.add(Single.just((Object)template.substring(lastEnd)));
        }
        if (parts.isEmpty()) {
            return Single.just((Object)template);
        }
        return Single.zip(parts, objects -> {
            StringBuilder sb = new StringBuilder();
            for (Object obj : objects) {
                sb.append(obj);
            }
            return sb.toString();
        });
    }

    private static Single<String> resolveMatchAsync(InvocationContext context, MatchResult match) {
        String cleanVarName;
        boolean optional;
        String placeholder = match.group();
        String varNameFromPlaceholder = placeholder.replaceAll("^\\{+", "").replaceAll("\\}+$", "").trim();
        if (varNameFromPlaceholder.endsWith("?")) {
            optional = true;
            cleanVarName = varNameFromPlaceholder.substring(0, varNameFromPlaceholder.length() - 1);
        } else {
            optional = false;
            cleanVarName = varNameFromPlaceholder;
        }
        if (cleanVarName.startsWith("artifact.")) {
            String artifactName = cleanVarName.substring("artifact.".length());
            Session session = context.session();
            Maybe<Part> artifactMaybe = context.artifactService().loadArtifact(session.appName(), session.userId(), session.id(), artifactName, Optional.empty());
            return artifactMaybe.map(JsonSerializable::toJson).switchIfEmpty((SingleSource)Single.defer(() -> {
                if (optional) {
                    return Single.just((Object)"");
                }
                return Single.error((Throwable)new IllegalArgumentException(String.format("Artifact %s not found.", artifactName)));
            }));
        }
        if (!InstructionUtils.isValidStateName(cleanVarName)) {
            return Single.just((Object)placeholder);
        }
        if (context.session().state().containsKey(cleanVarName)) {
            Object value = context.session().state().get(cleanVarName);
            return Single.just((Object)String.valueOf(value));
        }
        if (optional) {
            return Single.just((Object)"");
        }
        return Single.error((Throwable)new IllegalArgumentException(String.format("Context variable not found: `%s`.", cleanVarName)));
    }

    private static boolean isValidStateName(String varName) {
        if (varName.isEmpty()) {
            return false;
        }
        String[] parts = varName.split(":", 2);
        if (parts.length == 1) {
            return InstructionUtils.isValidIdentifier(parts[0]);
        }
        if (parts.length == 2) {
            String prefixPart = parts[0] + ":";
            ImmutableSet validPrefixes = ImmutableSet.of((Object)"app:", (Object)"user:", (Object)"temp:");
            if (validPrefixes.contains((Object)prefixPart)) {
                return InstructionUtils.isValidIdentifier(parts[1]);
            }
        }
        return false;
    }

    private static boolean isValidIdentifier(String s) {
        if (s.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

