/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.memory.MemoryEntry;
import com.google.adk.models.LlmRequest;
import com.google.adk.tools.Annotations;
import com.google.adk.tools.FunctionTool;
import com.google.adk.tools.LoadMemoryResponse;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import java.lang.reflect.Method;
import java.util.List;

public class LoadMemoryTool
extends FunctionTool {
    private static Method getLoadMemoryMethod() {
        try {
            return LoadMemoryTool.class.getMethod("loadMemory", String.class, ToolContext.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to load memory method.", e);
        }
    }

    public LoadMemoryTool() {
        super(null, LoadMemoryTool.getLoadMemoryMethod(), false, false);
    }

    public static Single<LoadMemoryResponse> loadMemory(@Annotations.Schema(name="query") String query, ToolContext toolContext) {
        return toolContext.searchMemory(query).map(searchMemoryResponse -> new LoadMemoryResponse((List<MemoryEntry>)searchMemoryResponse.memories()));
    }

    @Override
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        return super.processLlmRequest(llmRequestBuilder, toolContext).doOnComplete(() -> llmRequestBuilder.appendInstructions((List<String>)ImmutableList.of((Object)"You have memory. You can use it to answer questions. If any questions need\nyou to look up the memory, you should call loadMemory function with a query.\n")));
    }
}

