/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.adk.JsonBaseModel;
import com.google.adk.models.LlmRequest;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.Part;
import com.google.genai.types.Schema;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class LoadArtifactsTool
extends BaseTool {
    public static final LoadArtifactsTool INSTANCE = new LoadArtifactsTool();

    public LoadArtifactsTool() {
        super("load_artifacts", "Loads the artifacts and adds them to the session.");
    }

    @Override
    public Optional<FunctionDeclaration> declaration() {
        return Optional.of(FunctionDeclaration.builder().name(this.name()).description(this.description()).parameters(Schema.builder().type("OBJECT").properties((Map)ImmutableMap.of((Object)"artifact_names", (Object)Schema.builder().type("ARRAY").items(Schema.builder().type("STRING").build()).build())).build()).build());
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        List artifactNames = (List)args.getOrDefault("artifact_names", ImmutableList.of());
        return Single.just((Object)ImmutableMap.of((Object)"artifact_names", (Object)artifactNames));
    }

    @Override
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        return super.processLlmRequest(llmRequestBuilder, toolContext).andThen((CompletableSource)this.appendArtifactsToLlmRequest(llmRequestBuilder, toolContext));
    }

    public Completable appendArtifactsToLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        return toolContext.listArtifacts().flatMapCompletable(artifactNamesList -> {
            if (artifactNamesList.isEmpty()) {
                return Completable.complete();
            }
            this.appendInitialInstructions(llmRequestBuilder, (List<String>)artifactNamesList);
            return this.processLoadArtifactsFunctionCall(llmRequestBuilder, toolContext);
        });
    }

    private void appendInitialInstructions(LlmRequest.Builder llmRequestBuilder, List<String> artifactNamesList) {
        try {
            String instructions = String.format("You have a list of artifacts:\n  %s\n\nWhen the user asks questions about any of the artifacts, you should call the `load_artifacts` function to load the artifact. Do not generate any text other than the function call. Whenever you are asked about artifacts, you should first load it. You must always load an artifact to access its content, even if it has been loaded before.", JsonBaseModel.getMapper().writeValueAsString(artifactNamesList));
            llmRequestBuilder.appendInstructions((List<String>)ImmutableList.of((Object)instructions));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize artifact names to JSON", e);
        }
    }

    private Completable processLoadArtifactsFunctionCall(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        LlmRequest currentRequestState = llmRequestBuilder.build();
        List<Content> currentContents = currentRequestState.contents();
        if (currentContents.isEmpty()) {
            return Completable.complete();
        }
        return ((Content)Iterables.getLast(currentContents)).parts().filter(partsList -> !partsList.isEmpty()).flatMap(partsList -> ((Part)partsList.get(0)).functionResponse()).filter(fr -> Objects.equals(fr.name().orElse(null), "load_artifacts")).flatMap(FunctionResponse::response).flatMap(responseMap -> Optional.ofNullable(responseMap.get("artifact_names"))).filter(obj -> obj instanceof List).map(obj -> (List)obj).filter(list -> !list.isEmpty()).map(artifactNamesRaw -> {
            List artifactNamesToLoad = artifactNamesRaw;
            return Observable.fromIterable((Iterable)artifactNamesToLoad).flatMapCompletable(artifactName -> this.loadAndAppendIndividualArtifact(llmRequestBuilder, toolContext, (String)artifactName));
        }).orElse(Completable.complete());
    }

    private Completable loadAndAppendIndividualArtifact(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext, String artifactName) {
        return toolContext.loadArtifact(artifactName, Optional.empty()).flatMapCompletable(actualArtifact -> Completable.fromAction(() -> this.appendArtifactToLlmRequest(llmRequestBuilder, "Artifact " + artifactName + " is:", (Part)actualArtifact)));
    }

    private void appendArtifactToLlmRequest(LlmRequest.Builder llmRequestBuilder, String prefix, Part artifact) {
        llmRequestBuilder.contents((List<Content>)ImmutableList.builder().addAll(llmRequestBuilder.build().contents()).add((Object)Content.fromParts((Part[])new Part[]{Part.fromText((String)prefix), artifact})).build());
    }
}

