/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.google.adk.models.LlmRequest;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GoogleMaps;
import com.google.genai.types.Tool;
import io.reactivex.rxjava3.core.Completable;
import java.util.List;

public class GoogleMapsTool
extends BaseTool {
    public static final GoogleMapsTool INSTANCE = new GoogleMapsTool();

    public GoogleMapsTool() {
        super("google_maps", "google_maps");
    }

    @Override
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        GenerateContentConfig.Builder configBuilder = llmRequestBuilder.build().config().map(GenerateContentConfig::toBuilder).orElse(GenerateContentConfig.builder());
        List existingTools = (List)configBuilder.build().tools().orElse(ImmutableList.of());
        ImmutableList.Builder updatedToolsBuilder = ImmutableList.builder();
        updatedToolsBuilder.addAll((Iterable)existingTools);
        String model = llmRequestBuilder.build().model().orElse(null);
        if (model == null || model.startsWith("gemini-1")) {
            return Completable.error((Throwable)new IllegalArgumentException("Google Maps tool is not supported for model " + model));
        }
        updatedToolsBuilder.add((Object)Tool.builder().googleMaps(GoogleMaps.builder().build()).build());
        configBuilder.tools((List)updatedToolsBuilder.build());
        llmRequestBuilder.config(configBuilder.build());
        return Completable.complete();
    }
}

