/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.adk.agents.ConfigAgentUtils;
import com.google.adk.examples.BaseExampleProvider;
import com.google.adk.examples.Example;
import com.google.adk.examples.ExampleUtils;
import com.google.adk.models.LlmRequest;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.reactivex.rxjava3.core.Completable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class ExampleTool
extends BaseTool {
    private final Optional<BaseExampleProvider> exampleProvider;
    private final Optional<List<Example>> examples;

    private ExampleTool(Builder builder) {
        super(Strings.isNullOrEmpty((String)builder.name) ? "example_tool" : builder.name, Strings.isNullOrEmpty((String)builder.description) ? "Adds few-shot examples to the request" : builder.description);
        this.exampleProvider = builder.provider;
        this.examples = builder.examples.isEmpty() ? Optional.empty() : Optional.of(builder.examples);
    }

    @Override
    public Completable processLlmRequest(LlmRequest.Builder llmRequestBuilder, ToolContext toolContext) {
        String examplesBlock;
        String query = toolContext.userContent().flatMap(content -> content.parts().flatMap(parts -> parts.stream().findFirst())).flatMap(part -> part.text()).orElse("");
        if (query.isEmpty()) {
            return Completable.complete();
        }
        if (this.exampleProvider.isPresent()) {
            examplesBlock = ExampleUtils.buildExampleSi(this.exampleProvider.get(), query);
        } else if (this.examples.isPresent()) {
            BaseExampleProvider provider = q -> this.examples.get();
            examplesBlock = ExampleUtils.buildExampleSi(provider, query);
        } else {
            return Completable.complete();
        }
        llmRequestBuilder.appendInstructions((List<String>)ImmutableList.of((Object)examplesBlock));
        return super.processLlmRequest(llmRequestBuilder, toolContext);
    }

    public static ExampleTool fromConfig(BaseTool.ToolArgsConfig args, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        if (args == null || args.isEmpty()) {
            throw new ConfigAgentUtils.ConfigurationException("ExampleTool requires 'examples' argument");
        }
        Optional<String> maybeExamplesProvider = args.getOrEmpty("examples", new TypeReference<String>(){});
        if (maybeExamplesProvider.isPresent()) {
            BaseExampleProvider provider = ExampleTool.resolveExampleProvider(maybeExamplesProvider.get());
            return ExampleTool.builder().setExampleProvider(provider).build();
        }
        Optional<List<Example>> maybeListOfExamples = args.getOrEmpty("examples", new TypeReference<List<Example>>(){});
        if (maybeListOfExamples.isPresent()) {
            Builder b = ExampleTool.builder();
            for (Example example : maybeListOfExamples.get()) {
                b.addExample(example);
            }
            return b.build();
        }
        throw new ConfigAgentUtils.ConfigurationException("ExampleTool requires 'examples' argument to be either an example provider name (String) or a list of examples (List<Example>).");
    }

    public static ExampleTool fromConfig(BaseTool.ToolArgsConfig args) throws ConfigAgentUtils.ConfigurationException {
        return ExampleTool.fromConfig(args, "");
    }

    private static BaseExampleProvider resolveExampleProvider(String ref) throws ConfigAgentUtils.ConfigurationException {
        int lastDot = ref.lastIndexOf(46);
        if (lastDot <= 0) {
            throw new ConfigAgentUtils.ConfigurationException("Invalid example provider reference: " + ref + ". Expected ClassName.FIELD");
        }
        String className = ref.substring(0, lastDot);
        String fieldName = ref.substring(lastDot + 1);
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            Field field = clazz.getField(fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new ConfigAgentUtils.ConfigurationException("Field '" + fieldName + "' in class '" + className + "' is not static");
            }
            Object instance = field.get(null);
            if (instance instanceof BaseExampleProvider) {
                BaseExampleProvider provider = (BaseExampleProvider)instance;
                return provider;
            }
            throw new ConfigAgentUtils.ConfigurationException("Field '" + fieldName + "' in class '" + className + "' is not a BaseExampleProvider");
        }
        catch (NoSuchFieldException e) {
            throw new ConfigAgentUtils.ConfigurationException("Field '" + fieldName + "' not found in class '" + className + "'", e);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigAgentUtils.ConfigurationException("Example provider class not found: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigAgentUtils.ConfigurationException("Cannot access example provider field: " + ref, e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Example> examples = new ArrayList<Example>();
        private String name = "example_tool";
        private String description = "Adds few-shot examples to the request";
        private Optional<BaseExampleProvider> provider = Optional.empty();

        @CanIgnoreReturnValue
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addExample(Example ex) {
            this.examples.add(ex);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExampleProvider(BaseExampleProvider provider) {
            this.provider = Optional.ofNullable(provider);
            return this;
        }

        public ExampleTool build() {
            return new ExampleTool(this);
        }
    }
}

