/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.adk.JsonBaseModel;
import com.google.adk.SchemaUtils;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.BaseAgentConfig;
import com.google.adk.agents.ConfigAgentUtils;
import com.google.adk.agents.LlmAgent;
import com.google.adk.events.Event;
import com.google.adk.runner.InMemoryRunner;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionDeclaration;
import com.google.genai.types.Part;
import com.google.genai.types.Schema;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AgentTool
extends BaseTool {
    private final BaseAgent agent;
    private final boolean skipSummarization;

    public static BaseTool fromConfig(BaseTool.ToolArgsConfig args, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        Optional<BaseAgentConfig.AgentRefConfig> agentRef = args.getOrEmpty("agent", new TypeReference<BaseAgentConfig.AgentRefConfig>(){});
        if (agentRef.isEmpty()) {
            throw new ConfigAgentUtils.ConfigurationException("AgentTool config requires 'agent' argument.");
        }
        ImmutableList<BaseAgent> resolvedAgents = ConfigAgentUtils.resolveSubAgents((List<BaseAgentConfig.AgentRefConfig>)ImmutableList.of((Object)agentRef.get()), configAbsPath);
        if (resolvedAgents.isEmpty()) {
            throw new ConfigAgentUtils.ConfigurationException("Failed to resolve agent.");
        }
        BaseAgent agent = (BaseAgent)resolvedAgents.get(0);
        return AgentTool.create(agent, args.getOrDefault("skipSummarization", false));
    }

    public static AgentTool create(BaseAgent agent, boolean skipSummarization) {
        return new AgentTool(agent, skipSummarization);
    }

    public static AgentTool create(BaseAgent agent) {
        return new AgentTool(agent, false);
    }

    protected AgentTool(BaseAgent agent, boolean skipSummarization) {
        super(agent.name(), agent.description());
        this.agent = agent;
        this.skipSummarization = skipSummarization;
    }

    @Override
    public Optional<FunctionDeclaration> declaration() {
        FunctionDeclaration.Builder builder = FunctionDeclaration.builder().description(this.description()).name(this.name());
        Optional<Object> agentInputSchema = Optional.empty();
        BaseAgent baseAgent = this.agent;
        if (baseAgent instanceof LlmAgent) {
            LlmAgent llmAgent = (LlmAgent)baseAgent;
            agentInputSchema = llmAgent.inputSchema();
        }
        if (agentInputSchema.isPresent()) {
            builder.parameters((Schema)agentInputSchema.get());
        } else {
            builder.parameters(Schema.builder().type("OBJECT").properties((Map)ImmutableMap.of((Object)"request", (Object)Schema.builder().type("STRING").build())).required((List)ImmutableList.of((Object)"request")).build());
        }
        return Optional.of(builder.build());
    }

    @Override
    public Single<Map<String, Object>> runAsync(Map<String, Object> args, ToolContext toolContext) {
        Content content;
        if (this.skipSummarization) {
            toolContext.actions().setSkipSummarization(true);
        }
        Optional<Object> agentInputSchema = Optional.empty();
        BaseAgent baseAgent = this.agent;
        if (baseAgent instanceof LlmAgent) {
            LlmAgent llmAgent = (LlmAgent)baseAgent;
            agentInputSchema = llmAgent.inputSchema();
        }
        if (agentInputSchema.isPresent()) {
            SchemaUtils.validateMapOnSchema(args, (Schema)agentInputSchema.get(), true);
            try {
                content = Content.fromParts((Part[])new Part[]{Part.fromText((String)JsonBaseModel.getMapper().writeValueAsString(args))});
            }
            catch (JsonProcessingException e) {
                return Single.error((Throwable)new RuntimeException("Error serializing tool arguments to JSON: " + String.valueOf(args), e));
            }
        } else {
            Object input = args.get("request");
            content = Content.fromParts((Part[])new Part[]{Part.fromText((String)input.toString())});
        }
        InMemoryRunner runner = new InMemoryRunner(this.agent, toolContext.agentName());
        return runner.sessionService().createSession(toolContext.agentName(), "tmp-user", toolContext.state(), null).flatMapPublisher(session -> runner.runAsync(session.userId(), session.id(), content)).lastElement().map(Optional::of).defaultIfEmpty(Optional.empty()).map(optionalLastEvent -> {
            if (optionalLastEvent.isEmpty()) {
                return ImmutableMap.of();
            }
            Event lastEvent = (Event)optionalLastEvent.get();
            Optional<String> outputText = lastEvent.content().map(Content::text);
            if (outputText.isEmpty()) {
                return ImmutableMap.of();
            }
            String output = outputText.get();
            Optional<Object> agentOutputSchema = Optional.empty();
            BaseAgent patt0$temp = this.agent;
            if (patt0$temp instanceof LlmAgent) {
                LlmAgent llmAgent = (LlmAgent)patt0$temp;
                agentOutputSchema = llmAgent.outputSchema();
            }
            if (agentOutputSchema.isPresent()) {
                return SchemaUtils.validateOutputSchema(output, (Schema)agentOutputSchema.get());
            }
            return ImmutableMap.of((Object)"result", (Object)output);
        });
    }
}

