/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.events.Event;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.GetSessionConfig;
import com.google.adk.sessions.HttpApiClient;
import com.google.adk.sessions.ListEventsResponse;
import com.google.adk.sessions.ListSessionsResponse;
import com.google.adk.sessions.Session;
import com.google.adk.sessions.SessionJsonConverter;
import com.google.adk.sessions.VertexAiClient;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.genai.types.HttpOptions;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class VertexAiSessionService
implements BaseSessionService {
    private static final ObjectMapper objectMapper = JsonBaseModel.getMapper();
    private final VertexAiClient client;
    private static final Pattern APP_NAME_PATTERN = Pattern.compile("^projects/([a-zA-Z0-9-_]+)/locations/([a-zA-Z0-9-_]+)/reasoningEngines/(\\d+)$");

    public VertexAiSessionService(String project, String location, HttpApiClient apiClient) {
        this.client = new VertexAiClient(project, location, apiClient);
    }

    public VertexAiSessionService() {
        this.client = new VertexAiClient();
    }

    public VertexAiSessionService(String project, String location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions) {
        this.client = new VertexAiClient(project, location, credentials, httpOptions);
    }

    @Override
    public Single<Session> createSession(String appName, String userId, @Nullable ConcurrentMap<String, Object> state, @Nullable String sessionId) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        return this.client.createSession(reasoningEngineId, userId, state).map(getSessionResponseMap -> VertexAiSessionService.parseSession(getSessionResponseMap, appName, userId, sessionId)).toSingle();
    }

    private static Session parseSession(JsonNode getSessionResponseMap, String appName, String userId, String fallbackSessionId) {
        JsonNode sessionStateNode;
        String sessId = Optional.ofNullable(getSessionResponseMap.get("name")).map(name -> (String)Iterables.getLast((Iterable)Splitter.on((char)'/').splitToList((CharSequence)name.asText()))).orElse(fallbackSessionId);
        Instant updateTimestamp = Instant.parse(getSessionResponseMap.get("updateTime").asText());
        ConcurrentMap sessionState = null;
        if (getSessionResponseMap != null && getSessionResponseMap.has("sessionState") && (sessionStateNode = getSessionResponseMap.get("sessionState")) != null) {
            sessionState = (ConcurrentMap)objectMapper.convertValue((Object)sessionStateNode, (TypeReference)new TypeReference<ConcurrentMap<String, Object>>(){});
        }
        return Session.builder(sessId).appName(appName).userId(userId).lastUpdateTime(updateTimestamp).state(sessionState == null ? new ConcurrentHashMap() : sessionState).build();
    }

    @Override
    public Single<ListSessionsResponse> listSessions(String appName, String userId) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        return this.client.listSessions(reasoningEngineId, userId).map(listSessionsResponseMap -> this.parseListSessionsResponse((JsonNode)listSessionsResponseMap, appName, userId)).defaultIfEmpty((Object)ListSessionsResponse.builder().build());
    }

    private ListSessionsResponse parseListSessionsResponse(JsonNode listSessionsResponseMap, String appName, String userId) {
        List apiSessions = (List)objectMapper.convertValue((Object)listSessionsResponseMap.get("sessions"), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        ArrayList<Session> sessions = new ArrayList<Session>();
        for (Map apiSession : apiSessions) {
            String sessionId = (String)Iterables.getLast((Iterable)Splitter.on((char)'/').splitToList((CharSequence)((String)apiSession.get("name"))));
            Instant updateTimestamp = Instant.parse((String)apiSession.get("updateTime"));
            Session session = Session.builder(sessionId).appName(appName).userId(userId).state(apiSession.get("sessionState") == null ? new ConcurrentHashMap<String, Object>() : (ConcurrentMap)objectMapper.convertValue(apiSession.get("sessionState"), (TypeReference)new TypeReference<ConcurrentMap<String, Object>>(){})).lastUpdateTime(updateTimestamp).build();
            sessions.add(session);
        }
        return ListSessionsResponse.builder().sessions(sessions).build();
    }

    @Override
    public Single<ListEventsResponse> listEvents(String appName, String userId, String sessionId) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        return this.client.listEvents(reasoningEngineId, sessionId).map(this::parseListEventsResponse).defaultIfEmpty((Object)ListEventsResponse.builder().build());
    }

    private ListEventsResponse parseListEventsResponse(JsonNode listEventsResponse) {
        JsonNode sessionEventsNode = listEventsResponse.get("sessionEvents");
        if (sessionEventsNode == null || sessionEventsNode.isEmpty()) {
            return ListEventsResponse.builder().events(new ArrayList<Event>()).build();
        }
        return ListEventsResponse.builder().events(((List)objectMapper.convertValue((Object)sessionEventsNode, (TypeReference)new TypeReference<List<ConcurrentMap<String, Object>>>(){})).stream().map(SessionJsonConverter::fromApiEvent).collect(Collectors.toCollection(ArrayList::new))).build();
    }

    @Override
    public Maybe<Session> getSession(String appName, String userId, String sessionId, Optional<GetSessionConfig> config) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        return this.client.getSession(reasoningEngineId, sessionId).flatMap(getSessionResponseMap -> {
            String sessId = Optional.ofNullable(getSessionResponseMap.get("name")).map(name -> (String)Iterables.getLast((Iterable)Splitter.on((char)'/').splitToList((CharSequence)name.asText()))).orElse(sessionId);
            Instant updateTimestamp = Optional.ofNullable(getSessionResponseMap.get("updateTime")).map(updateTime -> Instant.parse(updateTime.asText())).orElse(null);
            ConcurrentHashMap sessionState = new ConcurrentHashMap();
            if (getSessionResponseMap != null && getSessionResponseMap.has("sessionState")) {
                sessionState.putAll((Map)objectMapper.convertValue((Object)getSessionResponseMap.get("sessionState"), (TypeReference)new TypeReference<ConcurrentMap<String, Object>>(){}));
            }
            return this.listEvents(appName, userId, sessionId).map(response -> {
                Session.Builder sessionBuilder = Session.builder(sessId).appName(appName).userId(userId).lastUpdateTime(updateTimestamp).state(sessionState);
                Object events = response.events();
                if (events.isEmpty()) {
                    return sessionBuilder.build();
                }
                events = VertexAiSessionService.filterEvents(events, updateTimestamp, config);
                return sessionBuilder.events((List<Event>)events).build();
            }).toMaybe();
        });
    }

    private static List<Event> filterEvents(List<Event> originalEvents, @Nullable Instant updateTimestamp, Optional<GetSessionConfig> config) {
        List events = originalEvents.stream().filter(event -> updateTimestamp == null || Instant.ofEpochMilli(event.timestamp()).isBefore(updateTimestamp)).sorted(Comparator.comparing(Event::timestamp)).collect(Collectors.toCollection(ArrayList::new));
        if (config.isPresent()) {
            if (config.get().numRecentEvents().isPresent()) {
                int numRecentEvents = config.get().numRecentEvents().get();
                if (events.size() > numRecentEvents) {
                    events = events.subList(events.size() - numRecentEvents, events.size());
                }
            } else if (config.get().afterTimestamp().isPresent()) {
                int i;
                Instant afterTimestamp = config.get().afterTimestamp().get();
                for (i = events.size() - 1; i >= 0 && !Instant.ofEpochMilli(((Event)events.get(i)).timestamp()).isBefore(afterTimestamp); --i) {
                }
                if (i >= 0) {
                    events = events.subList(i, events.size());
                }
            }
        }
        return events;
    }

    @Override
    public Completable deleteSession(String appName, String userId, String sessionId) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(appName);
        return this.client.deleteSession(reasoningEngineId, sessionId);
    }

    @Override
    public Single<Event> appendEvent(Session session, Event event) {
        String reasoningEngineId = VertexAiSessionService.parseReasoningEngineId(session.appName());
        return BaseSessionService.super.appendEvent(session, event).flatMap(e -> this.client.appendEvent(reasoningEngineId, session.id(), SessionJsonConverter.convertEventToJson(e)).toSingleDefault(e));
    }

    static String parseReasoningEngineId(String appName) {
        if (appName.matches("\\d+")) {
            return appName;
        }
        Matcher matcher = APP_NAME_PATTERN.matcher(appName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("App name " + appName + " is not valid. It should either be the full ReasoningEngine resource name, or the reasoning engine id.");
        }
        return matcher.group(matcher.groupCount());
    }
}

