/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.sessions.ApiResponse;
import com.google.adk.sessions.HttpApiClient;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.genai.types.HttpOptions;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VertexAiClient {
    private static final int MAX_RETRY_ATTEMPTS = 5;
    private static final ObjectMapper objectMapper = JsonBaseModel.getMapper();
    private static final Logger logger = LoggerFactory.getLogger(VertexAiClient.class);
    private final HttpApiClient apiClient;

    VertexAiClient(String project, String location, HttpApiClient apiClient) {
        this.apiClient = apiClient;
    }

    VertexAiClient() {
        this.apiClient = new HttpApiClient(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    VertexAiClient(String project, String location, Optional<GoogleCredentials> credentials, Optional<HttpOptions> httpOptions) {
        this.apiClient = new HttpApiClient(Optional.of(project), Optional.of(location), credentials, httpOptions);
    }

    Maybe<JsonNode> createSession(String reasoningEngineId, String userId, ConcurrentMap<String, Object> state) {
        ConcurrentHashMap<String, Object> sessionJsonMap = new ConcurrentHashMap<String, Object>();
        sessionJsonMap.put("userId", userId);
        if (state != null) {
            sessionJsonMap.put("sessionState", state);
        }
        return Single.fromCallable(() -> objectMapper.writeValueAsString((Object)sessionJsonMap)).flatMap(sessionJson -> this.performApiRequest("POST", "reasoningEngines/" + reasoningEngineId + "/sessions", (String)sessionJson)).flatMapMaybe(apiResponse -> {
            logger.debug("Create Session response {}", (Object)apiResponse.getResponseBody());
            return VertexAiClient.getJsonResponse(apiResponse);
        }).flatMap(jsonResponse -> {
            String sessionName = jsonResponse.get("name").asText();
            List parts = Splitter.on((char)'/').splitToList((CharSequence)sessionName);
            String sessId = (String)parts.get(parts.size() - 3);
            String operationId = (String)Iterables.getLast((Iterable)parts);
            return this.pollOperation(operationId, 0).andThen(this.getSession(reasoningEngineId, sessId));
        });
    }

    private Completable pollOperation(String operationId, int attempt) {
        if (attempt >= 5) {
            return Completable.error((Throwable)new TimeoutException("Operation " + operationId + " did not complete in time."));
        }
        return this.performApiRequest("GET", "operations/" + operationId, "").flatMapMaybe(VertexAiClient::getJsonResponse).flatMapCompletable(lroJsonResponse -> {
            if (lroJsonResponse != null && lroJsonResponse.get("done") != null) {
                return Completable.complete();
            }
            return Completable.timer((long)1L, (TimeUnit)TimeUnit.SECONDS).andThen((CompletableSource)this.pollOperation(operationId, attempt + 1));
        });
    }

    Maybe<JsonNode> listSessions(String reasoningEngineId, String userId) {
        return this.performApiRequest("GET", "reasoningEngines/" + reasoningEngineId + "/sessions?filter=user_id=" + userId, "").flatMapMaybe(VertexAiClient::getJsonResponse);
    }

    Maybe<JsonNode> listEvents(String reasoningEngineId, String sessionId) {
        return this.performApiRequest("GET", "reasoningEngines/" + reasoningEngineId + "/sessions/" + sessionId + "/events", "").doOnSuccess(apiResponse -> logger.debug("List events response {}", apiResponse)).flatMapMaybe(VertexAiClient::getJsonResponse);
    }

    Maybe<JsonNode> getSession(String reasoningEngineId, String sessionId) {
        return this.performApiRequest("GET", "reasoningEngines/" + reasoningEngineId + "/sessions/" + sessionId, "").flatMapMaybe(apiResponse -> VertexAiClient.getJsonResponse(apiResponse));
    }

    Completable deleteSession(String reasoningEngineId, String sessionId) {
        return this.performApiRequest("DELETE", "reasoningEngines/" + reasoningEngineId + "/sessions/" + sessionId, "").doOnSuccess(ApiResponse::close).ignoreElement();
    }

    Completable appendEvent(String reasoningEngineId, String sessionId, String eventJson) {
        return this.performApiRequest("POST", "reasoningEngines/" + reasoningEngineId + "/sessions/" + sessionId + ":appendEvent", eventJson).flatMapCompletable(response -> {
            ApiResponse twrVar0$ = response;
            try {
                Object responseString;
                ResponseBody responseBody = response.getResponseBody();
                if (responseBody != null && ((String)(responseString = responseBody.string())).contains("com.google.genai.errors.ClientException")) {
                    logger.warn("Failed to append event: {}", (Object)eventJson);
                }
                responseString = Completable.complete();
                if (twrVar0$ != null) {
                    twrVar0$.close();
                }
                return responseString;
            }
            catch (Throwable t$) {
                try {
                    if (twrVar0$ != null) {
                        try {
                            twrVar0$.close();
                        }
                        catch (Throwable x2) {
                            t$.addSuppressed(x2);
                        }
                    }
                    throw t$;
                }
                catch (IOException e) {
                    return Completable.error((Throwable)new UncheckedIOException(e));
                }
            }
        });
    }

    private Single<ApiResponse> performApiRequest(String method, String path, String body) {
        return Single.fromCallable(() -> this.apiClient.request(method, path, body));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Maybe<JsonNode> getJsonResponse(ApiResponse apiResponse) {
        try {
            if (apiResponse == null || apiResponse.getResponseBody() == null) {
                Maybe maybe = Maybe.empty();
                return maybe;
            }
            ResponseBody responseBody = apiResponse.getResponseBody();
            String responseString = responseBody.string();
            if (responseString.isEmpty()) {
                Maybe maybe = Maybe.empty();
                return maybe;
            }
            Maybe maybe = Maybe.just((Object)objectMapper.readTree(responseString));
            return maybe;
        }
        finally {
            apiResponse.close();
        }
    }
}

