/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.runner;

import com.google.adk.Telemetry;
import com.google.adk.agents.ActiveStreamingTool;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LiveRequestQueue;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.RunConfig;
import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.artifacts.InMemoryArtifactService;
import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.flows.llmflows.ResumabilityConfig;
import com.google.adk.memory.BaseMemoryService;
import com.google.adk.plugins.BasePlugin;
import com.google.adk.plugins.PluginManager;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.InMemorySessionService;
import com.google.adk.sessions.Session;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.FunctionTool;
import com.google.adk.utils.CollectionUtils;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.Content;
import com.google.genai.types.Modality;
import com.google.genai.types.Part;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;

public class Runner {
    private final BaseAgent agent;
    private final String appName;
    private final BaseArtifactService artifactService;
    private final BaseSessionService sessionService;
    @Nullable
    private final BaseMemoryService memoryService;
    private final PluginManager pluginManager;
    private final ResumabilityConfig resumabilityConfig;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public Runner(BaseAgent agent, String appName, BaseArtifactService artifactService, BaseSessionService sessionService, @Nullable BaseMemoryService memoryService) {
        this(agent, appName, artifactService, sessionService, memoryService, (List<BasePlugin>)ImmutableList.of(), new ResumabilityConfig());
    }

    @Deprecated
    public Runner(BaseAgent agent, String appName, BaseArtifactService artifactService, BaseSessionService sessionService, @Nullable BaseMemoryService memoryService, List<BasePlugin> plugins) {
        this(agent, appName, artifactService, sessionService, memoryService, plugins, new ResumabilityConfig());
    }

    @Deprecated
    public Runner(BaseAgent agent, String appName, BaseArtifactService artifactService, BaseSessionService sessionService, @Nullable BaseMemoryService memoryService, List<BasePlugin> plugins, ResumabilityConfig resumabilityConfig) {
        this.agent = agent;
        this.appName = appName;
        this.artifactService = artifactService;
        this.sessionService = sessionService;
        this.memoryService = memoryService;
        this.pluginManager = new PluginManager(plugins);
        this.resumabilityConfig = resumabilityConfig;
    }

    @Deprecated
    public Runner(BaseAgent agent, String appName, BaseArtifactService artifactService, BaseSessionService sessionService) {
        this(agent, appName, artifactService, sessionService, null);
    }

    public BaseAgent agent() {
        return this.agent;
    }

    public String appName() {
        return this.appName;
    }

    public BaseArtifactService artifactService() {
        return this.artifactService;
    }

    public BaseSessionService sessionService() {
        return this.sessionService;
    }

    @Nullable
    public BaseMemoryService memoryService() {
        return this.memoryService;
    }

    public PluginManager pluginManager() {
        return this.pluginManager;
    }

    private Single<Event> appendNewMessageToSession(Session session, Content newMessage, InvocationContext invocationContext, boolean saveInputBlobsAsArtifacts, @Nullable Map<String, Object> stateDelta) {
        if (newMessage.parts().isEmpty()) {
            throw new IllegalArgumentException("No parts in the new_message.");
        }
        if (this.artifactService != null && saveInputBlobsAsArtifacts) {
            for (int i = 0; i < ((List)newMessage.parts().get()).size(); ++i) {
                Part part = (Part)((List)newMessage.parts().get()).get(i);
                if (part.inlineData().isEmpty()) continue;
                String fileName = "artifact_" + invocationContext.invocationId() + "_" + i;
                Single<Integer> unused = this.artifactService.saveArtifact(this.appName, session.userId(), session.id(), fileName, part);
                ((List)newMessage.parts().get()).set(i, Part.fromText((String)("Uploaded file: " + fileName + ". It has been saved to the artifacts")));
            }
        }
        Event.Builder eventBuilder = Event.builder().id(Event.generateEventId()).invocationId(invocationContext.invocationId()).author("user").content(Optional.of(newMessage));
        if (stateDelta != null && !stateDelta.isEmpty()) {
            eventBuilder.actions(EventActions.builder().stateDelta(new ConcurrentHashMap<String, Object>(stateDelta)).build());
        }
        return this.sessionService.appendEvent(session, eventBuilder.build());
    }

    public Flowable<Event> runAsync(String userId, String sessionId, Content newMessage, RunConfig runConfig) {
        return this.runAsync(userId, sessionId, newMessage, runConfig, null);
    }

    public Flowable<Event> runAsync(String userId, String sessionId, Content newMessage, RunConfig runConfig, @Nullable Map<String, Object> stateDelta) {
        Maybe<Session> maybeSession = this.sessionService.getSession(this.appName, userId, sessionId, Optional.empty());
        return maybeSession.switchIfEmpty((SingleSource)Single.error((Throwable)new IllegalArgumentException(String.format("Session not found: %s for user %s", sessionId, userId)))).flatMapPublisher(session -> this.runAsync((Session)session, newMessage, runConfig, stateDelta));
    }

    public Flowable<Event> runAsync(String userId, String sessionId, Content newMessage) {
        return this.runAsync(userId, sessionId, newMessage, RunConfig.builder().build());
    }

    @Deprecated(since="0.4.0", forRemoval=true)
    public Flowable<Event> runAsync(Session session, Content newMessage, RunConfig runConfig) {
        return this.runAsync(session, newMessage, runConfig, null);
    }

    @Deprecated(since="0.4.0", forRemoval=true)
    public Flowable<Event> runAsync(Session session, Content newMessage, RunConfig runConfig, @Nullable Map<String, Object> stateDelta) {
        Span span = Telemetry.getTracer().spanBuilder("invocation").setParent(Context.current()).startSpan();
        Context spanContext = Context.current().with((ImplicitContextKeyed)span);
        try {
            BaseAgent rootAgent = this.agent;
            String invocationId = InvocationContext.newInvocationContextId();
            InvocationContext initialContext = this.newInvocationContextWithId(session, Optional.of(newMessage), Optional.empty(), runConfig, invocationId);
            return Telemetry.traceFlowable(spanContext, span, () -> Flowable.defer(() -> this.pluginManager.runOnUserMessageCallback(initialContext, newMessage).switchIfEmpty((SingleSource)Single.just((Object)newMessage)).flatMap(content -> content != null ? this.appendNewMessageToSession(session, (Content)content, initialContext, runConfig.saveInputBlobsAsArtifacts(), stateDelta) : Single.just(null)).flatMapPublisher(event -> this.sessionService.getSession(session.appName(), session.userId(), session.id(), Optional.empty()).flatMapPublisher(updatedSession -> {
                InvocationContext contextWithUpdatedSession = this.newInvocationContextWithId((Session)updatedSession, event.content(), Optional.empty(), runConfig, invocationId);
                contextWithUpdatedSession.agent(this.findAgentToRun((Session)updatedSession, rootAgent));
                Maybe beforeRunEvent = this.pluginManager.runBeforeRunCallback(contextWithUpdatedSession).map(content -> Event.builder().id(Event.generateEventId()).invocationId(contextWithUpdatedSession.invocationId()).author("model").content(Optional.of(content)).build());
                Flowable agentEvents = contextWithUpdatedSession.agent().runAsync(contextWithUpdatedSession).flatMap(agentEvent -> this.sessionService.appendEvent((Session)updatedSession, (Event)agentEvent).flatMap(registeredEvent -> {
                    this.copySessionStates((Session)updatedSession, session);
                    return contextWithUpdatedSession.pluginManager().runOnEventCallback(contextWithUpdatedSession, (Event)registeredEvent).defaultIfEmpty(registeredEvent);
                }).toFlowable());
                return beforeRunEvent.toFlowable().switchIfEmpty((Publisher)agentEvents).concatWith((CompletableSource)Completable.defer(() -> this.pluginManager.runAfterRunCallback(contextWithUpdatedSession)));
            }))).doOnError(throwable -> {
                span.setStatus(StatusCode.ERROR, "Error in runAsync Flowable execution");
                span.recordException(throwable);
            }));
        }
        catch (Throwable t) {
            span.setStatus(StatusCode.ERROR, "Error during runAsync synchronous setup");
            span.recordException(t);
            span.end();
            return Flowable.error((Throwable)t);
        }
    }

    private void copySessionStates(Session source, Session target) {
        for (Map.Entry entry : source.state().entrySet()) {
            target.state().put((String)entry.getKey(), entry.getValue());
        }
    }

    private InvocationContext newInvocationContextForLive(Session session, Optional<LiveRequestQueue> liveRequestQueue, RunConfig runConfig) {
        RunConfig.Builder runConfigBuilder = RunConfig.builder(runConfig);
        if (liveRequestQueue.isPresent()) {
            if (CollectionUtils.isNullOrEmpty(runConfig.responseModalities())) {
                runConfigBuilder.setResponseModalities((Iterable<Modality>)ImmutableList.of((Object)new Modality(Modality.Known.AUDIO)));
                if (runConfig.outputAudioTranscription() == null) {
                    runConfigBuilder.setOutputAudioTranscription(AudioTranscriptionConfig.builder().build());
                }
            } else if (!runConfig.responseModalities().contains((Object)new Modality(Modality.Known.TEXT)) && runConfig.outputAudioTranscription() == null) {
                runConfigBuilder.setOutputAudioTranscription(AudioTranscriptionConfig.builder().build());
            }
            if (runConfig.inputAudioTranscription() == null) {
                runConfigBuilder.setInputAudioTranscription(AudioTranscriptionConfig.builder().build());
            }
        }
        return this.newInvocationContext(session, Optional.empty(), liveRequestQueue, runConfigBuilder.build());
    }

    private InvocationContext newInvocationContext(Session session, Optional<Content> newMessage, Optional<LiveRequestQueue> liveRequestQueue, RunConfig runConfig) {
        BaseAgent rootAgent = this.agent;
        InvocationContext.Builder invocationContextBuilder = InvocationContext.builder().sessionService(this.sessionService).artifactService(this.artifactService).memoryService(this.memoryService).pluginManager(this.pluginManager).agent(rootAgent).session(session).userContent(newMessage).runConfig(runConfig).resumabilityConfig(this.resumabilityConfig);
        liveRequestQueue.ifPresent(invocationContextBuilder::liveRequestQueue);
        InvocationContext invocationContext = invocationContextBuilder.build();
        invocationContext.agent(this.findAgentToRun(session, rootAgent));
        return invocationContext;
    }

    private InvocationContext newInvocationContextWithId(Session session, Optional<Content> newMessage, Optional<LiveRequestQueue> liveRequestQueue, RunConfig runConfig, String invocationId) {
        BaseAgent rootAgent = this.agent;
        InvocationContext.Builder invocationContextBuilder = InvocationContext.builder().sessionService(this.sessionService).artifactService(this.artifactService).memoryService(this.memoryService).pluginManager(this.pluginManager).invocationId(invocationId).agent(rootAgent).session(session).userContent(newMessage).runConfig(runConfig).resumabilityConfig(this.resumabilityConfig);
        liveRequestQueue.ifPresent(invocationContextBuilder::liveRequestQueue);
        InvocationContext invocationContext = invocationContextBuilder.build();
        invocationContext.agent(this.findAgentToRun(session, rootAgent));
        return invocationContext;
    }

    public Flowable<Event> runLive(Session session, LiveRequestQueue liveRequestQueue, RunConfig runConfig) {
        Span span = Telemetry.getTracer().spanBuilder("invocation").setParent(Context.current()).startSpan();
        Context spanContext = Context.current().with((ImplicitContextKeyed)span);
        try {
            InvocationContext invocationContext = this.newInvocationContextForLive(session, Optional.of(liveRequestQueue), runConfig);
            if (invocationContext.agent() instanceof LlmAgent) {
                LlmAgent agent = (LlmAgent)invocationContext.agent();
                for (BaseTool tool : agent.tools()) {
                    if (!(tool instanceof FunctionTool)) continue;
                    FunctionTool functionTool = (FunctionTool)tool;
                    for (Parameter parameter : functionTool.func().getParameters()) {
                        if (!parameter.getType().equals(LiveRequestQueue.class)) continue;
                        invocationContext.activeStreamingTools().put(functionTool.name(), new ActiveStreamingTool(new LiveRequestQueue()));
                    }
                }
            }
            return Telemetry.traceFlowable(spanContext, span, () -> invocationContext.agent().runLive(invocationContext).doOnNext(event -> this.sessionService.appendEvent(session, (Event)event)).onErrorResumeNext(throwable -> {
                span.setStatus(StatusCode.ERROR, "Error in runLive Flowable execution");
                span.recordException(throwable);
                span.end();
                return Flowable.error((Throwable)throwable);
            }));
        }
        catch (Throwable t) {
            span.setStatus(StatusCode.ERROR, "Error during runLive synchronous setup");
            span.recordException(t);
            span.end();
            return Flowable.error((Throwable)t);
        }
    }

    public Flowable<Event> runLive(String userId, String sessionId, LiveRequestQueue liveRequestQueue, RunConfig runConfig) {
        return this.sessionService.getSession(this.appName, userId, sessionId, Optional.empty()).flatMapPublisher(session -> {
            if (session == null) {
                return Flowable.error((Throwable)new IllegalArgumentException(String.format("Session not found: %s for user %s", sessionId, userId)));
            }
            return this.runLive((Session)session, liveRequestQueue, runConfig);
        });
    }

    public Flowable<Event> runWithSessionId(String sessionId, Content newMessage, RunConfig runConfig) {
        return this.runAsync("tmp-user", sessionId, newMessage, runConfig);
    }

    private boolean isTransferableAcrossAgentTree(BaseAgent agentToRun) {
        for (BaseAgent current = agentToRun; current != null; current = current.parentAgent()) {
            if (!(current instanceof LlmAgent)) {
                return false;
            }
            LlmAgent agent = (LlmAgent)current;
            if (!agent.disallowTransferToParent()) continue;
            return false;
        }
        return true;
    }

    private BaseAgent findAgentToRun(Session session, BaseAgent rootAgent) {
        ArrayList<Event> events = new ArrayList<Event>(session.events());
        Collections.reverse(events);
        for (Event event : events) {
            String author = event.author();
            if (author.equals("user")) continue;
            if (author.equals(rootAgent.name())) {
                return rootAgent;
            }
            BaseAgent agent = rootAgent.findSubAgent(author);
            if (agent == null || !this.isTransferableAcrossAgentTree(agent)) continue;
            return agent;
        }
        return rootAgent;
    }

    public static class Builder {
        private BaseAgent agent;
        private String appName;
        private BaseArtifactService artifactService = new InMemoryArtifactService();
        private BaseSessionService sessionService = new InMemorySessionService();
        @Nullable
        private BaseMemoryService memoryService = null;
        private List<BasePlugin> plugins = ImmutableList.of();
        private ResumabilityConfig resumabilityConfig = new ResumabilityConfig();

        @CanIgnoreReturnValue
        public Builder agent(BaseAgent agent) {
            this.agent = agent;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder artifactService(BaseArtifactService artifactService) {
            this.artifactService = artifactService;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder sessionService(BaseSessionService sessionService) {
            this.sessionService = sessionService;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder memoryService(BaseMemoryService memoryService) {
            this.memoryService = memoryService;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder plugins(List<BasePlugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder resumabilityConfig(ResumabilityConfig resumabilityConfig) {
            this.resumabilityConfig = resumabilityConfig;
            return this;
        }

        public Runner build() {
            if (this.agent == null) {
                throw new IllegalStateException("Agent must be provided.");
            }
            if (this.appName == null) {
                throw new IllegalStateException("App name must be provided.");
            }
            if (this.artifactService == null) {
                throw new IllegalStateException("Artifact service must be provided.");
            }
            if (this.sessionService == null) {
                throw new IllegalStateException("Session service must be provided.");
            }
            return new Runner(this.agent, this.appName, this.artifactService, this.sessionService, this.memoryService, this.plugins, this.resumabilityConfig);
        }
    }
}

