/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.plugins;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.CallbackContext;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.adk.plugins.BasePlugin;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.genai.types.Content;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(PluginManager.class);
    private final List<BasePlugin> plugins = new ArrayList<BasePlugin>();

    public PluginManager(List<BasePlugin> plugins) {
        if (plugins != null) {
            for (BasePlugin plugin : plugins) {
                this.registerPlugin(plugin);
            }
        }
    }

    public PluginManager() {
        this(null);
    }

    public void registerPlugin(BasePlugin plugin) {
        if (this.plugins.stream().anyMatch(p -> p.getName().equals(plugin.getName()))) {
            throw new IllegalArgumentException("Plugin with name '" + plugin.getName() + "' already registered.");
        }
        this.plugins.add(plugin);
        logger.info("Plugin '{}' registered.", (Object)plugin.getName());
    }

    public Optional<BasePlugin> getPlugin(String pluginName) {
        return this.plugins.stream().filter(p -> p.getName().equals(pluginName)).findFirst();
    }

    public Maybe<Content> runOnUserMessageCallback(InvocationContext invocationContext, Content userMessage) {
        return this.runMaybeCallbacks(plugin -> plugin.onUserMessageCallback(invocationContext, userMessage), "onUserMessageCallback");
    }

    public Maybe<Content> runBeforeRunCallback(InvocationContext invocationContext) {
        return this.runMaybeCallbacks(plugin -> plugin.beforeRunCallback(invocationContext), "beforeRunCallback");
    }

    public Completable runAfterRunCallback(InvocationContext invocationContext) {
        return Flowable.fromIterable(this.plugins).concatMapCompletable(plugin -> plugin.afterRunCallback(invocationContext).doOnError(e -> logger.error("[{}] Error during callback 'afterRunCallback'", (Object)plugin.getName(), e)));
    }

    public Maybe<Event> runOnEventCallback(InvocationContext invocationContext, Event event) {
        return this.runMaybeCallbacks(plugin -> plugin.onEventCallback(invocationContext, event), "onEventCallback");
    }

    public Maybe<Content> runBeforeAgentCallback(BaseAgent agent, CallbackContext callbackContext) {
        return this.runMaybeCallbacks(plugin -> plugin.beforeAgentCallback(agent, callbackContext), "beforeAgentCallback");
    }

    public Maybe<Content> runAfterAgentCallback(BaseAgent agent, CallbackContext callbackContext) {
        return this.runMaybeCallbacks(plugin -> plugin.afterAgentCallback(agent, callbackContext), "afterAgentCallback");
    }

    public Maybe<LlmResponse> runBeforeModelCallback(CallbackContext callbackContext, LlmRequest.Builder llmRequest) {
        return this.runMaybeCallbacks(plugin -> plugin.beforeModelCallback(callbackContext, llmRequest), "beforeModelCallback");
    }

    public Maybe<LlmResponse> runAfterModelCallback(CallbackContext callbackContext, LlmResponse llmResponse) {
        return this.runMaybeCallbacks(plugin -> plugin.afterModelCallback(callbackContext, llmResponse), "afterModelCallback");
    }

    public Maybe<LlmResponse> runOnModelErrorCallback(CallbackContext callbackContext, LlmRequest.Builder llmRequest, Throwable error) {
        return this.runMaybeCallbacks(plugin -> plugin.onModelErrorCallback(callbackContext, llmRequest, error), "onModelErrorCallback");
    }

    public Maybe<Map<String, Object>> runBeforeToolCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext) {
        return this.runMaybeCallbacks(plugin -> plugin.beforeToolCallback(tool, toolArgs, toolContext), "beforeToolCallback");
    }

    public Maybe<Map<String, Object>> runAfterToolCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext, Map<String, Object> result) {
        return this.runMaybeCallbacks(plugin -> plugin.afterToolCallback(tool, toolArgs, toolContext, result), "afterToolCallback");
    }

    public Maybe<Map<String, Object>> runOnToolErrorCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext, Throwable error) {
        return this.runMaybeCallbacks(plugin -> plugin.onToolErrorCallback(tool, toolArgs, toolContext, error), "onToolErrorCallback");
    }

    private <T> Maybe<T> runMaybeCallbacks(Function<BasePlugin, Maybe<T>> callbackExecutor, String callbackName) {
        return Flowable.fromIterable(this.plugins).concatMapMaybe(plugin -> ((Maybe)callbackExecutor.apply((BasePlugin)plugin)).doOnSuccess(r -> logger.debug("Plugin '{}' returned a value for callback '{}', exiting early.", (Object)plugin.getName(), (Object)callbackName)).doOnError(e -> logger.error("[{}] Error during callback '{}'", new Object[]{plugin.getName(), callbackName, e}))).firstElement();
    }
}

