/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.plugins;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.CallbackContext;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.adk.plugins.BasePlugin;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolContext;
import com.google.genai.types.Content;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPlugin
extends BasePlugin {
    private static final Logger logger = LoggerFactory.getLogger(LoggingPlugin.class);
    private static final int MAX_CONTENT_LENGTH = 200;
    private static final int MAX_ARGS_LENGTH = 300;

    public LoggingPlugin(String name) {
        super(name);
    }

    public LoggingPlugin() {
        super("logging_plugin");
    }

    private void log(String message) {
        logger.info("[{}] {}", (Object)this.name, (Object)message);
    }

    @Override
    public Maybe<Content> onUserMessageCallback(InvocationContext invocationContext, Content userMessage) {
        return Maybe.fromAction(() -> {
            this.log("\ud83d\ude80 USER MESSAGE RECEIVED");
            this.log("   Invocation ID: " + invocationContext.invocationId());
            this.log("   Session ID: " + invocationContext.session().id());
            this.log("   User ID: " + invocationContext.userId());
            this.log("   App Name: " + invocationContext.appName());
            this.log("   Root Agent: " + invocationContext.agent().name());
            this.log("   User Content: " + this.formatContent(Optional.ofNullable(userMessage)));
            invocationContext.branch().ifPresent(branch -> this.log("   Branch: " + branch));
        });
    }

    @Override
    public Maybe<Content> beforeRunCallback(InvocationContext invocationContext) {
        return Maybe.fromAction(() -> {
            this.log("\ud83c\udfc3 INVOCATION STARTING");
            this.log("   Invocation ID: " + invocationContext.invocationId());
            this.log("   Starting Agent: " + invocationContext.agent().name());
        });
    }

    @Override
    public Maybe<Event> onEventCallback(InvocationContext invocationContext, Event event) {
        return Maybe.fromAction(() -> {
            this.log("\ud83d\udce2 EVENT YIELDED");
            this.log("   Event ID: " + event.id());
            this.log("   Author: " + event.author());
            this.log("   Content: " + this.formatContent(event.content()));
            this.log("   Final Response: " + event.finalResponse());
            if (!event.functionCalls().isEmpty()) {
                String funcCalls = event.functionCalls().stream().map(fc -> fc.name().orElse("Unknown")).collect(Collectors.joining(", "));
                this.log("   Function Calls: [" + funcCalls + "]");
            }
            if (!event.functionResponses().isEmpty()) {
                String funcResponses = event.functionResponses().stream().map(fr -> fr.name().orElse("Unknown")).collect(Collectors.joining(", "));
                this.log("   Function Responses: [" + funcResponses + "]");
            }
            event.longRunningToolIds().ifPresent(ids -> {
                if (!ids.isEmpty()) {
                    this.log("   Long Running Tools: " + String.valueOf(ids));
                }
            });
        });
    }

    @Override
    public Completable afterRunCallback(InvocationContext invocationContext) {
        return Completable.fromAction(() -> {
            this.log("\u2705 INVOCATION COMPLETED");
            this.log("   Invocation ID: " + invocationContext.invocationId());
            this.log("   Final Agent: " + invocationContext.agent().name());
        });
    }

    @Override
    public Maybe<Content> beforeAgentCallback(BaseAgent agent, CallbackContext callbackContext) {
        return Maybe.fromAction(() -> {
            this.log("\ud83e\udd16 AGENT STARTING");
            this.log("   Agent Name: " + agent.name());
            this.log("   Invocation ID: " + callbackContext.invocationId());
            callbackContext.branch().ifPresent(branch -> this.log("   Branch: " + branch));
        });
    }

    @Override
    public Maybe<Content> afterAgentCallback(BaseAgent agent, CallbackContext callbackContext) {
        return Maybe.fromAction(() -> {
            this.log("\ud83e\udd16 AGENT COMPLETED");
            this.log("   Agent Name: " + agent.name());
            this.log("   Invocation ID: " + callbackContext.invocationId());
        });
    }

    @Override
    public Maybe<LlmResponse> beforeModelCallback(CallbackContext callbackContext, LlmRequest.Builder llmRequest) {
        return Maybe.fromAction(() -> {
            LlmRequest request = llmRequest.build();
            this.log("\ud83e\udde0 LLM REQUEST");
            this.log("   Model: " + request.model().orElse("default"));
            this.log("   Agent: " + callbackContext.agentName());
            request.getFirstSystemInstruction().ifPresent(sysInstruction -> {
                Object truncatedInstruction = sysInstruction;
                if (((String)truncatedInstruction).length() > 200) {
                    truncatedInstruction = ((String)truncatedInstruction).substring(0, 200) + "...";
                }
                this.log("   System Instruction: '" + (String)truncatedInstruction + "'");
            });
            if (!request.tools().isEmpty()) {
                String toolNames = String.join((CharSequence)", ", request.tools().keySet());
                this.log("   Available Tools: [" + toolNames + "]");
            }
        });
    }

    @Override
    public Maybe<LlmResponse> afterModelCallback(CallbackContext callbackContext, LlmResponse llmResponse) {
        return Maybe.fromAction(() -> {
            this.log("\ud83e\udde0 LLM RESPONSE");
            this.log("   Agent: " + callbackContext.agentName());
            if (llmResponse.errorCode().isPresent()) {
                this.log("   \u274c ERROR - Code: " + String.valueOf(llmResponse.errorCode().get()));
                llmResponse.errorMessage().ifPresent(msg -> this.log("   Error Message: " + msg));
            } else {
                this.log("   Content: " + this.formatContent(llmResponse.content()));
                llmResponse.partial().ifPresent(partial -> this.log("   Partial: " + partial));
                llmResponse.turnComplete().ifPresent(turnComplete -> this.log("   Turn Complete: " + turnComplete));
            }
            llmResponse.usageMetadata().ifPresent(usage -> this.log("   Token Usage - Input: " + String.valueOf(usage.promptTokenCount()) + ", Output: " + String.valueOf(usage.candidatesTokenCount())));
        });
    }

    @Override
    public Maybe<LlmResponse> onModelErrorCallback(CallbackContext callbackContext, LlmRequest.Builder llmRequest, Throwable error) {
        return Maybe.fromAction(() -> {
            this.log("\ud83e\udde0 LLM ERROR");
            this.log("   Agent: " + callbackContext.agentName());
            this.log("   Error: " + error.getMessage());
            logger.error("[{}] LLM Error", (Object)this.name, (Object)error);
        });
    }

    @Override
    public Maybe<Map<String, Object>> beforeToolCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext) {
        return Maybe.fromAction(() -> {
            this.log("\ud83d\udd27 TOOL STARTING");
            this.log("   Tool Name: " + tool.name());
            this.log("   Agent: " + toolContext.agentName());
            toolContext.functionCallId().ifPresent(id -> this.log("   Function Call ID: " + id));
            this.log("   Arguments: " + this.formatArgs(toolArgs));
        });
    }

    @Override
    public Maybe<Map<String, Object>> afterToolCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext, Map<String, Object> result) {
        return Maybe.fromAction(() -> {
            this.log("\ud83d\udd27 TOOL COMPLETED");
            this.log("   Tool Name: " + tool.name());
            this.log("   Agent: " + toolContext.agentName());
            toolContext.functionCallId().ifPresent(id -> this.log("   Function Call ID: " + id));
            this.log("   Result: " + this.formatArgs(result));
        });
    }

    @Override
    public Maybe<Map<String, Object>> onToolErrorCallback(BaseTool tool, Map<String, Object> toolArgs, ToolContext toolContext, Throwable error) {
        return Maybe.fromAction(() -> {
            this.log("\ud83d\udd27 TOOL ERROR");
            this.log("   Tool Name: " + tool.name());
            this.log("   Agent: " + toolContext.agentName());
            toolContext.functionCallId().ifPresent(id -> this.log("   Function Call ID: " + id));
            this.log("   Arguments: " + this.formatArgs(toolArgs));
            this.log("   Error: " + error.getMessage());
            logger.error("[{}] Tool Error", (Object)this.name, (Object)error);
        });
    }

    private String formatContent(Optional<Content> contentOptional) {
        if (contentOptional.isEmpty()) {
            return "None";
        }
        Content content = contentOptional.get();
        if (content.parts().isEmpty() || ((List)content.parts().get()).isEmpty()) {
            return "None";
        }
        String combinedText = ((List)content.parts().get()).stream().map(part -> part.text().orElse("")).collect(Collectors.joining("\n")).trim();
        if (combinedText.length() > 200) {
            return combinedText.substring(0, 200) + "...";
        }
        return combinedText;
    }

    private String formatArgs(Map<String, Object> args) {
        if (args == null || args.isEmpty()) {
            return "{}";
        }
        String argsStr = args.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining(", "));
        if (argsStr.length() > 300) {
            return "{" + argsStr.substring(0, 300) + "...}";
        }
        return "{" + argsStr + "}";
    }
}

