/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.models;

import com.google.adk.models.BaseLlm;
import com.google.adk.models.BaseLlmConnection;
import com.google.adk.models.GeminiLlmConnection;
import com.google.adk.models.GeminiUtil;
import com.google.adk.models.LlmRequest;
import com.google.adk.models.LlmResponse;
import com.google.adk.models.VertexCredentials;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.Client;
import com.google.genai.types.Candidate;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import com.google.genai.types.HttpOptions;
import com.google.genai.types.LiveConnectConfig;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gemini
extends BaseLlm {
    private static final Logger logger = LoggerFactory.getLogger(Gemini.class);
    private static final ImmutableMap<String, String> TRACKING_HEADERS;
    private final Client apiClient;

    public Gemini(String modelName, Client apiClient) {
        super(modelName);
        this.apiClient = Objects.requireNonNull(apiClient, "apiClient cannot be null");
    }

    public Gemini(String modelName, String apiKey) {
        super(modelName);
        Objects.requireNonNull(apiKey, "apiKey cannot be null");
        this.apiClient = Client.builder().apiKey(apiKey).httpOptions(HttpOptions.builder().headers(TRACKING_HEADERS).build()).build();
    }

    public Gemini(String modelName, VertexCredentials vertexCredentials) {
        super(modelName);
        Objects.requireNonNull(vertexCredentials, "vertexCredentials cannot be null");
        Client.Builder apiClientBuilder = Client.builder().httpOptions(HttpOptions.builder().headers(TRACKING_HEADERS).build());
        vertexCredentials.project().ifPresent(arg_0 -> ((Client.Builder)apiClientBuilder).project(arg_0));
        vertexCredentials.location().ifPresent(arg_0 -> ((Client.Builder)apiClientBuilder).location(arg_0));
        vertexCredentials.credentials().ifPresent(arg_0 -> ((Client.Builder)apiClientBuilder).credentials(arg_0));
        this.apiClient = apiClientBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Flowable<LlmResponse> generateContent(LlmRequest llmRequest, boolean stream) {
        llmRequest = GeminiUtil.prepareGenenerateContentRequest(llmRequest, !this.apiClient.vertexAI(), false);
        GenerateContentConfig config = llmRequest.config().orElse(null);
        String effectiveModelName = llmRequest.model().orElse(this.model());
        logger.trace("Request Contents: {}", llmRequest.contents());
        logger.trace("Request Config: {}", (Object)config);
        if (stream) {
            logger.debug("Sending streaming generateContent request to model {}", (Object)effectiveModelName);
            CompletableFuture streamFuture = this.apiClient.async.models.generateContentStream(effectiveModelName, llmRequest.contents(), config);
            return Flowable.defer(() -> Gemini.processRawResponses((Flowable<GenerateContentResponse>)Flowable.fromFuture((Future)streamFuture).flatMapIterable(iterable -> iterable))).filter(llmResponse -> llmResponse.content().flatMap(Content::parts).map(parts -> !parts.isEmpty() && parts.stream().anyMatch(p -> p.functionCall().isPresent() || p.functionResponse().isPresent() || p.text().map(t -> !t.isBlank()).orElse(false) != false)).orElse(false));
        }
        logger.debug("Sending generateContent request to model {}", (Object)effectiveModelName);
        return Flowable.fromFuture((Future)((Object)this.apiClient.async.models.generateContent(effectiveModelName, llmRequest.contents(), config).thenApplyAsync(LlmResponse::create)));
    }

    static Flowable<LlmResponse> processRawResponses(Flowable<GenerateContentResponse> rawResponses) {
        StringBuilder accumulatedText = new StringBuilder();
        StringBuilder accumulatedThoughtText = new StringBuilder();
        GenerateContentResponse[] lastRawResponseHolder = new GenerateContentResponse[]{null};
        return rawResponses.concatMap(rawResponse -> {
            lastRawResponseHolder[0] = rawResponse;
            logger.trace("Raw streaming response: {}", rawResponse);
            ArrayList<LlmResponse> responsesToEmit = new ArrayList<LlmResponse>();
            LlmResponse currentProcessedLlmResponse = LlmResponse.create(rawResponse);
            Optional<Part> part = GeminiUtil.getPart0FromLlmResponse(currentProcessedLlmResponse);
            String currentTextChunk = part.flatMap(Part::text).orElse("");
            if (!currentTextChunk.isBlank()) {
                if (part.get().thought().orElse(false).booleanValue()) {
                    accumulatedThoughtText.append(currentTextChunk);
                    responsesToEmit.add(Gemini.thinkingResponseFromText(currentTextChunk).toBuilder().partial(true).build());
                } else {
                    accumulatedText.append(currentTextChunk);
                    responsesToEmit.add(Gemini.responseFromText(currentTextChunk).toBuilder().partial(true).build());
                }
            } else {
                if (accumulatedThoughtText.length() > 0 && GeminiUtil.shouldEmitAccumulatedText(currentProcessedLlmResponse)) {
                    LlmResponse aggregatedThoughtResponse = Gemini.thinkingResponseFromText(accumulatedThoughtText.toString());
                    responsesToEmit.add(aggregatedThoughtResponse);
                    accumulatedThoughtText.setLength(0);
                }
                if (accumulatedText.length() > 0 && GeminiUtil.shouldEmitAccumulatedText(currentProcessedLlmResponse)) {
                    LlmResponse aggregatedTextResponse = Gemini.responseFromText(accumulatedText.toString());
                    responsesToEmit.add(aggregatedTextResponse);
                    accumulatedText.setLength(0);
                }
                responsesToEmit.add(currentProcessedLlmResponse);
            }
            logger.debug("Responses to emit: {}", responsesToEmit);
            return Flowable.fromIterable(responsesToEmit);
        }).concatWith((Publisher)Flowable.defer(() -> {
            GenerateContentResponse finalRawResp = lastRawResponseHolder[0];
            if (finalRawResp == null) {
                return Flowable.empty();
            }
            boolean isStop = finalRawResp.candidates().flatMap(candidates -> candidates.stream().findFirst()).flatMap(Candidate::finishReason).map(finishReason -> finishReason.knownEnum() == FinishReason.Known.STOP).orElse(false);
            if (isStop) {
                ArrayList<LlmResponse> finalResponses = new ArrayList<LlmResponse>();
                if (accumulatedThoughtText.length() > 0) {
                    finalResponses.add(Gemini.thinkingResponseFromText(accumulatedThoughtText.toString()));
                }
                if (accumulatedText.length() > 0) {
                    finalResponses.add(Gemini.responseFromText(accumulatedText.toString()));
                }
                return Flowable.fromIterable(finalResponses);
            }
            return Flowable.empty();
        }));
    }

    private static LlmResponse responseFromText(String accumulatedText) {
        return LlmResponse.builder().content(Content.builder().role("model").parts(new Part[]{Part.fromText((String)accumulatedText)}).build()).build();
    }

    private static LlmResponse thinkingResponseFromText(String accumulatedThoughtText) {
        return LlmResponse.builder().content(Content.builder().role("model").parts(new Part[]{Part.fromText((String)accumulatedThoughtText).toBuilder().thought(true).build()}).build()).build();
    }

    @Override
    public BaseLlmConnection connect(LlmRequest llmRequest) {
        if (!this.apiClient.vertexAI()) {
            llmRequest = GeminiUtil.sanitizeRequestForGeminiApi(llmRequest);
        }
        logger.debug("Establishing Gemini connection.");
        LiveConnectConfig liveConnectConfig = llmRequest.liveConnectConfig();
        String effectiveModelName = llmRequest.model().orElse(this.model());
        logger.debug("Connecting to model {}", (Object)effectiveModelName);
        logger.trace("Connection Config: {}", (Object)liveConnectConfig);
        return new GeminiLlmConnection(this.apiClient, effectiveModelName, liveConnectConfig);
    }

    static {
        String frameworkLabel = "google-adk/0.5.0";
        String languageLabel = "gl-java/" + StandardSystemProperty.JAVA_VERSION.value();
        String versionHeaderValue = String.format("%s %s", frameworkLabel, languageLabel);
        TRACKING_HEADERS = ImmutableMap.of((Object)"x-goog-api-client", (Object)versionHeaderValue, (Object)"user-agent", (Object)versionHeaderValue);
    }

    public static class Builder {
        private String modelName;
        private Client apiClient;
        private String apiKey;
        private VertexCredentials vertexCredentials;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder apiClient(Client apiClient) {
            this.apiClient = apiClient;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder vertexCredentials(VertexCredentials vertexCredentials) {
            this.vertexCredentials = vertexCredentials;
            return this;
        }

        public Gemini build() {
            Objects.requireNonNull(this.modelName, "modelName must be set.");
            if (this.apiClient != null) {
                return new Gemini(this.modelName, this.apiClient);
            }
            if (this.apiKey != null) {
                return new Gemini(this.modelName, this.apiKey);
            }
            if (this.vertexCredentials != null) {
                return new Gemini(this.modelName, this.vertexCredentials);
            }
            return new Gemini(this.modelName, Client.builder().httpOptions(HttpOptions.builder().headers(TRACKING_HEADERS).build()).build());
        }
    }
}

