/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.events.Event;
import com.google.adk.flows.llmflows.Functions;
import com.google.adk.flows.llmflows.RequestProcessor;
import com.google.adk.models.LlmRequest;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.ToolConfirmation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import com.google.genai.types.FunctionResponse;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestConfirmationLlmRequestProcessor
implements RequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(RequestConfirmationLlmRequestProcessor.class);
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module());

    @Override
    public Single<RequestProcessor.RequestProcessingResult> processRequest(InvocationContext invocationContext, LlmRequest llmRequest) {
        List<Event> events = invocationContext.session().events();
        if (events.isEmpty()) {
            logger.info("No events are present in the session. Skipping request confirmation processing.");
            return Single.just((Object)RequestProcessor.RequestProcessingResult.create(llmRequest, (Iterable<Event>)ImmutableList.of()));
        }
        ImmutableMap<String, ToolConfirmation> requestConfirmationFunctionResponses = this.filterRequestConfirmationFunctionResponses(events);
        if (requestConfirmationFunctionResponses.isEmpty()) {
            logger.info("No request confirmation function responses found.");
            return Single.just((Object)RequestProcessor.RequestProcessingResult.create(llmRequest, (Iterable<Event>)ImmutableList.of()));
        }
        for (ImmutableList functionCalls : (ImmutableList)events.stream().map(Event::functionCalls).filter(fc -> !fc.isEmpty()).collect(ImmutableList.toImmutableList())) {
            ImmutableMap<String, FunctionCall> toolsToResumeWithArgs = this.filterToolsToResumeWithArgs((ImmutableList<FunctionCall>)functionCalls, (Map<String, ToolConfirmation>)requestConfirmationFunctionResponses);
            ImmutableMap toolsToResumeWithConfirmation = (ImmutableMap)toolsToResumeWithArgs.keySet().stream().filter(id -> events.stream().flatMap(e -> e.functionResponses().stream()).anyMatch(fr -> Objects.equals(fr.id().orElse(null), id))).collect(ImmutableMap.toImmutableMap(k -> k, arg_0 -> requestConfirmationFunctionResponses.get(arg_0)));
            if (toolsToResumeWithConfirmation.isEmpty()) {
                logger.info("No tools to resume with confirmation.");
                continue;
            }
            return this.assembleEvent(invocationContext, (Collection<FunctionCall>)toolsToResumeWithArgs.values(), (Map<String, ToolConfirmation>)toolsToResumeWithConfirmation).map(event -> RequestProcessor.RequestProcessingResult.create(llmRequest, (Iterable<Event>)ImmutableList.of((Object)event))).toSingle();
        }
        return Single.just((Object)RequestProcessor.RequestProcessingResult.create(llmRequest, (Iterable<Event>)ImmutableList.of()));
    }

    private Maybe<Event> assembleEvent(InvocationContext invocationContext, Collection<FunctionCall> functionCalls, Map<String, ToolConfirmation> toolConfirmations) {
        ImmutableMap.Builder toolsBuilder = ImmutableMap.builder();
        BaseAgent baseAgent = invocationContext.agent();
        if (baseAgent instanceof LlmAgent) {
            LlmAgent llmAgent = (LlmAgent)baseAgent;
            for (BaseTool tool : llmAgent.tools()) {
                toolsBuilder.put((Object)tool.name(), (Object)tool);
            }
        }
        Event functionCallEvent = Event.builder().content(Content.builder().parts((List)functionCalls.stream().map(fc -> Part.builder().functionCall(fc).build()).collect(ImmutableList.toImmutableList())).build()).build();
        return Functions.handleFunctionCalls(invocationContext, functionCallEvent, (Map<String, BaseTool>)toolsBuilder.buildOrThrow(), toolConfirmations);
    }

    private ImmutableMap<String, ToolConfirmation> filterRequestConfirmationFunctionResponses(List<Event> events) {
        return (ImmutableMap)events.stream().filter(event -> Objects.equals(event.author(), "user")).flatMap(event -> event.functionResponses().stream()).filter(functionResponse -> functionResponse.id().isPresent()).filter(functionResponse -> Objects.equals(functionResponse.name().orElse(null), "adk_request_confirmation")).map(this::maybeCreateToolConfirmationEntry).flatMap(Optional::stream).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<Map.Entry<String, ToolConfirmation>> maybeCreateToolConfirmationEntry(FunctionResponse functionResponse) {
        Map responseMap = (Map)functionResponse.response().orElse(ImmutableMap.of());
        if (responseMap.size() != 1 || !responseMap.containsKey("response")) {
            return Optional.of(Map.entry((String)functionResponse.id().get(), (ToolConfirmation)this.objectMapper.convertValue((Object)responseMap, ToolConfirmation.class)));
        }
        try {
            return Optional.of(Map.entry((String)functionResponse.id().get(), (ToolConfirmation)this.objectMapper.readValue((String)responseMap.get("response"), ToolConfirmation.class)));
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to parse tool confirmation response", (Throwable)e);
            return Optional.empty();
        }
    }

    private ImmutableMap<String, FunctionCall> filterToolsToResumeWithArgs(ImmutableList<FunctionCall> functionCalls, Map<String, ToolConfirmation> requestConfirmationFunctionResponses) {
        return (ImmutableMap)functionCalls.stream().filter(fc -> fc.id().isPresent()).filter(fc -> requestConfirmationFunctionResponses.containsKey(fc.id().get())).filter(fc -> Objects.equals(fc.name().orElse(null), "adk_request_confirmation")).filter(fc -> ((Map)fc.args().orElse(ImmutableMap.of())).containsKey("originalFunctionCall")).collect(ImmutableMap.toImmutableMap(fc -> (String)fc.id().get(), fc -> (FunctionCall)this.objectMapper.convertValue(((Map)fc.args().get()).get("originalFunctionCall"), FunctionCall.class)));
    }
}

