/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.ConfigAgentUtils;
import com.google.adk.agents.LlmAgent;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.BaseToolset;
import com.google.adk.utils.ComponentRegistry;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ToolResolver {
    private static final Logger logger = LoggerFactory.getLogger(LlmAgent.class);

    private ToolResolver() {
    }

    static ImmutableList<Object> resolveToolsAndToolsets(List<BaseTool.ToolConfig> toolConfigs, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        if (toolConfigs == null || toolConfigs.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder resolvedItems = ImmutableList.builder();
        for (BaseTool.ToolConfig toolConfig : toolConfigs) {
            try {
                if (Strings.isNullOrEmpty((String)toolConfig.name())) {
                    throw new ConfigAgentUtils.ConfigurationException("Tool name cannot be empty");
                }
                String toolName = toolConfig.name().trim();
                BaseToolset toolset = ToolResolver.resolveToolsetFromClass(toolName, toolConfig.args(), configAbsPath);
                if (toolset != null) {
                    resolvedItems.add((Object)toolset);
                    logger.debug("Successfully resolved toolset from class: {}", (Object)toolName);
                    continue;
                }
                BaseTool tool = ToolResolver.resolveToolInstance(toolName);
                if (tool != null) {
                    resolvedItems.add((Object)tool);
                    logger.debug("Successfully resolved tool instance: {}", (Object)toolName);
                    continue;
                }
                BaseTool toolFromClass = ToolResolver.resolveToolFromClass(toolName, toolConfig.args(), configAbsPath);
                if (toolFromClass != null) {
                    resolvedItems.add((Object)toolFromClass);
                    logger.debug("Successfully resolved tool from class: {}", (Object)toolName);
                    continue;
                }
                throw new ConfigAgentUtils.ConfigurationException("Tool or toolset not found: " + toolName);
            }
            catch (Exception e) {
                String errorMsg = "Failed to resolve tool or toolset: " + toolConfig.name();
                logger.error(errorMsg, (Throwable)e);
                throw new ConfigAgentUtils.ConfigurationException(errorMsg, e);
            }
        }
        return resolvedItems.build();
    }

    static ImmutableList<BaseTool> resolveTools(List<BaseTool.ToolConfig> toolConfigs, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        if (toolConfigs == null || toolConfigs.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder resolvedTools = ImmutableList.builder();
        for (BaseTool.ToolConfig toolConfig : toolConfigs) {
            try {
                if (Strings.isNullOrEmpty((String)toolConfig.name())) {
                    throw new ConfigAgentUtils.ConfigurationException("Tool name cannot be empty");
                }
                String toolName = toolConfig.name().trim();
                BaseTool tool = ToolResolver.resolveToolInstance(toolName);
                if (tool != null) {
                    resolvedTools.add((Object)tool);
                    logger.debug("Successfully resolved tool instance: {}", (Object)toolName);
                    continue;
                }
                BaseTool toolFromClass = ToolResolver.resolveToolFromClass(toolName, toolConfig.args(), configAbsPath);
                if (toolFromClass != null) {
                    resolvedTools.add((Object)toolFromClass);
                    logger.debug("Successfully resolved tool from class: {}", (Object)toolName);
                    continue;
                }
                throw new ConfigAgentUtils.ConfigurationException("Tool not found: " + toolName);
            }
            catch (Exception e) {
                String errorMsg = "Failed to resolve tool: " + toolConfig.name();
                logger.error(errorMsg, (Throwable)e);
                throw new ConfigAgentUtils.ConfigurationException(errorMsg, e);
            }
        }
        return resolvedTools.build();
    }

    @Nullable
    static BaseTool resolveToolInstance(String toolName) {
        ComponentRegistry registry = ComponentRegistry.getInstance();
        Optional<BaseTool> toolOpt = ComponentRegistry.resolveToolInstance(toolName);
        if (toolOpt.isPresent()) {
            return toolOpt.get();
        }
        if (ToolResolver.isJavaQualifiedName(toolName)) {
            try {
                BaseTool tool = ToolResolver.resolveInstanceViaReflection(toolName);
                if (tool != null) {
                    registry.register(toolName, tool);
                    logger.debug("Resolved and registered tool instance via reflection: {}", (Object)toolName);
                    return tool;
                }
            }
            catch (Exception e) {
                logger.debug("Failed to resolve instance via reflection: {}", (Object)toolName, (Object)e);
            }
        }
        logger.debug("Could not resolve tool instance: {}", (Object)toolName);
        return null;
    }

    @Nullable
    static BaseToolset resolveToolsetInstance(String toolsetName) {
        ComponentRegistry registry = ComponentRegistry.getInstance();
        Optional<BaseToolset> toolsetOpt = ComponentRegistry.resolveToolsetInstance(toolsetName);
        if (toolsetOpt.isPresent()) {
            return toolsetOpt.get();
        }
        if (ToolResolver.isJavaQualifiedName(toolsetName)) {
            try {
                BaseToolset toolset = ToolResolver.resolveToolsetInstanceViaReflection(toolsetName);
                if (toolset != null) {
                    registry.register(toolsetName, toolset);
                    logger.debug("Resolved and registered toolset instance via reflection: {}", (Object)toolsetName);
                    return toolset;
                }
            }
            catch (Exception e) {
                logger.debug("Failed to resolve toolset instance via reflection: {}", (Object)toolsetName, (Object)e);
            }
        }
        logger.debug("Could not resolve toolset instance: {}", (Object)toolsetName);
        return null;
    }

    @Nullable
    static BaseToolset resolveToolsetFromClass(String className, BaseTool.ToolArgsConfig args, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        ComponentRegistry registry = ComponentRegistry.getInstance();
        Optional<Class<? extends BaseToolset>> toolsetClassOpt = ComponentRegistry.resolveToolsetClass(className);
        Class<? extends BaseToolset> toolsetClass = null;
        if (toolsetClassOpt.isPresent()) {
            toolsetClass = toolsetClassOpt.get();
        } else if (ToolResolver.isJavaQualifiedName(className)) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (BaseToolset.class.isAssignableFrom(clazz)) {
                    toolsetClass = clazz.asSubclass(BaseToolset.class);
                    registry.register(className, toolsetClass);
                    logger.debug("Resolved and registered toolset class via reflection: {}", (Object)className);
                }
            }
            catch (ClassNotFoundException e) {
                logger.debug("Failed to resolve toolset class via reflection: {}", (Object)className, (Object)e);
                return null;
            }
        }
        if (toolsetClass == null) {
            logger.debug("Could not resolve toolset class: {}", (Object)className);
            return null;
        }
        BaseToolset toolsetInstance = ToolResolver.resolveToolsetInstance(className);
        if (toolsetInstance != null) {
            logger.debug("Successfully resolved toolset instance: {}", (Object)className);
            return toolsetInstance;
        }
        try {
            Method fromConfigMethod = toolsetClass.getMethod("fromConfig", BaseTool.ToolConfig.class, String.class);
            BaseTool.ToolConfig toolConfig = new BaseTool.ToolConfig(className, args);
            Object instance = fromConfigMethod.invoke(null, toolConfig, "");
            if (instance instanceof BaseToolset) {
                BaseToolset baseToolset = (BaseToolset)instance;
                return baseToolset;
            }
        }
        catch (NoSuchMethodException e) {
            logger.debug("Class {} does not have fromConfig method", (Object)className);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error("Cannot access fromConfig method on toolset class {}", (Object)className, (Object)e);
            throw new ConfigAgentUtils.ConfigurationException("Access denied to fromConfig method on class " + className, e);
        }
        catch (InvocationTargetException e) {
            logger.error("Error during fromConfig method invocation on toolset class {}", (Object)className, (Object)e.getCause());
            throw new ConfigAgentUtils.ConfigurationException("Error during toolset creation from class " + className, e.getCause());
        }
        catch (RuntimeException e) {
            logger.error("Unexpected error calling fromConfig on toolset class {}", (Object)className, (Object)e);
            throw new ConfigAgentUtils.ConfigurationException("Unexpected error creating toolset from class " + className, e);
        }
        return null;
    }

    @Nullable
    static BaseToolset resolveToolsetInstanceViaReflection(String toolsetName) throws Exception {
        int lastDotIndex = toolsetName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        String className = toolsetName.substring(0, lastDotIndex);
        String fieldName = toolsetName.substring(lastDotIndex + 1);
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        try {
            Field field = clazz.getField(fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                logger.debug("Field {} in class {} is not static", (Object)fieldName, (Object)className);
                return null;
            }
            Object instance = field.get(null);
            if (instance instanceof BaseToolset) {
                BaseToolset baseToolset = (BaseToolset)instance;
                return baseToolset;
            }
            logger.debug("Field {} in class {} is not a BaseToolset instance", (Object)fieldName, (Object)className);
            return null;
        }
        catch (NoSuchFieldException e) {
            logger.debug("Field {} not found in class {}", (Object)fieldName, (Object)className);
            return null;
        }
    }

    @Nullable
    static BaseTool resolveToolFromClass(String className, BaseTool.ToolArgsConfig args, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        ComponentRegistry registry = ComponentRegistry.getInstance();
        Optional<Class<? extends BaseTool>> classOpt = ComponentRegistry.resolveToolClass(className);
        Class<? extends BaseTool> toolClass = null;
        if (classOpt.isPresent()) {
            toolClass = classOpt.get();
        } else if (ToolResolver.isJavaQualifiedName(className)) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (BaseTool.class.isAssignableFrom(clazz)) {
                    toolClass = clazz.asSubclass(BaseTool.class);
                    registry.register(className, toolClass);
                    logger.debug("Resolved and registered tool class via reflection: {}", (Object)className);
                }
            }
            catch (ClassNotFoundException e) {
                logger.debug("Failed to resolve class via reflection: {}", (Object)className, (Object)e);
                return null;
            }
        }
        if (toolClass == null) {
            return null;
        }
        if (args != null && !args.isEmpty()) {
            try {
                Method fromConfigMethod = toolClass.getMethod("fromConfig", BaseTool.ToolArgsConfig.class, String.class);
                Object instance = fromConfigMethod.invoke(null, args, configAbsPath);
                if (instance instanceof BaseTool) {
                    BaseTool baseTool = (BaseTool)instance;
                    return baseTool;
                }
            }
            catch (NoSuchMethodException e) {
                throw new ConfigAgentUtils.ConfigurationException("Class " + className + " does not have fromConfig method but args were provided.", e);
            }
            catch (Exception e) {
                logger.error("Error calling fromConfig on class {}", (Object)className, (Object)e);
                throw new ConfigAgentUtils.ConfigurationException("Error creating tool from class " + className, e);
            }
        }
        try {
            Constructor<? extends BaseTool> constructor = toolClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigAgentUtils.ConfigurationException("Class " + className + " does not have a default constructor and no args were provided.", e);
        }
        catch (Exception e) {
            logger.error("Error calling default constructor on class {}", (Object)className, (Object)e);
            throw new ConfigAgentUtils.ConfigurationException("Error creating tool from class " + className + " using default constructor", e);
        }
    }

    static boolean isJavaQualifiedName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        return name.contains(".") && name.matches("^[a-zA-Z_$][a-zA-Z0-9_.$]*$");
    }

    @Nullable
    static BaseTool resolveInstanceViaReflection(String toolName) throws Exception {
        int lastDotIndex = toolName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        String className = toolName.substring(0, lastDotIndex);
        String fieldName = toolName.substring(lastDotIndex + 1);
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        try {
            Field field = clazz.getField(fieldName);
            if (!Modifier.isStatic(field.getModifiers())) {
                logger.debug("Field {} in class {} is not static", (Object)fieldName, (Object)className);
                return null;
            }
            Object instance = field.get(null);
            if (instance instanceof BaseTool) {
                BaseTool baseTool = (BaseTool)instance;
                return baseTool;
            }
            logger.debug("Field {} in class {} is not a BaseTool instance", (Object)fieldName, (Object)className);
        }
        catch (NoSuchFieldException e) {
            logger.debug("Field {} not found in class {}", (Object)fieldName, (Object)className);
        }
        return null;
    }
}

