/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.ConfigAgentUtils;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.SequentialAgentConfig;
import com.google.adk.events.Event;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialAgent
extends BaseAgent {
    private static final Logger logger = LoggerFactory.getLogger(SequentialAgent.class);

    private SequentialAgent(String name, String description, List<? extends BaseAgent> subAgents, List<Callbacks.BeforeAgentCallback> beforeAgentCallback, List<Callbacks.AfterAgentCallback> afterAgentCallback) {
        super(name, description, subAgents, beforeAgentCallback, afterAgentCallback);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Flowable<Event> runAsyncImpl(InvocationContext invocationContext) {
        return Flowable.fromIterable(this.subAgents()).concatMap(subAgent -> subAgent.runAsync(invocationContext));
    }

    @Override
    protected Flowable<Event> runLiveImpl(InvocationContext invocationContext) {
        return Flowable.fromIterable(this.subAgents()).concatMap(subAgent -> subAgent.runLive(invocationContext));
    }

    public static SequentialAgent fromConfig(SequentialAgentConfig config, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        logger.debug("Creating SequentialAgent from config: {}", (Object)config.name());
        Builder builder = SequentialAgent.builder();
        ConfigAgentUtils.resolveAndSetCommonAgentFields(builder, config, configAbsPath);
        SequentialAgent agent = builder.build();
        logger.info("Successfully created SequentialAgent: {} with {} subagents", (Object)agent.name(), (Object)(agent.subAgents() != null ? agent.subAgents().size() : 0));
        return agent;
    }

    public static class Builder
    extends BaseAgent.Builder<Builder> {
        @Override
        public SequentialAgent build() {
            return new SequentialAgent(this.name, this.description, (List<? extends BaseAgent>)this.subAgents, (List<Callbacks.BeforeAgentCallback>)this.beforeAgentCallback, (List<Callbacks.AfterAgentCallback>)this.afterAgentCallback);
        }
    }
}

