/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.AutoValue_RunConfig;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.Modality;
import com.google.genai.types.SpeechConfig;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
public abstract class RunConfig {
    private static final Logger logger = LoggerFactory.getLogger(RunConfig.class);

    @Nullable
    public abstract SpeechConfig speechConfig();

    public abstract ImmutableList<Modality> responseModalities();

    public abstract boolean saveInputBlobsAsArtifacts();

    public abstract StreamingMode streamingMode();

    public abstract ToolExecutionMode toolExecutionMode();

    @Nullable
    public abstract AudioTranscriptionConfig outputAudioTranscription();

    @Nullable
    public abstract AudioTranscriptionConfig inputAudioTranscription();

    public abstract int maxLlmCalls();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_RunConfig.Builder().setSaveInputBlobsAsArtifacts(false).setResponseModalities((Iterable<Modality>)ImmutableList.of()).setStreamingMode(StreamingMode.NONE).setToolExecutionMode(ToolExecutionMode.NONE).setMaxLlmCalls(500);
    }

    public static Builder builder(RunConfig runConfig) {
        return new AutoValue_RunConfig.Builder().setSaveInputBlobsAsArtifacts(runConfig.saveInputBlobsAsArtifacts()).setStreamingMode(runConfig.streamingMode()).setToolExecutionMode(runConfig.toolExecutionMode()).setMaxLlmCalls(runConfig.maxLlmCalls()).setResponseModalities((Iterable<Modality>)runConfig.responseModalities()).setSpeechConfig(runConfig.speechConfig()).setOutputAudioTranscription(runConfig.outputAudioTranscription()).setInputAudioTranscription(runConfig.inputAudioTranscription());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @CanIgnoreReturnValue
        public abstract Builder setSpeechConfig(@Nullable SpeechConfig var1);

        @CanIgnoreReturnValue
        public abstract Builder setResponseModalities(Iterable<Modality> var1);

        @CanIgnoreReturnValue
        public abstract Builder setSaveInputBlobsAsArtifacts(boolean var1);

        @CanIgnoreReturnValue
        public abstract Builder setStreamingMode(StreamingMode var1);

        @CanIgnoreReturnValue
        public abstract Builder setToolExecutionMode(ToolExecutionMode var1);

        @CanIgnoreReturnValue
        public abstract Builder setOutputAudioTranscription(@Nullable AudioTranscriptionConfig var1);

        @CanIgnoreReturnValue
        public abstract Builder setInputAudioTranscription(@Nullable AudioTranscriptionConfig var1);

        @CanIgnoreReturnValue
        public abstract Builder setMaxLlmCalls(int var1);

        abstract RunConfig autoBuild();

        public RunConfig build() {
            RunConfig runConfig = this.autoBuild();
            if (runConfig.maxLlmCalls() < 0) {
                logger.warn("maxLlmCalls is negative. This will result in no enforcement on total number of llm calls that will be made for a run. This may not be ideal, as this could result in a never ending communication between the model and the agent in certain cases.");
            }
            return runConfig;
        }
    }

    public static enum StreamingMode {
        NONE,
        SSE,
        BIDI;

    }

    public static enum ToolExecutionMode {
        NONE,
        SEQUENTIAL,
        PARALLEL;

    }
}

