/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.ConfigAgentUtils;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.ParallelAgentConfig;
import com.google.adk.events.Event;
import com.google.common.base.Strings;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelAgent
extends BaseAgent {
    private static final Logger logger = LoggerFactory.getLogger(ParallelAgent.class);

    private ParallelAgent(String name, String description, List<? extends BaseAgent> subAgents, List<Callbacks.BeforeAgentCallback> beforeAgentCallback, List<Callbacks.AfterAgentCallback> afterAgentCallback) {
        super(name, description, subAgents, beforeAgentCallback, afterAgentCallback);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ParallelAgent fromConfig(ParallelAgentConfig config, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        logger.debug("Creating ParallelAgent from config: {}", (Object)config.name());
        Builder builder = ParallelAgent.builder();
        ConfigAgentUtils.resolveAndSetCommonAgentFields(builder, config, configAbsPath);
        ParallelAgent agent = builder.build();
        logger.info("Successfully created ParallelAgent: {} with {} subagents", (Object)agent.name(), (Object)(agent.subAgents() != null ? agent.subAgents().size() : 0));
        return agent;
    }

    private static void setBranchForCurrentAgent(BaseAgent currentAgent, InvocationContext invocationContext) {
        String branch = invocationContext.branch().orElse(null);
        if (Strings.isNullOrEmpty((String)branch)) {
            invocationContext.branch(currentAgent.name());
        } else {
            invocationContext.branch(branch + "." + currentAgent.name());
        }
    }

    @Override
    protected Flowable<Event> runAsyncImpl(InvocationContext invocationContext) {
        ParallelAgent.setBranchForCurrentAgent(this, invocationContext);
        List<? extends BaseAgent> currentSubAgents = this.subAgents();
        if (currentSubAgents == null || currentSubAgents.isEmpty()) {
            return Flowable.empty();
        }
        ArrayList<Flowable<Event>> agentFlowables = new ArrayList<Flowable<Event>>();
        for (BaseAgent baseAgent : currentSubAgents) {
            agentFlowables.add(baseAgent.runAsync(invocationContext));
        }
        return Flowable.merge(agentFlowables);
    }

    @Override
    protected Flowable<Event> runLiveImpl(InvocationContext invocationContext) {
        return Flowable.error((Throwable)new UnsupportedOperationException("runLive is not defined for ParallelAgent yet."));
    }

    public static class Builder
    extends BaseAgent.Builder<Builder> {
        @Override
        public ParallelAgent build() {
            return new ParallelAgent(this.name, this.description, (List<? extends BaseAgent>)this.subAgents, (List<Callbacks.BeforeAgentCallback>)this.beforeAgentCallback, (List<Callbacks.AfterAgentCallback>)this.afterAgentCallback);
        }
    }
}

