/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.Optional;

public class LoopAgent
extends BaseAgent {
    private final Optional<Integer> maxIterations;

    private LoopAgent(String name, String description, List<? extends BaseAgent> subAgents, Optional<Integer> maxIterations, List<Callbacks.BeforeAgentCallback> beforeAgentCallback, List<Callbacks.AfterAgentCallback> afterAgentCallback) {
        super(name, description, subAgents, beforeAgentCallback, afterAgentCallback);
        this.maxIterations = maxIterations;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Flowable<Event> runAsyncImpl(InvocationContext invocationContext) {
        List<? extends BaseAgent> subAgents = this.subAgents();
        if (subAgents == null || subAgents.isEmpty()) {
            return Flowable.empty();
        }
        return Flowable.fromIterable(subAgents).concatMap(subAgent -> subAgent.runAsync(invocationContext)).repeat((long)this.maxIterations.orElse(Integer.MAX_VALUE).intValue()).takeUntil(LoopAgent::hasEscalateAction);
    }

    @Override
    protected Flowable<Event> runLiveImpl(InvocationContext invocationContext) {
        return Flowable.error((Throwable)new UnsupportedOperationException("runLive is not defined for LoopAgent yet."));
    }

    private static boolean hasEscalateAction(Event event) {
        return event.actions().escalate().orElse(false);
    }

    public static class Builder
    extends BaseAgent.Builder<Builder> {
        private Optional<Integer> maxIterations = Optional.empty();

        @CanIgnoreReturnValue
        public Builder maxIterations(int maxIterations) {
            this.maxIterations = Optional.of(maxIterations);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxIterations(Optional<Integer> maxIterations) {
            this.maxIterations = maxIterations;
            return this;
        }

        @Override
        public LoopAgent build() {
            return new LoopAgent(this.name, this.description, (List<? extends BaseAgent>)this.subAgents, this.maxIterations, (List<Callbacks.BeforeAgentCallback>)this.beforeAgentCallback, (List<Callbacks.AfterAgentCallback>)this.afterAgentCallback);
        }
    }
}

