/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.adk.SchemaUtils;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.ConfigAgentUtils;
import com.google.adk.agents.Instruction;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgentConfig;
import com.google.adk.agents.ReadonlyContext;
import com.google.adk.agents.ToolResolver;
import com.google.adk.codeexecutors.BaseCodeExecutor;
import com.google.adk.events.Event;
import com.google.adk.examples.BaseExampleProvider;
import com.google.adk.examples.Example;
import com.google.adk.flows.llmflows.AutoFlow;
import com.google.adk.flows.llmflows.BaseLlmFlow;
import com.google.adk.flows.llmflows.SingleFlow;
import com.google.adk.models.BaseLlm;
import com.google.adk.models.LlmRegistry;
import com.google.adk.models.Model;
import com.google.adk.tools.BaseTool;
import com.google.adk.tools.BaseToolset;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.Part;
import com.google.genai.types.Schema;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlmAgent
extends BaseAgent {
    private static final Logger logger = LoggerFactory.getLogger(LlmAgent.class);
    private final Optional<Model> model;
    private final Instruction instruction;
    private final Instruction globalInstruction;
    private final List<Object> toolsUnion;
    private final ImmutableList<BaseToolset> toolsets;
    private final Optional<GenerateContentConfig> generateContentConfig;
    private final Optional<BaseExampleProvider> exampleProvider;
    private final IncludeContents includeContents;
    private final boolean planning;
    private final Optional<Integer> maxSteps;
    private final boolean disallowTransferToParent;
    private final boolean disallowTransferToPeers;
    private final Optional<List<? extends Callbacks.BeforeModelCallback>> beforeModelCallback;
    private final Optional<List<? extends Callbacks.AfterModelCallback>> afterModelCallback;
    private final Optional<List<? extends Callbacks.BeforeToolCallback>> beforeToolCallback;
    private final Optional<List<? extends Callbacks.AfterToolCallback>> afterToolCallback;
    private final Optional<Schema> inputSchema;
    private final Optional<Schema> outputSchema;
    private final Optional<Executor> executor;
    private final Optional<String> outputKey;
    private final Optional<BaseCodeExecutor> codeExecutor;
    private volatile Model resolvedModel;
    private final BaseLlmFlow llmFlow;

    protected LlmAgent(Builder builder) {
        super(builder.name, builder.description, (List<? extends BaseAgent>)builder.subAgents, (List<? extends Callbacks.BeforeAgentCallback>)builder.beforeAgentCallback, (List<? extends Callbacks.AfterAgentCallback>)builder.afterAgentCallback);
        this.model = Optional.ofNullable(builder.model);
        this.instruction = builder.instruction == null ? new Instruction.Static("") : builder.instruction;
        this.globalInstruction = builder.globalInstruction == null ? new Instruction.Static("") : builder.globalInstruction;
        this.generateContentConfig = Optional.ofNullable(builder.generateContentConfig);
        this.exampleProvider = Optional.ofNullable(builder.exampleProvider);
        this.includeContents = builder.includeContents != null ? builder.includeContents : IncludeContents.DEFAULT;
        this.planning = builder.planning != null && builder.planning != false;
        this.maxSteps = Optional.ofNullable(builder.maxSteps);
        this.disallowTransferToParent = builder.disallowTransferToParent;
        this.disallowTransferToPeers = builder.disallowTransferToPeers;
        this.beforeModelCallback = Optional.ofNullable(builder.beforeModelCallback);
        this.afterModelCallback = Optional.ofNullable(builder.afterModelCallback);
        this.beforeToolCallback = Optional.ofNullable(builder.beforeToolCallback);
        this.afterToolCallback = Optional.ofNullable(builder.afterToolCallback);
        this.inputSchema = Optional.ofNullable(builder.inputSchema);
        this.outputSchema = Optional.ofNullable(builder.outputSchema);
        this.executor = Optional.ofNullable(builder.executor);
        this.outputKey = Optional.ofNullable(builder.outputKey);
        this.toolsUnion = builder.toolsUnion != null ? builder.toolsUnion : ImmutableList.of();
        this.toolsets = LlmAgent.extractToolsets(this.toolsUnion);
        this.codeExecutor = Optional.ofNullable(builder.codeExecutor);
        this.llmFlow = this.determineLlmFlow();
        Preconditions.checkArgument((!this.name().isEmpty() ? 1 : 0) != 0, (Object)"Agent name cannot be empty.");
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ImmutableList<BaseToolset> extractToolsets(List<Object> toolsUnion) {
        return (ImmutableList)toolsUnion.stream().filter(obj -> obj instanceof BaseToolset).map(obj -> (BaseToolset)obj).collect(ImmutableList.toImmutableList());
    }

    protected BaseLlmFlow determineLlmFlow() {
        if (this.disallowTransferToParent() && this.disallowTransferToPeers() && this.subAgents().isEmpty()) {
            return new SingleFlow(this.maxSteps);
        }
        return new AutoFlow(this.maxSteps);
    }

    private void maybeSaveOutputToState(Event event) {
        if (this.outputKey().isPresent() && event.finalResponse() && event.content().isPresent()) {
            Object output;
            String rawResult = ((List)event.content().flatMap(Content::parts).orElse(ImmutableList.of())).stream().filter(part -> !LlmAgent.isThought(part)).map(part -> part.text().orElse("")).collect(Collectors.joining());
            Optional<Schema> outputSchema = this.outputSchema();
            if (outputSchema.isPresent()) {
                try {
                    Map<String, Object> validatedMap = SchemaUtils.validateOutputSchema(rawResult, outputSchema.get());
                    output = validatedMap;
                }
                catch (JsonProcessingException e) {
                    logger.error("LlmAgent output for outputKey '{}' was not valid JSON, despite an outputSchema being present. Saving raw output to state.", (Object)this.outputKey().get(), (Object)e);
                    output = rawResult;
                }
                catch (IllegalArgumentException e) {
                    logger.error("LlmAgent output for outputKey '{}' did not match the outputSchema. Saving raw output to state.", (Object)this.outputKey().get(), (Object)e);
                    output = rawResult;
                }
            } else {
                output = rawResult;
            }
            event.actions().stateDelta().put(this.outputKey().get(), output);
        }
    }

    private static boolean isThought(Part part) {
        return part.thought().isPresent() && (Boolean)part.thought().get() != false;
    }

    @Override
    protected Flowable<Event> runAsyncImpl(InvocationContext invocationContext) {
        return this.llmFlow.run(invocationContext).concatMap(event -> {
            this.maybeSaveOutputToState((Event)event);
            if (invocationContext.shouldPauseInvocation((Event)event)) {
                return Flowable.just((Object)event).concatWith((Publisher)Flowable.empty());
            }
            return Flowable.just((Object)event);
        });
    }

    @Override
    protected Flowable<Event> runLiveImpl(InvocationContext invocationContext) {
        return this.llmFlow.runLive(invocationContext).doOnNext(this::maybeSaveOutputToState);
    }

    public Single<Map.Entry<String, Boolean>> canonicalInstruction(ReadonlyContext context) {
        Instruction instruction = this.instruction;
        if (instruction instanceof Instruction.Static) {
            Instruction.Static staticInstr = (Instruction.Static)instruction;
            return Single.just(Map.entry(staticInstr.instruction(), false));
        }
        instruction = this.instruction;
        if (instruction instanceof Instruction.Provider) {
            Instruction.Provider provider = (Instruction.Provider)instruction;
            return provider.getInstruction().apply(context).map(instr -> Map.entry(instr, true));
        }
        throw new IllegalStateException("Unknown Instruction subtype: " + String.valueOf(this.instruction.getClass()));
    }

    public Single<Map.Entry<String, Boolean>> canonicalGlobalInstruction(ReadonlyContext context) {
        Instruction instruction = this.globalInstruction;
        if (instruction instanceof Instruction.Static) {
            Instruction.Static staticInstr = (Instruction.Static)instruction;
            return Single.just(Map.entry(staticInstr.instruction(), false));
        }
        instruction = this.globalInstruction;
        if (instruction instanceof Instruction.Provider) {
            Instruction.Provider provider = (Instruction.Provider)instruction;
            return provider.getInstruction().apply(context).map(instr -> Map.entry(instr, true));
        }
        throw new IllegalStateException("Unknown Instruction subtype: " + String.valueOf(this.globalInstruction.getClass()));
    }

    public Flowable<BaseTool> canonicalTools(Optional<ReadonlyContext> context) {
        ArrayList<Object> toolFlowables = new ArrayList<Object>();
        for (Object toolOrToolset : this.toolsUnion) {
            if (toolOrToolset instanceof BaseTool) {
                BaseTool baseTool = (BaseTool)toolOrToolset;
                toolFlowables.add(Flowable.just((Object)baseTool));
                continue;
            }
            if (toolOrToolset instanceof BaseToolset) {
                BaseToolset baseToolset = (BaseToolset)toolOrToolset;
                toolFlowables.add(baseToolset.getTools(context.orElse(null)));
                continue;
            }
            throw new IllegalArgumentException("Object in tools list is not of a supported type: " + toolOrToolset.getClass().getName());
        }
        return Flowable.concat(toolFlowables);
    }

    public Flowable<BaseTool> canonicalTools() {
        return this.canonicalTools(Optional.empty());
    }

    public Flowable<BaseTool> canonicalTools(ReadonlyContext context) {
        return this.canonicalTools(Optional.ofNullable(context));
    }

    public Instruction instruction() {
        return this.instruction;
    }

    public Instruction globalInstruction() {
        return this.globalInstruction;
    }

    public Optional<Model> model() {
        return this.model;
    }

    public boolean planning() {
        return this.planning;
    }

    public Optional<Integer> maxSteps() {
        return this.maxSteps;
    }

    public Optional<GenerateContentConfig> generateContentConfig() {
        return this.generateContentConfig;
    }

    public Optional<BaseExampleProvider> exampleProvider() {
        return this.exampleProvider;
    }

    public IncludeContents includeContents() {
        return this.includeContents;
    }

    public List<BaseTool> tools() {
        return (List)this.canonicalTools().toList().blockingGet();
    }

    public List<Object> toolsUnion() {
        return this.toolsUnion;
    }

    public ImmutableList<BaseToolset> toolsets() {
        return this.toolsets;
    }

    public boolean disallowTransferToParent() {
        return this.disallowTransferToParent;
    }

    public boolean disallowTransferToPeers() {
        return this.disallowTransferToPeers;
    }

    public Optional<List<? extends Callbacks.BeforeModelCallback>> beforeModelCallback() {
        return this.beforeModelCallback;
    }

    public Optional<List<? extends Callbacks.AfterModelCallback>> afterModelCallback() {
        return this.afterModelCallback;
    }

    public Optional<List<? extends Callbacks.BeforeToolCallback>> beforeToolCallback() {
        return this.beforeToolCallback;
    }

    public Optional<List<? extends Callbacks.AfterToolCallback>> afterToolCallback() {
        return this.afterToolCallback;
    }

    public Optional<Schema> inputSchema() {
        return this.inputSchema;
    }

    public Optional<Schema> outputSchema() {
        return this.outputSchema;
    }

    public Optional<Executor> executor() {
        return this.executor;
    }

    public Optional<String> outputKey() {
        return this.outputKey;
    }

    @Nullable
    public BaseCodeExecutor codeExecutor() {
        return this.codeExecutor.orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model resolvedModel() {
        if (this.resolvedModel == null) {
            LlmAgent llmAgent = this;
            synchronized (llmAgent) {
                if (this.resolvedModel == null) {
                    this.resolvedModel = this.resolveModelInternal();
                }
            }
        }
        return this.resolvedModel;
    }

    private Model resolveModelInternal() {
        if (this.model.isPresent()) {
            Model currentModel = this.model.get();
            if (currentModel.model().isPresent()) {
                return currentModel;
            }
            if (currentModel.modelName().isPresent()) {
                String modelName = currentModel.modelName().get();
                BaseLlm resolvedLlm = LlmRegistry.getLlm(modelName);
                return Model.builder().modelName(modelName).model(resolvedLlm).build();
            }
        }
        for (BaseAgent current = this.parentAgent(); current != null; current = current.parentAgent()) {
            if (!(current instanceof LlmAgent)) continue;
            return ((LlmAgent)current).resolvedModel();
        }
        throw new IllegalStateException("No model found for agent " + this.name() + " or its ancestors.");
    }

    public static LlmAgent fromConfig(LlmAgentConfig config, String configAbsPath) throws ConfigAgentUtils.ConfigurationException {
        logger.debug("Creating LlmAgent from config: {}", (Object)config.name());
        Builder builder = LlmAgent.builder();
        ConfigAgentUtils.resolveAndSetCommonAgentFields(builder, config, configAbsPath);
        if (config.instruction() == null || config.instruction().trim().isEmpty()) {
            throw new ConfigAgentUtils.ConfigurationException("Agent instruction is required");
        }
        builder.instruction(config.instruction());
        if (config.model() != null && !config.model().trim().isEmpty()) {
            builder.model(config.model());
        }
        try {
            if (config.tools() != null) {
                builder.tools((List<?>)ToolResolver.resolveToolsAndToolsets(config.tools(), configAbsPath));
            }
        }
        catch (ConfigAgentUtils.ConfigurationException e) {
            throw new ConfigAgentUtils.ConfigurationException("Error resolving tools for agent " + config.name(), e);
        }
        if (config.disallowTransferToParent() != null) {
            builder.disallowTransferToParent(config.disallowTransferToParent());
        }
        if (config.disallowTransferToPeers() != null) {
            builder.disallowTransferToPeers(config.disallowTransferToPeers());
        }
        if (config.outputKey() != null && !config.outputKey().trim().isEmpty()) {
            builder.outputKey(config.outputKey());
        }
        if (config.includeContents() != null) {
            builder.includeContents(config.includeContents());
        }
        if (config.generateContentConfig() != null) {
            builder.generateContentConfig(config.generateContentConfig());
        }
        LlmAgent.setCallbacksFromConfig(config, builder);
        LlmAgent agent = builder.build();
        logger.info("Successfully created LlmAgent: {} with {} subagents", (Object)agent.name(), (Object)(agent.subAgents() != null ? agent.subAgents().size() : 0));
        return agent;
    }

    private static void setCallbacksFromConfig(LlmAgentConfig config, Builder builder) throws ConfigAgentUtils.ConfigurationException {
        ConfigAgentUtils.resolveAndSetCallback(config.beforeModelCallbacks(), Callbacks.BeforeModelCallbackBase.class, "before_model_callback", builder::beforeModelCallback);
        ConfigAgentUtils.resolveAndSetCallback(config.afterModelCallbacks(), Callbacks.AfterModelCallbackBase.class, "after_model_callback", builder::afterModelCallback);
        ConfigAgentUtils.resolveAndSetCallback(config.beforeToolCallbacks(), Callbacks.BeforeToolCallbackBase.class, "before_tool_callback", builder::beforeToolCallback);
        ConfigAgentUtils.resolveAndSetCallback(config.afterToolCallbacks(), Callbacks.AfterToolCallbackBase.class, "after_tool_callback", builder::afterToolCallback);
    }

    public static class Builder
    extends BaseAgent.Builder<Builder> {
        private Model model;
        private Instruction instruction;
        private Instruction globalInstruction;
        private ImmutableList<Object> toolsUnion;
        private GenerateContentConfig generateContentConfig;
        private BaseExampleProvider exampleProvider;
        private IncludeContents includeContents;
        private Boolean planning;
        private Integer maxSteps;
        private Boolean disallowTransferToParent;
        private Boolean disallowTransferToPeers;
        private ImmutableList<? extends Callbacks.BeforeModelCallback> beforeModelCallback;
        private ImmutableList<? extends Callbacks.AfterModelCallback> afterModelCallback;
        private ImmutableList<? extends Callbacks.BeforeToolCallback> beforeToolCallback;
        private ImmutableList<? extends Callbacks.AfterToolCallback> afterToolCallback;
        private Schema inputSchema;
        private Schema outputSchema;
        private Executor executor;
        private String outputKey;
        private BaseCodeExecutor codeExecutor;

        @CanIgnoreReturnValue
        public Builder model(String model) {
            this.model = Model.builder().modelName(model).build();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder model(BaseLlm model) {
            this.model = Model.builder().model(model).build();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder instruction(Instruction instruction) {
            this.instruction = instruction;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder instruction(String instruction) {
            this.instruction = instruction == null ? null : new Instruction.Static(instruction);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder globalInstruction(Instruction globalInstruction) {
            this.globalInstruction = globalInstruction;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder globalInstruction(String globalInstruction) {
            this.globalInstruction = globalInstruction == null ? null : new Instruction.Static(globalInstruction);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tools(List<?> tools) {
            this.toolsUnion = ImmutableList.copyOf(tools);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tools(Object ... tools) {
            this.toolsUnion = ImmutableList.copyOf((Object[])tools);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder generateContentConfig(GenerateContentConfig generateContentConfig) {
            this.generateContentConfig = generateContentConfig;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exampleProvider(BaseExampleProvider exampleProvider) {
            this.exampleProvider = exampleProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exampleProvider(List<Example> examples) {
            this.exampleProvider = query -> examples;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exampleProvider(Example ... examples) {
            this.exampleProvider = query -> ImmutableList.copyOf((Object[])examples);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder includeContents(IncludeContents includeContents) {
            this.includeContents = includeContents;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder planning(boolean planning) {
            this.planning = planning;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxSteps(int maxSteps) {
            this.maxSteps = maxSteps;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder disallowTransferToParent(boolean disallowTransferToParent) {
            this.disallowTransferToParent = disallowTransferToParent;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder disallowTransferToPeers(boolean disallowTransferToPeers) {
            this.disallowTransferToPeers = disallowTransferToPeers;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeModelCallback(Callbacks.BeforeModelCallback beforeModelCallback) {
            this.beforeModelCallback = ImmutableList.of((Object)beforeModelCallback);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeModelCallback(List<Callbacks.BeforeModelCallbackBase> beforeModelCallback) {
            if (beforeModelCallback == null) {
                this.beforeModelCallback = null;
            } else if (beforeModelCallback.isEmpty()) {
                this.beforeModelCallback = ImmutableList.of();
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Callbacks.BeforeModelCallbackBase callback : beforeModelCallback) {
                    if (callback instanceof Callbacks.BeforeModelCallback) {
                        Callbacks.BeforeModelCallback beforeModelCallbackInstance = (Callbacks.BeforeModelCallback)callback;
                        builder.add((Object)beforeModelCallbackInstance);
                        continue;
                    }
                    if (callback instanceof Callbacks.BeforeModelCallbackSync) {
                        Callbacks.BeforeModelCallbackSync beforeModelCallbackSyncInstance = (Callbacks.BeforeModelCallbackSync)callback;
                        builder.add((callbackContext, llmRequestBuilder) -> Maybe.fromOptional(beforeModelCallbackSyncInstance.call(callbackContext, llmRequestBuilder)));
                        continue;
                    }
                    logger.warn("Invalid beforeModelCallback callback type: %s. Ignoring this callback.", (Object)callback.getClass().getName());
                }
                this.beforeModelCallback = builder.build();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeModelCallbackSync(Callbacks.BeforeModelCallbackSync beforeModelCallbackSync) {
            this.beforeModelCallback = ImmutableList.of((callbackContext, llmRequestBuilder) -> Maybe.fromOptional(beforeModelCallbackSync.call(callbackContext, llmRequestBuilder)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterModelCallback(Callbacks.AfterModelCallback afterModelCallback) {
            this.afterModelCallback = ImmutableList.of((Object)afterModelCallback);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterModelCallback(List<Callbacks.AfterModelCallbackBase> afterModelCallback) {
            if (afterModelCallback == null) {
                this.afterModelCallback = null;
            } else if (afterModelCallback.isEmpty()) {
                this.afterModelCallback = ImmutableList.of();
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Callbacks.AfterModelCallbackBase callback : afterModelCallback) {
                    if (callback instanceof Callbacks.AfterModelCallback) {
                        Callbacks.AfterModelCallback afterModelCallbackInstance = (Callbacks.AfterModelCallback)callback;
                        builder.add((Object)afterModelCallbackInstance);
                        continue;
                    }
                    if (callback instanceof Callbacks.AfterModelCallbackSync) {
                        Callbacks.AfterModelCallbackSync afterModelCallbackSyncInstance = (Callbacks.AfterModelCallbackSync)callback;
                        builder.add((callbackContext, llmResponse) -> Maybe.fromOptional(afterModelCallbackSyncInstance.call(callbackContext, llmResponse)));
                        continue;
                    }
                    logger.warn("Invalid afterModelCallback callback type: %s. Ignoring this callback.", (Object)callback.getClass().getName());
                }
                this.afterModelCallback = builder.build();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterModelCallbackSync(Callbacks.AfterModelCallbackSync afterModelCallbackSync) {
            this.afterModelCallback = ImmutableList.of((callbackContext, llmResponse) -> Maybe.fromOptional(afterModelCallbackSync.call(callbackContext, llmResponse)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeAgentCallbackSync(Callbacks.BeforeAgentCallbackSync beforeAgentCallbackSync) {
            this.beforeAgentCallback = ImmutableList.of(callbackContext -> Maybe.fromOptional(beforeAgentCallbackSync.call(callbackContext)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterAgentCallbackSync(Callbacks.AfterAgentCallbackSync afterAgentCallbackSync) {
            this.afterAgentCallback = ImmutableList.of(callbackContext -> Maybe.fromOptional(afterAgentCallbackSync.call(callbackContext)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeToolCallback(Callbacks.BeforeToolCallback beforeToolCallback) {
            this.beforeToolCallback = ImmutableList.of((Object)beforeToolCallback);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeToolCallback(@Nullable List<? extends Callbacks.BeforeToolCallbackBase> beforeToolCallbacks) {
            if (beforeToolCallbacks == null) {
                this.beforeToolCallback = null;
            } else if (beforeToolCallbacks.isEmpty()) {
                this.beforeToolCallback = ImmutableList.of();
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Callbacks.BeforeToolCallbackBase beforeToolCallbackBase : beforeToolCallbacks) {
                    if (beforeToolCallbackBase instanceof Callbacks.BeforeToolCallback) {
                        Callbacks.BeforeToolCallback beforeToolCallbackInstance = (Callbacks.BeforeToolCallback)beforeToolCallbackBase;
                        builder.add((Object)beforeToolCallbackInstance);
                        continue;
                    }
                    if (beforeToolCallbackBase instanceof Callbacks.BeforeToolCallbackSync) {
                        Callbacks.BeforeToolCallbackSync beforeToolCallbackSyncInstance = (Callbacks.BeforeToolCallbackSync)beforeToolCallbackBase;
                        builder.add((invocationContext, baseTool, input, toolContext) -> Maybe.fromOptional(beforeToolCallbackSyncInstance.call(invocationContext, baseTool, input, toolContext)));
                        continue;
                    }
                    logger.warn("Invalid beforeToolCallback callback type: {}. Ignoring this callback.", (Object)beforeToolCallbackBase.getClass().getName());
                }
                this.beforeToolCallback = builder.build();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder beforeToolCallbackSync(Callbacks.BeforeToolCallbackSync beforeToolCallbackSync) {
            this.beforeToolCallback = ImmutableList.of((invocationContext, baseTool, input, toolContext) -> Maybe.fromOptional(beforeToolCallbackSync.call(invocationContext, baseTool, input, toolContext)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterToolCallback(Callbacks.AfterToolCallback afterToolCallback) {
            this.afterToolCallback = ImmutableList.of((Object)afterToolCallback);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterToolCallback(@Nullable List<Callbacks.AfterToolCallbackBase> afterToolCallbacks) {
            if (afterToolCallbacks == null) {
                this.afterToolCallback = null;
            } else if (afterToolCallbacks.isEmpty()) {
                this.afterToolCallback = ImmutableList.of();
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Callbacks.AfterToolCallbackBase callback : afterToolCallbacks) {
                    if (callback instanceof Callbacks.AfterToolCallback) {
                        Callbacks.AfterToolCallback afterToolCallbackInstance = (Callbacks.AfterToolCallback)callback;
                        builder.add((Object)afterToolCallbackInstance);
                        continue;
                    }
                    if (callback instanceof Callbacks.AfterToolCallbackSync) {
                        Callbacks.AfterToolCallbackSync afterToolCallbackSyncInstance = (Callbacks.AfterToolCallbackSync)callback;
                        builder.add((invocationContext, baseTool, input, toolContext, response) -> Maybe.fromOptional(afterToolCallbackSyncInstance.call(invocationContext, baseTool, input, toolContext, response)));
                        continue;
                    }
                    logger.warn("Invalid afterToolCallback callback type: {}. Ignoring this callback.", (Object)callback.getClass().getName());
                }
                this.afterToolCallback = builder.build();
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afterToolCallbackSync(Callbacks.AfterToolCallbackSync afterToolCallbackSync) {
            this.afterToolCallback = ImmutableList.of((invocationContext, baseTool, input, toolContext, response) -> Maybe.fromOptional(afterToolCallbackSync.call(invocationContext, baseTool, input, toolContext, response)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder inputSchema(Schema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder outputSchema(Schema outputSchema) {
            this.outputSchema = outputSchema;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder codeExecutor(BaseCodeExecutor codeExecutor) {
            this.codeExecutor = codeExecutor;
            return this;
        }

        protected void validate() {
            this.disallowTransferToParent = this.disallowTransferToParent != null && this.disallowTransferToParent != false;
            this.disallowTransferToPeers = this.disallowTransferToPeers != null && this.disallowTransferToPeers != false;
            if (this.outputSchema != null) {
                if (!this.disallowTransferToParent.booleanValue() || !this.disallowTransferToPeers.booleanValue()) {
                    System.err.println("Warning: Invalid config for agent " + this.name + ": outputSchema cannot co-exist with agent transfer configurations. Setting disallowTransferToParent=true and disallowTransferToPeers=true.");
                    this.disallowTransferToParent = true;
                    this.disallowTransferToPeers = true;
                }
                if (this.subAgents != null && !this.subAgents.isEmpty()) {
                    throw new IllegalArgumentException("Invalid config for agent " + this.name + ": if outputSchema is set, subAgents must be empty to disable agent transfer.");
                }
                if (this.toolsUnion != null && !this.toolsUnion.isEmpty()) {
                    throw new IllegalArgumentException("Invalid config for agent " + this.name + ": if outputSchema is set, tools must be empty.");
                }
            }
        }

        @Override
        public LlmAgent build() {
            this.validate();
            return new LlmAgent(this);
        }
    }

    public static enum IncludeContents {
        DEFAULT,
        NONE;

    }
}

