/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.ActiveStreamingTool;
import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.LiveRequestQueue;
import com.google.adk.agents.RunConfig;
import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.events.Event;
import com.google.adk.flows.llmflows.ResumabilityConfig;
import com.google.adk.memory.BaseMemoryService;
import com.google.adk.models.LlmCallsLimitExceededException;
import com.google.adk.plugins.PluginManager;
import com.google.adk.sessions.BaseSessionService;
import com.google.adk.sessions.Session;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.InlineMe;
import com.google.genai.types.Content;
import com.google.genai.types.FunctionCall;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class InvocationContext {
    private final BaseSessionService sessionService;
    private final BaseArtifactService artifactService;
    private final BaseMemoryService memoryService;
    private final PluginManager pluginManager;
    private final Optional<LiveRequestQueue> liveRequestQueue;
    private final Map<String, ActiveStreamingTool> activeStreamingTools = new ConcurrentHashMap<String, ActiveStreamingTool>();
    private final String invocationId;
    private final Session session;
    private final Optional<Content> userContent;
    private final RunConfig runConfig;
    private final ResumabilityConfig resumabilityConfig;
    private final InvocationCostManager invocationCostManager = new InvocationCostManager();
    private Optional<String> branch;
    private BaseAgent agent;
    private boolean endInvocation;

    private InvocationContext(Builder builder) {
        this.sessionService = builder.sessionService;
        this.artifactService = builder.artifactService;
        this.memoryService = builder.memoryService;
        this.pluginManager = builder.pluginManager;
        this.liveRequestQueue = builder.liveRequestQueue;
        this.branch = builder.branch;
        this.invocationId = builder.invocationId;
        this.agent = builder.agent;
        this.session = builder.session;
        this.userContent = builder.userContent;
        this.runConfig = builder.runConfig;
        this.endInvocation = builder.endInvocation;
        this.resumabilityConfig = builder.resumabilityConfig;
    }

    @Deprecated(forRemoval=true)
    public InvocationContext(BaseSessionService sessionService, BaseArtifactService artifactService, BaseMemoryService memoryService, PluginManager pluginManager, Optional<LiveRequestQueue> liveRequestQueue, Optional<String> branch, String invocationId, BaseAgent agent, Session session, Optional<Content> userContent, RunConfig runConfig, boolean endInvocation) {
        this(InvocationContext.builder().sessionService(sessionService).artifactService(artifactService).memoryService(memoryService).pluginManager(pluginManager).liveRequestQueue(liveRequestQueue).branch(branch).invocationId(invocationId).agent(agent).session(session).userContent(userContent).runConfig(runConfig).endInvocation(endInvocation));
    }

    @Deprecated(forRemoval=true)
    public InvocationContext(BaseSessionService sessionService, BaseArtifactService artifactService, BaseMemoryService memoryService, Optional<LiveRequestQueue> liveRequestQueue, Optional<String> branch, String invocationId, BaseAgent agent, Session session, Optional<Content> userContent, RunConfig runConfig, boolean endInvocation) {
        this(InvocationContext.builder().sessionService(sessionService).artifactService(artifactService).memoryService(memoryService).liveRequestQueue(liveRequestQueue).branch(branch).invocationId(invocationId).agent(agent).session(session).userContent(userContent).runConfig(runConfig).endInvocation(endInvocation));
    }

    @Deprecated(forRemoval=true)
    @InlineMe(replacement="InvocationContext.builder().sessionService(sessionService).artifactService(artifactService).invocationId(invocationId).agent(agent).session(session).userContent(Optional.ofNullable(userContent)).runConfig(runConfig).build()", imports={"com.google.adk.agents.InvocationContext", "java.util.Optional"})
    public static InvocationContext create(BaseSessionService sessionService, BaseArtifactService artifactService, String invocationId, BaseAgent agent, Session session, Content userContent, RunConfig runConfig) {
        return InvocationContext.builder().sessionService(sessionService).artifactService(artifactService).invocationId(invocationId).agent(agent).session(session).userContent(Optional.ofNullable(userContent)).runConfig(runConfig).build();
    }

    @Deprecated(forRemoval=true)
    public static InvocationContext create(BaseSessionService sessionService, BaseArtifactService artifactService, BaseAgent agent, Session session, LiveRequestQueue liveRequestQueue, RunConfig runConfig) {
        return InvocationContext.builder().sessionService(sessionService).artifactService(artifactService).agent(agent).session(session).liveRequestQueue(Optional.ofNullable(liveRequestQueue)).runConfig(runConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static InvocationContext copyOf(InvocationContext other) {
        InvocationContext newContext = InvocationContext.builder().sessionService(other.sessionService).artifactService(other.artifactService).memoryService(other.memoryService).pluginManager(other.pluginManager).liveRequestQueue(other.liveRequestQueue).branch(other.branch).invocationId(other.invocationId).agent(other.agent).session(other.session).userContent(other.userContent).runConfig(other.runConfig).endInvocation(other.endInvocation).resumabilityConfig(other.resumabilityConfig).build();
        newContext.activeStreamingTools.putAll(other.activeStreamingTools);
        return newContext;
    }

    public BaseSessionService sessionService() {
        return this.sessionService;
    }

    public BaseArtifactService artifactService() {
        return this.artifactService;
    }

    public BaseMemoryService memoryService() {
        return this.memoryService;
    }

    public PluginManager pluginManager() {
        return this.pluginManager;
    }

    public Map<String, ActiveStreamingTool> activeStreamingTools() {
        return this.activeStreamingTools;
    }

    public Optional<LiveRequestQueue> liveRequestQueue() {
        return this.liveRequestQueue;
    }

    public String invocationId() {
        return this.invocationId;
    }

    public void branch(@Nullable String branch) {
        this.branch = Optional.ofNullable(branch);
    }

    public Optional<String> branch() {
        return this.branch;
    }

    public BaseAgent agent() {
        return this.agent;
    }

    public void agent(BaseAgent agent) {
        this.agent = agent;
    }

    public Session session() {
        return this.session;
    }

    public Optional<Content> userContent() {
        return this.userContent;
    }

    public RunConfig runConfig() {
        return this.runConfig;
    }

    public boolean endInvocation() {
        return this.endInvocation;
    }

    public void setEndInvocation(boolean endInvocation) {
        this.endInvocation = endInvocation;
    }

    public String appName() {
        return this.session.appName();
    }

    public String userId() {
        return this.session.userId();
    }

    public static String newInvocationContextId() {
        return "e-" + String.valueOf(UUID.randomUUID());
    }

    public void incrementLlmCallsCount() throws LlmCallsLimitExceededException {
        this.invocationCostManager.incrementAndEnforceLlmCallsLimit(this.runConfig);
    }

    public boolean isResumable() {
        return this.resumabilityConfig.isResumable();
    }

    public boolean shouldPauseInvocation(Event event) {
        if (!this.isResumable()) {
            return false;
        }
        Set<String> longRunningToolIds = event.longRunningToolIds().orElse((Set<String>)ImmutableSet.of());
        if (longRunningToolIds.isEmpty()) {
            return false;
        }
        return event.functionCalls().stream().map(FunctionCall::id).flatMap(Optional::stream).anyMatch(functionCallId -> longRunningToolIds.contains(functionCallId));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvocationContext)) {
            return false;
        }
        InvocationContext that = (InvocationContext)o;
        return this.endInvocation == that.endInvocation && Objects.equals(this.sessionService, that.sessionService) && Objects.equals(this.artifactService, that.artifactService) && Objects.equals(this.memoryService, that.memoryService) && Objects.equals(this.pluginManager, that.pluginManager) && Objects.equals(this.liveRequestQueue, that.liveRequestQueue) && Objects.equals(this.activeStreamingTools, that.activeStreamingTools) && Objects.equals(this.branch, that.branch) && Objects.equals(this.invocationId, that.invocationId) && Objects.equals(this.agent, that.agent) && Objects.equals(this.session, that.session) && Objects.equals(this.userContent, that.userContent) && Objects.equals(this.runConfig, that.runConfig) && Objects.equals(this.resumabilityConfig, that.resumabilityConfig);
    }

    public int hashCode() {
        return Objects.hash(this.sessionService, this.artifactService, this.memoryService, this.pluginManager, this.liveRequestQueue, this.activeStreamingTools, this.branch, this.invocationId, this.agent, this.session, this.userContent, this.runConfig, this.endInvocation, this.resumabilityConfig);
    }

    private static class InvocationCostManager {
        private int numberOfLlmCalls = 0;

        private InvocationCostManager() {
        }

        void incrementAndEnforceLlmCallsLimit(RunConfig runConfig) throws LlmCallsLimitExceededException {
            ++this.numberOfLlmCalls;
            if (runConfig != null && runConfig.maxLlmCalls() > 0 && this.numberOfLlmCalls > runConfig.maxLlmCalls()) {
                throw new LlmCallsLimitExceededException("Max number of llm calls limit of " + runConfig.maxLlmCalls() + " exceeded");
            }
        }
    }

    public static class Builder {
        private BaseSessionService sessionService;
        private BaseArtifactService artifactService;
        private BaseMemoryService memoryService;
        private PluginManager pluginManager = new PluginManager();
        private Optional<LiveRequestQueue> liveRequestQueue = Optional.empty();
        private Optional<String> branch = Optional.empty();
        private String invocationId = InvocationContext.newInvocationContextId();
        private BaseAgent agent;
        private Session session;
        private Optional<Content> userContent = Optional.empty();
        private RunConfig runConfig = RunConfig.builder().build();
        private boolean endInvocation = false;
        private ResumabilityConfig resumabilityConfig = new ResumabilityConfig();

        @CanIgnoreReturnValue
        public Builder sessionService(BaseSessionService sessionService) {
            this.sessionService = sessionService;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder artifactService(BaseArtifactService artifactService) {
            this.artifactService = artifactService;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder memoryService(BaseMemoryService memoryService) {
            this.memoryService = memoryService;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder pluginManager(PluginManager pluginManager) {
            this.pluginManager = pluginManager;
            return this;
        }

        @Deprecated(forRemoval=true)
        @CanIgnoreReturnValue
        public Builder liveRequestQueue(Optional<LiveRequestQueue> liveRequestQueue) {
            this.liveRequestQueue = liveRequestQueue;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder liveRequestQueue(LiveRequestQueue liveRequestQueue) {
            this.liveRequestQueue = Optional.of(liveRequestQueue);
            return this;
        }

        @Deprecated(forRemoval=true)
        @CanIgnoreReturnValue
        public Builder branch(Optional<String> branch) {
            this.branch = branch;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder branch(String branch) {
            this.branch = Optional.of(branch);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder agent(BaseAgent agent) {
            this.agent = agent;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder session(Session session) {
            this.session = session;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder userContent(Optional<Content> userContent) {
            this.userContent = userContent;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder userContent(Content userContent) {
            this.userContent = Optional.of(userContent);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder runConfig(RunConfig runConfig) {
            this.runConfig = runConfig;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder endInvocation(boolean endInvocation) {
            this.endInvocation = endInvocation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder resumabilityConfig(ResumabilityConfig resumabilityConfig) {
            this.resumabilityConfig = resumabilityConfig;
            return this;
        }

        public InvocationContext build() {
            return new InvocationContext(this);
        }
    }
}

