/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.ReadonlyContext;
import com.google.adk.artifacts.ListArtifactsResponse;
import com.google.adk.events.EventActions;
import com.google.adk.sessions.State;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Optional;

public class CallbackContext
extends ReadonlyContext {
    protected EventActions eventActions;
    private final State state;

    public CallbackContext(InvocationContext invocationContext, EventActions eventActions) {
        super(invocationContext);
        this.eventActions = eventActions != null ? eventActions : EventActions.builder().build();
        this.state = new State(invocationContext.session().state(), this.eventActions.stateDelta());
    }

    public State state() {
        return this.state;
    }

    public EventActions eventActions() {
        return this.eventActions;
    }

    public Single<List<String>> listArtifacts() {
        if (this.invocationContext.artifactService() == null) {
            throw new IllegalStateException("Artifact service is not initialized.");
        }
        return this.invocationContext.artifactService().listArtifactKeys(this.invocationContext.session().appName(), this.invocationContext.session().userId(), this.invocationContext.session().id()).map(ListArtifactsResponse::filenames);
    }

    public Maybe<Part> loadArtifact(String filename, Optional<Integer> version) {
        if (this.invocationContext.artifactService() == null) {
            throw new IllegalStateException("Artifact service is not initialized.");
        }
        return this.invocationContext.artifactService().loadArtifact(this.invocationContext.appName(), this.invocationContext.userId(), this.invocationContext.session().id(), filename, version);
    }

    public Completable saveArtifact(String filename, Part artifact) {
        if (this.invocationContext.artifactService() == null) {
            throw new IllegalStateException("Artifact service is not initialized.");
        }
        return this.invocationContext.artifactService().saveArtifact(this.invocationContext.appName(), this.invocationContext.userId(), this.invocationContext.session().id(), filename, artifact).doOnSuccess(unusedVersion -> this.eventActions.artifactDelta().put(filename, artifact)).ignoreElement();
    }
}

