/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.Telemetry;
import com.google.adk.agents.BaseAgentConfig;
import com.google.adk.agents.CallbackContext;
import com.google.adk.agents.CallbackUtil;
import com.google.adk.agents.Callbacks;
import com.google.adk.agents.InvocationContext;
import com.google.adk.events.Event;
import com.google.adk.plugins.PluginManager;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import com.google.genai.types.Content;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;

public abstract class BaseAgent {
    private final String name;
    private final String description;
    private BaseAgent parentAgent;
    private final List<? extends BaseAgent> subAgents;
    private final Optional<List<? extends Callbacks.BeforeAgentCallback>> beforeAgentCallback;
    private final Optional<List<? extends Callbacks.AfterAgentCallback>> afterAgentCallback;

    public BaseAgent(String name, String description, List<? extends BaseAgent> subAgents, List<? extends Callbacks.BeforeAgentCallback> beforeAgentCallback, List<? extends Callbacks.AfterAgentCallback> afterAgentCallback) {
        this.name = name;
        this.description = description;
        this.parentAgent = null;
        this.subAgents = subAgents != null ? subAgents : ImmutableList.of();
        this.beforeAgentCallback = Optional.ofNullable(beforeAgentCallback);
        this.afterAgentCallback = Optional.ofNullable(afterAgentCallback);
        for (BaseAgent baseAgent : this.subAgents) {
            baseAgent.parentAgent(this);
        }
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public BaseAgent parentAgent() {
        return this.parentAgent;
    }

    protected void parentAgent(BaseAgent parentAgent) {
        this.parentAgent = parentAgent;
    }

    public BaseAgent rootAgent() {
        BaseAgent agent = this;
        while (agent.parentAgent() != null) {
            agent = agent.parentAgent();
        }
        return agent;
    }

    public BaseAgent findAgent(String name) {
        if (this.name().equals(name)) {
            return this;
        }
        return this.findSubAgent(name);
    }

    public @Nullable BaseAgent findSubAgent(String name) {
        for (BaseAgent baseAgent : this.subAgents) {
            if (baseAgent.name().equals(name)) {
                return baseAgent;
            }
            BaseAgent result = baseAgent.findSubAgent(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<? extends BaseAgent> subAgents() {
        return this.subAgents;
    }

    public Optional<List<? extends Callbacks.BeforeAgentCallback>> beforeAgentCallback() {
        return this.beforeAgentCallback;
    }

    public Optional<List<? extends Callbacks.AfterAgentCallback>> afterAgentCallback() {
        return this.afterAgentCallback;
    }

    private InvocationContext createInvocationContext(InvocationContext parentContext) {
        InvocationContext invocationContext = InvocationContext.copyOf(parentContext);
        invocationContext.agent(this);
        if (parentContext.branch().filter(s -> !s.isEmpty()).isPresent()) {
            invocationContext.branch(parentContext.branch().get() + "." + this.name());
        }
        return invocationContext;
    }

    public Flowable<Event> runAsync(InvocationContext parentContext) {
        Tracer tracer = Telemetry.getTracer();
        return Flowable.defer(() -> {
            Span span = tracer.spanBuilder("agent_run [" + this.name() + "]").setParent(Context.current()).startSpan();
            Context spanContext = Context.current().with((ImplicitContextKeyed)span);
            InvocationContext invocationContext = this.createInvocationContext(parentContext);
            return Telemetry.traceFlowable(spanContext, span, () -> this.callCallback((List<Function<CallbackContext, Maybe<Content>>>)this.beforeCallbacksToFunctions(invocationContext.pluginManager(), this.beforeAgentCallback.orElse((List<? extends Callbacks.BeforeAgentCallback>)ImmutableList.of())), invocationContext).flatMapPublisher(beforeEventOpt -> {
                if (invocationContext.endInvocation()) {
                    return Flowable.fromOptional((Optional)beforeEventOpt);
                }
                Flowable beforeEvents = Flowable.fromOptional((Optional)beforeEventOpt);
                Flowable mainEvents = Flowable.defer(() -> this.runAsyncImpl(invocationContext));
                Flowable afterEvents = Flowable.defer(() -> this.callCallback((List<Function<CallbackContext, Maybe<Content>>>)this.afterCallbacksToFunctions(invocationContext.pluginManager(), this.afterAgentCallback.orElse((List<? extends Callbacks.AfterAgentCallback>)ImmutableList.of())), invocationContext).flatMapPublisher(Flowable::fromOptional));
                return Flowable.concat((Publisher)beforeEvents, (Publisher)mainEvents, (Publisher)afterEvents);
            }));
        });
    }

    private ImmutableList<Function<CallbackContext, Maybe<Content>>> beforeCallbacksToFunctions(PluginManager pluginManager, List<? extends Callbacks.BeforeAgentCallback> callbacks) {
        return (ImmutableList)Stream.concat(Stream.of(ctx -> pluginManager.runBeforeAgentCallback(this, (CallbackContext)ctx)), callbacks.stream().map(callback -> callback::call)).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<Function<CallbackContext, Maybe<Content>>> afterCallbacksToFunctions(PluginManager pluginManager, List<? extends Callbacks.AfterAgentCallback> callbacks) {
        return (ImmutableList)Stream.concat(Stream.of(ctx -> pluginManager.runAfterAgentCallback(this, (CallbackContext)ctx)), callbacks.stream().map(callback -> callback::call)).collect(ImmutableList.toImmutableList());
    }

    private Single<Optional<Event>> callCallback(List<Function<CallbackContext, Maybe<Content>>> agentCallbacks, InvocationContext invocationContext) {
        if (agentCallbacks == null || agentCallbacks.isEmpty()) {
            return Single.just(Optional.empty());
        }
        CallbackContext callbackContext = new CallbackContext(invocationContext, null);
        return Flowable.fromIterable(agentCallbacks).concatMap(callback -> {
            Maybe maybeContent = (Maybe)callback.apply(callbackContext);
            return maybeContent.map(content -> {
                Event.Builder eventBuilder = Event.builder().id(Event.generateEventId()).invocationId(invocationContext.invocationId()).author(this.name()).branch(invocationContext.branch()).actions(callbackContext.eventActions());
                eventBuilder.content(Optional.of(content));
                invocationContext.setEndInvocation(true);
                return Optional.of(eventBuilder.build());
            }).toFlowable();
        }).firstElement().switchIfEmpty((SingleSource)Single.defer(() -> {
            if (callbackContext.state().hasDelta()) {
                Event.Builder eventBuilder = Event.builder().id(Event.generateEventId()).invocationId(invocationContext.invocationId()).author(this.name()).branch(invocationContext.branch()).actions(callbackContext.eventActions());
                return Single.just(Optional.of(eventBuilder.build()));
            }
            return Single.just(Optional.empty());
        }));
    }

    public Flowable<Event> runLive(InvocationContext parentContext) {
        Tracer tracer = Telemetry.getTracer();
        return Flowable.defer(() -> {
            Span span = tracer.spanBuilder("agent_run [" + this.name() + "]").setParent(Context.current()).startSpan();
            Context spanContext = Context.current().with((ImplicitContextKeyed)span);
            InvocationContext invocationContext = this.createInvocationContext(parentContext);
            return Telemetry.traceFlowable(spanContext, span, () -> this.runLiveImpl(invocationContext));
        });
    }

    protected abstract Flowable<Event> runAsyncImpl(InvocationContext var1);

    protected abstract Flowable<Event> runLiveImpl(InvocationContext var1);

    @DoNotCall(value="Always throws java.lang.UnsupportedOperationException")
    public static BaseAgent fromConfig(BaseAgentConfig config, String configAbsPath) {
        throw new UnsupportedOperationException("BaseAgent is abstract. Override fromConfig in concrete subclasses.");
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected String name;
        protected String description;
        protected ImmutableList<BaseAgent> subAgents;
        protected ImmutableList<Callbacks.BeforeAgentCallback> beforeAgentCallback;
        protected ImmutableList<Callbacks.AfterAgentCallback> afterAgentCallback;

        protected B self() {
            return (B)this;
        }

        @CanIgnoreReturnValue
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @CanIgnoreReturnValue
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @CanIgnoreReturnValue
        public B subAgents(List<? extends BaseAgent> subAgents) {
            this.subAgents = ImmutableList.copyOf(subAgents);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B subAgents(BaseAgent ... subAgents) {
            this.subAgents = ImmutableList.copyOf((Object[])subAgents);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B beforeAgentCallback(Callbacks.BeforeAgentCallback beforeAgentCallback) {
            this.beforeAgentCallback = ImmutableList.of((Object)beforeAgentCallback);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B beforeAgentCallback(List<Callbacks.BeforeAgentCallbackBase> beforeAgentCallback) {
            this.beforeAgentCallback = CallbackUtil.getBeforeAgentCallbacks(beforeAgentCallback);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B afterAgentCallback(Callbacks.AfterAgentCallback afterAgentCallback) {
            this.afterAgentCallback = ImmutableList.of((Object)afterAgentCallback);
            return this.self();
        }

        @CanIgnoreReturnValue
        public B afterAgentCallback(List<Callbacks.AfterAgentCallbackBase> afterAgentCallback) {
            this.afterAgentCallback = CallbackUtil.getAfterAgentCallbacks(afterAgentCallback);
            return this.self();
        }

        public abstract BaseAgent build();
    }
}

