/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.agents;

import com.google.adk.agents.RunConfig;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.AudioTranscriptionConfig;
import com.google.genai.types.Modality;
import com.google.genai.types.SpeechConfig;
import javax.annotation.Nullable;

final class AutoValue_RunConfig
extends RunConfig {
    @Nullable
    private final SpeechConfig speechConfig;
    private final ImmutableList<Modality> responseModalities;
    private final boolean saveInputBlobsAsArtifacts;
    private final RunConfig.StreamingMode streamingMode;
    private final RunConfig.ToolExecutionMode toolExecutionMode;
    @Nullable
    private final AudioTranscriptionConfig outputAudioTranscription;
    @Nullable
    private final AudioTranscriptionConfig inputAudioTranscription;
    private final int maxLlmCalls;

    private AutoValue_RunConfig(@Nullable SpeechConfig speechConfig, ImmutableList<Modality> responseModalities, boolean saveInputBlobsAsArtifacts, RunConfig.StreamingMode streamingMode, RunConfig.ToolExecutionMode toolExecutionMode, @Nullable AudioTranscriptionConfig outputAudioTranscription, @Nullable AudioTranscriptionConfig inputAudioTranscription, int maxLlmCalls) {
        this.speechConfig = speechConfig;
        this.responseModalities = responseModalities;
        this.saveInputBlobsAsArtifacts = saveInputBlobsAsArtifacts;
        this.streamingMode = streamingMode;
        this.toolExecutionMode = toolExecutionMode;
        this.outputAudioTranscription = outputAudioTranscription;
        this.inputAudioTranscription = inputAudioTranscription;
        this.maxLlmCalls = maxLlmCalls;
    }

    @Override
    @Nullable
    public SpeechConfig speechConfig() {
        return this.speechConfig;
    }

    @Override
    public ImmutableList<Modality> responseModalities() {
        return this.responseModalities;
    }

    @Override
    public boolean saveInputBlobsAsArtifacts() {
        return this.saveInputBlobsAsArtifacts;
    }

    @Override
    public RunConfig.StreamingMode streamingMode() {
        return this.streamingMode;
    }

    @Override
    public RunConfig.ToolExecutionMode toolExecutionMode() {
        return this.toolExecutionMode;
    }

    @Override
    @Nullable
    public AudioTranscriptionConfig outputAudioTranscription() {
        return this.outputAudioTranscription;
    }

    @Override
    @Nullable
    public AudioTranscriptionConfig inputAudioTranscription() {
        return this.inputAudioTranscription;
    }

    @Override
    public int maxLlmCalls() {
        return this.maxLlmCalls;
    }

    public String toString() {
        return "RunConfig{speechConfig=" + String.valueOf(this.speechConfig) + ", responseModalities=" + String.valueOf(this.responseModalities) + ", saveInputBlobsAsArtifacts=" + this.saveInputBlobsAsArtifacts + ", streamingMode=" + String.valueOf((Object)this.streamingMode) + ", toolExecutionMode=" + String.valueOf((Object)this.toolExecutionMode) + ", outputAudioTranscription=" + String.valueOf(this.outputAudioTranscription) + ", inputAudioTranscription=" + String.valueOf(this.inputAudioTranscription) + ", maxLlmCalls=" + this.maxLlmCalls + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RunConfig) {
            RunConfig that = (RunConfig)o;
            return (this.speechConfig == null ? that.speechConfig() == null : this.speechConfig.equals(that.speechConfig())) && this.responseModalities.equals(that.responseModalities()) && this.saveInputBlobsAsArtifacts == that.saveInputBlobsAsArtifacts() && this.streamingMode.equals((Object)that.streamingMode()) && this.toolExecutionMode.equals((Object)that.toolExecutionMode()) && (this.outputAudioTranscription == null ? that.outputAudioTranscription() == null : this.outputAudioTranscription.equals(that.outputAudioTranscription())) && (this.inputAudioTranscription == null ? that.inputAudioTranscription() == null : this.inputAudioTranscription.equals(that.inputAudioTranscription())) && this.maxLlmCalls == that.maxLlmCalls();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.speechConfig == null ? 0 : this.speechConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.responseModalities.hashCode();
        h$ *= 1000003;
        h$ ^= this.saveInputBlobsAsArtifacts ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.streamingMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.toolExecutionMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputAudioTranscription == null ? 0 : this.outputAudioTranscription.hashCode();
        h$ *= 1000003;
        h$ ^= this.inputAudioTranscription == null ? 0 : this.inputAudioTranscription.hashCode();
        h$ *= 1000003;
        return h$ ^= this.maxLlmCalls;
    }

    @Override
    public RunConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends RunConfig.Builder {
        private SpeechConfig speechConfig;
        private ImmutableList<Modality> responseModalities;
        private boolean saveInputBlobsAsArtifacts;
        private RunConfig.StreamingMode streamingMode;
        private RunConfig.ToolExecutionMode toolExecutionMode;
        private AudioTranscriptionConfig outputAudioTranscription;
        private AudioTranscriptionConfig inputAudioTranscription;
        private int maxLlmCalls;
        private byte set$0;

        Builder() {
        }

        Builder(RunConfig source) {
            this.speechConfig = source.speechConfig();
            this.responseModalities = source.responseModalities();
            this.saveInputBlobsAsArtifacts = source.saveInputBlobsAsArtifacts();
            this.streamingMode = source.streamingMode();
            this.toolExecutionMode = source.toolExecutionMode();
            this.outputAudioTranscription = source.outputAudioTranscription();
            this.inputAudioTranscription = source.inputAudioTranscription();
            this.maxLlmCalls = source.maxLlmCalls();
            this.set$0 = (byte)3;
        }

        @Override
        public RunConfig.Builder setSpeechConfig(@Nullable SpeechConfig speechConfig) {
            this.speechConfig = speechConfig;
            return this;
        }

        @Override
        public RunConfig.Builder setResponseModalities(Iterable<Modality> responseModalities) {
            this.responseModalities = ImmutableList.copyOf(responseModalities);
            return this;
        }

        @Override
        public RunConfig.Builder setSaveInputBlobsAsArtifacts(boolean saveInputBlobsAsArtifacts) {
            this.saveInputBlobsAsArtifacts = saveInputBlobsAsArtifacts;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public RunConfig.Builder setStreamingMode(RunConfig.StreamingMode streamingMode) {
            if (streamingMode == null) {
                throw new NullPointerException("Null streamingMode");
            }
            this.streamingMode = streamingMode;
            return this;
        }

        @Override
        public RunConfig.Builder setToolExecutionMode(RunConfig.ToolExecutionMode toolExecutionMode) {
            if (toolExecutionMode == null) {
                throw new NullPointerException("Null toolExecutionMode");
            }
            this.toolExecutionMode = toolExecutionMode;
            return this;
        }

        @Override
        public RunConfig.Builder setOutputAudioTranscription(@Nullable AudioTranscriptionConfig outputAudioTranscription) {
            this.outputAudioTranscription = outputAudioTranscription;
            return this;
        }

        @Override
        public RunConfig.Builder setInputAudioTranscription(@Nullable AudioTranscriptionConfig inputAudioTranscription) {
            this.inputAudioTranscription = inputAudioTranscription;
            return this;
        }

        @Override
        public RunConfig.Builder setMaxLlmCalls(int maxLlmCalls) {
            this.maxLlmCalls = maxLlmCalls;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        RunConfig autoBuild() {
            if (this.set$0 != 3 || this.responseModalities == null || this.streamingMode == null || this.toolExecutionMode == null) {
                StringBuilder missing = new StringBuilder();
                if (this.responseModalities == null) {
                    missing.append(" responseModalities");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" saveInputBlobsAsArtifacts");
                }
                if (this.streamingMode == null) {
                    missing.append(" streamingMode");
                }
                if (this.toolExecutionMode == null) {
                    missing.append(" toolExecutionMode");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" maxLlmCalls");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_RunConfig(this.speechConfig, this.responseModalities, this.saveInputBlobsAsArtifacts, this.streamingMode, this.toolExecutionMode, this.outputAudioTranscription, this.inputAudioTranscription, this.maxLlmCalls);
        }
    }
}

