/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Optional;

public abstract class JsonBaseModel {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    protected static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ObjectMapper getMapper() {
        return objectMapper;
    }

    public String toJson() {
        return JsonBaseModel.toJsonString(this);
    }

    protected static JsonNode toJsonNode(Object object) {
        return objectMapper.valueToTree(object);
    }

    public static <T extends JsonBaseModel> T fromJsonString(String jsonString, Class<T> clazz) {
        try {
            return (T)((JsonBaseModel)objectMapper.readValue(jsonString, clazz));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends JsonBaseModel> T fromJsonNode(JsonNode jsonNode, Class<T> clazz) {
        try {
            return (T)((JsonBaseModel)objectMapper.treeToValue((TreeNode)jsonNode, clazz));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS).setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configOverride(Optional.class).setInclude(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_ABSENT, (JsonInclude.Include)JsonInclude.Include.NON_ABSENT));
    }
}

