package com.google.adk.examples;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.Content;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Example extends Example {

  private final Content input;

  private final List<Content> output;

  private AutoValue_Example(
      Content input,
      List<Content> output) {
    this.input = input;
    this.output = output;
  }

  @JsonProperty("input")
  @Override
  public Content input() {
    return input;
  }

  @JsonProperty("output")
  @Override
  public List<Content> output() {
    return output;
  }

  @Override
  public String toString() {
    return "Example{"
        + "input=" + input + ", "
        + "output=" + output
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Example) {
      Example that = (Example) o;
      return this.input.equals(that.input())
          && this.output.equals(that.output());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= input.hashCode();
    h$ *= 1000003;
    h$ ^= output.hashCode();
    return h$;
  }

  @Override
  public Example.Builder toBuilder() {
    return new AutoValue_Example.Builder(this);
  }

  static final class Builder extends Example.Builder {
    private Content input;
    private List<Content> output;
    Builder() {
    }
    Builder(Example source) {
      this.input = source.input();
      this.output = source.output();
    }
    @Override
    public Example.Builder input(Content input) {
      if (input == null) {
        throw new NullPointerException("Null input");
      }
      this.input = input;
      return this;
    }
    @Override
    public Example.Builder output(List<Content> output) {
      if (output == null) {
        throw new NullPointerException("Null output");
      }
      this.output = output;
      return this;
    }
    @Override
    public Example build() {
      if (this.input == null
          || this.output == null) {
        StringBuilder missing = new StringBuilder();
        if (this.input == null) {
          missing.append(" input");
        }
        if (this.output == null) {
          missing.append(" output");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Example(
          this.input,
          this.output);
    }
  }

}
