package com.google.adk.codeexecutors;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CodeExecutionUtils_CodeExecutionResult extends CodeExecutionUtils.CodeExecutionResult {

  private final String stdout;

  private final String stderr;

  private final ImmutableList<CodeExecutionUtils.File> outputFiles;

  private AutoValue_CodeExecutionUtils_CodeExecutionResult(
      String stdout,
      String stderr,
      ImmutableList<CodeExecutionUtils.File> outputFiles) {
    this.stdout = stdout;
    this.stderr = stderr;
    this.outputFiles = outputFiles;
  }

  @Override
  public String stdout() {
    return stdout;
  }

  @Override
  public String stderr() {
    return stderr;
  }

  @Override
  public ImmutableList<CodeExecutionUtils.File> outputFiles() {
    return outputFiles;
  }

  @Override
  public String toString() {
    return "CodeExecutionResult{"
        + "stdout=" + stdout + ", "
        + "stderr=" + stderr + ", "
        + "outputFiles=" + outputFiles
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CodeExecutionUtils.CodeExecutionResult) {
      CodeExecutionUtils.CodeExecutionResult that = (CodeExecutionUtils.CodeExecutionResult) o;
      return this.stdout.equals(that.stdout())
          && this.stderr.equals(that.stderr())
          && this.outputFiles.equals(that.outputFiles());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= stdout.hashCode();
    h$ *= 1000003;
    h$ ^= stderr.hashCode();
    h$ *= 1000003;
    h$ ^= outputFiles.hashCode();
    return h$;
  }

  static final class Builder extends CodeExecutionUtils.CodeExecutionResult.Builder {
    private String stdout;
    private String stderr;
    private ImmutableList<CodeExecutionUtils.File> outputFiles;
    Builder() {
    }
    @Override
    public CodeExecutionUtils.CodeExecutionResult.Builder stdout(String stdout) {
      if (stdout == null) {
        throw new NullPointerException("Null stdout");
      }
      this.stdout = stdout;
      return this;
    }
    @Override
    public CodeExecutionUtils.CodeExecutionResult.Builder stderr(String stderr) {
      if (stderr == null) {
        throw new NullPointerException("Null stderr");
      }
      this.stderr = stderr;
      return this;
    }
    @Override
    public CodeExecutionUtils.CodeExecutionResult.Builder outputFiles(List<CodeExecutionUtils.File> outputFiles) {
      this.outputFiles = ImmutableList.copyOf(outputFiles);
      return this;
    }
    @Override
    public CodeExecutionUtils.CodeExecutionResult build() {
      if (this.stdout == null
          || this.stderr == null
          || this.outputFiles == null) {
        StringBuilder missing = new StringBuilder();
        if (this.stdout == null) {
          missing.append(" stdout");
        }
        if (this.stderr == null) {
          missing.append(" stderr");
        }
        if (this.outputFiles == null) {
          missing.append(" outputFiles");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CodeExecutionUtils_CodeExecutionResult(
          this.stdout,
          this.stderr,
          this.outputFiles);
    }
  }

}
