/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.tools.mcp;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.modelcontextprotocol.util.Assert;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;

public class StreamableHttpServerParameters {
    private final String url;
    private final Map<String, String> headers;
    private final Duration timeout;
    private final Duration sseReadTimeout;
    private final boolean terminateOnClose;

    public StreamableHttpServerParameters(String url, Map<String, String> headers, @Nullable Duration timeout, @Nullable Duration sseReadTimeout, @Nullable Boolean terminateOnClose) {
        Assert.hasText((String)url, (String)"url must not be empty");
        this.url = url;
        this.headers = headers == null ? Collections.emptyMap() : headers;
        this.timeout = timeout == null ? Duration.ofSeconds(30L) : timeout;
        this.sseReadTimeout = sseReadTimeout == null ? Duration.ofMinutes(5L) : sseReadTimeout;
        this.terminateOnClose = terminateOnClose == null || terminateOnClose != false;
    }

    public String url() {
        return this.url;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public Duration sseReadTimeout() {
        return this.sseReadTimeout;
    }

    public boolean terminateOnClose() {
        return this.terminateOnClose;
    }

    public static Builder builder(String url) {
        return new Builder(url);
    }

    public static class Builder {
        private final String url;
        private Map<String, String> headers = Collections.emptyMap();
        private Duration timeout = Duration.ofSeconds(30L);
        private Duration sseReadTimeout = Duration.ofMinutes(5L);
        private boolean terminateOnClose = true;

        private Builder(String url) {
            Assert.hasText((String)url, (String)"url must not be empty");
            this.url = url;
        }

        @CanIgnoreReturnValue
        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder sseReadTimeout(Duration sseReadTimeout) {
            this.sseReadTimeout = sseReadTimeout;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder terminateOnClose(boolean terminateOnClose) {
            this.terminateOnClose = terminateOnClose;
            return this;
        }

        public StreamableHttpServerParameters build() {
            return new StreamableHttpServerParameters(this.url, this.headers, this.timeout, this.sseReadTimeout, this.terminateOnClose);
        }
    }
}

