/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.sessions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.adk.JsonBaseModel;
import com.google.adk.events.Event;
import com.google.adk.events.EventActions;
import com.google.adk.sessions.SessionUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.genai.types.Content;
import com.google.genai.types.FinishReason;
import com.google.genai.types.GroundingMetadata;
import com.google.genai.types.Part;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SessionJsonConverter {
    private static final ObjectMapper objectMapper = JsonBaseModel.getMapper();
    private static final Logger logger = LoggerFactory.getLogger(SessionJsonConverter.class);

    private SessionJsonConverter() {
    }

    static String convertEventToJson(Event event) {
        HashMap<String, Optional<Boolean>> metadataJson = new HashMap<String, Optional<Boolean>>();
        metadataJson.put("partial", event.partial());
        metadataJson.put("turnComplete", event.turnComplete());
        metadataJson.put("interrupted", event.interrupted());
        metadataJson.put("branch", event.branch().orElse(null));
        metadataJson.put("long_running_tool_ids", event.longRunningToolIds() != null ? event.longRunningToolIds().orElse(null) : null);
        if (event.groundingMetadata() != null) {
            metadataJson.put("grounding_metadata", event.groundingMetadata());
        }
        HashMap<String, Object> eventJson = new HashMap<String, Object>();
        eventJson.put("author", event.author());
        eventJson.put("invocationId", event.invocationId());
        eventJson.put("timestamp", new HashMap(ImmutableMap.of((Object)"seconds", (Object)(event.timestamp() / 1000L), (Object)"nanos", (Object)(event.timestamp() % 1000L * 1000000L))));
        if (event.errorCode().isPresent()) {
            eventJson.put("errorCode", event.errorCode());
        }
        if (event.errorMessage().isPresent()) {
            eventJson.put("errorMessage", event.errorMessage());
        }
        eventJson.put("eventMetadata", metadataJson);
        if (event.actions() != null) {
            HashMap<String, Object> actionsJson = new HashMap<String, Object>();
            actionsJson.put("skipSummarization", event.actions().skipSummarization());
            actionsJson.put("stateDelta", event.actions().stateDelta());
            actionsJson.put("artifactDelta", event.actions().artifactDelta());
            actionsJson.put("transferAgent", event.actions().transferToAgent());
            actionsJson.put("escalate", event.actions().escalate());
            actionsJson.put("requestedAuthConfigs", event.actions().requestedAuthConfigs());
            eventJson.put("actions", actionsJson);
        }
        if (event.content().isPresent()) {
            eventJson.put("content", SessionUtils.encodeContent(event.content().get()));
        }
        if (event.errorCode().isPresent()) {
            eventJson.put("errorCode", event.errorCode().get());
        }
        if (event.errorMessage().isPresent()) {
            eventJson.put("errorMessage", event.errorMessage().get());
        }
        try {
            return objectMapper.writeValueAsString(eventJson);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    @Nullable
    private static Content convertMapToContent(Object rawContentValue) {
        if (rawContentValue == null) {
            return null;
        }
        if (rawContentValue instanceof Map) {
            Map contentMap = (Map)rawContentValue;
            try {
                return (Content)objectMapper.convertValue((Object)contentMap, Content.class);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Error converting Map to Content", (Throwable)e);
                return null;
            }
        }
        logger.warn("Unexpected type for 'content' in apiEvent: {}", (Object)rawContentValue.getClass().getName());
        return null;
    }

    static Event fromApiEvent(Map<String, Object> apiEvent) {
        EventActions eventActions = new EventActions();
        if (apiEvent.get("actions") != null) {
            Map actionsMap = (Map)apiEvent.get("actions");
            eventActions.setSkipSummarization(Optional.ofNullable(actionsMap.get("skipSummarization")).map(value -> (Boolean)value));
            eventActions.setStateDelta(actionsMap.get("stateDelta") != null ? new ConcurrentHashMap((Map)actionsMap.get("stateDelta")) : new ConcurrentHashMap());
            eventActions.setArtifactDelta(actionsMap.get("artifactDelta") != null ? SessionJsonConverter.convertToArtifactDeltaMap(actionsMap.get("artifactDelta")) : new ConcurrentHashMap());
            eventActions.setTransferToAgent(actionsMap.get("transferAgent") != null ? (String)actionsMap.get("transferAgent") : null);
            eventActions.setEscalate(Optional.ofNullable(actionsMap.get("escalate")).map(value -> (Boolean)value));
            eventActions.setRequestedAuthConfigs(Optional.ofNullable(actionsMap.get("requestedAuthConfigs")).map(SessionJsonConverter::asConcurrentMapOfConcurrentMaps).orElse(new ConcurrentHashMap()));
        }
        Event event = Event.builder().id((String)Iterables.getLast((Iterable)Splitter.on((char)'/').split((CharSequence)apiEvent.get("name").toString()))).invocationId((String)apiEvent.get("invocationId")).author((String)apiEvent.get("author")).actions(eventActions).content((Content)Optional.ofNullable(apiEvent.get("content")).map(SessionJsonConverter::convertMapToContent).map(SessionUtils::decodeContent).orElse(null)).timestamp(SessionJsonConverter.convertToInstant(apiEvent.get("timestamp")).toEpochMilli()).errorCode(Optional.ofNullable(apiEvent.get("errorCode")).map(value -> new FinishReason((String)value))).errorMessage(Optional.ofNullable(apiEvent.get("errorMessage")).map(value -> (String)value)).branch(Optional.ofNullable(apiEvent.get("branch")).map(value -> (String)value)).build();
        if (apiEvent.get("eventMetadata") != null) {
            Map eventMetadata = (Map)apiEvent.get("eventMetadata");
            List longRunningToolIdsList = (List)eventMetadata.get("longRunningToolIds");
            GroundingMetadata groundingMetadata = null;
            Object rawGroundingMetadata = eventMetadata.get("groundingMetadata");
            if (rawGroundingMetadata != null) {
                groundingMetadata = (GroundingMetadata)objectMapper.convertValue(rawGroundingMetadata, GroundingMetadata.class);
            }
            event = event.toBuilder().partial(Optional.ofNullable((Boolean)eventMetadata.get("partial")).orElse(false)).turnComplete(Optional.ofNullable((Boolean)eventMetadata.get("turnComplete")).orElse(false)).interrupted(Optional.ofNullable((Boolean)eventMetadata.get("interrupted")).orElse(false)).branch(Optional.ofNullable((String)eventMetadata.get("branch"))).groundingMetadata(groundingMetadata).longRunningToolIds(longRunningToolIdsList != null ? new HashSet(longRunningToolIdsList) : null).build();
        }
        return event;
    }

    private static Instant convertToInstant(Object timestampObj) {
        if (timestampObj instanceof Map) {
            Map timestampMap = (Map)timestampObj;
            return Instant.ofEpochSecond(((Number)timestampMap.get("seconds")).longValue(), ((Number)timestampMap.get("nanos")).longValue());
        }
        if (timestampObj != null) {
            return Instant.parse(timestampObj.toString());
        }
        throw new IllegalArgumentException("Timestamp not found in apiEvent");
    }

    private static ConcurrentMap<String, Part> convertToArtifactDeltaMap(Object artifactDeltaObj) {
        if (!(artifactDeltaObj instanceof Map)) {
            return new ConcurrentHashMap<String, Part>();
        }
        ConcurrentHashMap<String, Part> artifactDeltaMap = new ConcurrentHashMap<String, Part>();
        Map rawMap = (Map)artifactDeltaObj;
        for (Map.Entry entry : rawMap.entrySet()) {
            try {
                Part part = (Part)objectMapper.convertValue(entry.getValue(), Part.class);
                artifactDeltaMap.put((String)entry.getKey(), part);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Error converting artifactDelta value to Part for key: {}", entry.getKey(), (Object)e);
            }
        }
        return artifactDeltaMap;
    }

    private static ConcurrentMap<String, ConcurrentMap<String, Object>> asConcurrentMapOfConcurrentMaps(Object value) {
        return ((Map)value).entrySet().stream().collect(ConcurrentHashMap::new, (map, entry) -> map.put((String)entry.getKey(), new ConcurrentHashMap((Map)entry.getValue())), ConcurrentHashMap::putAll);
    }
}

