/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.flows.llmflows;

import com.google.adk.agents.BaseAgent;
import com.google.adk.agents.InvocationContext;
import com.google.adk.agents.LlmAgent;
import com.google.adk.agents.ReadonlyContext;
import com.google.adk.events.Event;
import com.google.adk.flows.llmflows.RequestProcessor;
import com.google.adk.models.LlmRequest;
import com.google.adk.utils.InstructionUtils;
import com.google.common.collect.ImmutableList;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Map;

public final class Instructions
implements RequestProcessor {
    @Override
    public Single<RequestProcessor.RequestProcessingResult> processRequest(InvocationContext context, LlmRequest request) {
        BaseAgent baseAgent = context.agent();
        if (!(baseAgent instanceof LlmAgent)) {
            return Single.error((Throwable)new IllegalArgumentException("Agent in InvocationContext is not an instance of LlmAgent."));
        }
        LlmAgent agent = (LlmAgent)baseAgent;
        ReadonlyContext readonlyContext = new ReadonlyContext(context);
        Single<LlmRequest.Builder> builderSingle = Single.just((Object)request.toBuilder());
        BaseAgent baseAgent2 = agent.rootAgent();
        if (baseAgent2 instanceof LlmAgent) {
            LlmAgent rootAgent = (LlmAgent)baseAgent2;
            builderSingle = this.appendInstruction(builderSingle, context, rootAgent.canonicalGlobalInstruction(readonlyContext));
        }
        builderSingle = this.appendInstruction(builderSingle, context, agent.canonicalInstruction(readonlyContext));
        return builderSingle.map(finalBuilder -> RequestProcessor.RequestProcessingResult.create(finalBuilder.build(), (Iterable<Event>)ImmutableList.of()));
    }

    private Single<LlmRequest.Builder> appendInstruction(Single<LlmRequest.Builder> builderSingle, InvocationContext context, Single<Map.Entry<String, Boolean>> instructionEntrySingle) {
        return builderSingle.flatMap(builder -> instructionEntrySingle.flatMap(instructionEntry -> {
            String instruction = (String)instructionEntry.getKey();
            boolean bypassStateInjection = (Boolean)instructionEntry.getValue();
            if (instruction.isEmpty()) {
                return Single.just((Object)builder);
            }
            if (bypassStateInjection) {
                return Single.just((Object)builder.appendInstructions((List<String>)ImmutableList.of((Object)instruction)));
            }
            return InstructionUtils.injectSessionState(context, instruction).map(resolvedInstr -> builder.appendInstructions((List<String>)ImmutableList.of((Object)resolvedInstr)));
        }));
    }
}

