/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.network;

import com.google.adk.network.ApiResponse;
import com.google.genai.errors.ApiException;
import com.google.genai.errors.ClientException;
import com.google.genai.errors.ServerException;
import java.io.IOException;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class HttpApiResponse
extends ApiResponse {
    private final Response response;

    public HttpApiResponse(Response response) {
        this.throwFromResponse(response);
        this.response = response;
    }

    @Override
    public ResponseBody getEntity() {
        return this.response.body();
    }

    private void throwFromResponse(Response response) {
        if (response.isSuccessful()) {
            return;
        }
        int code = response.code();
        String status = response.message();
        String message = this.getErrorMessageFromResponse(response);
        if (code >= 400 && code < 500) {
            throw new ClientException(code, status, message);
        }
        if (code >= 500 && code < 600) {
            throw new ServerException(code, status, message);
        }
        throw new ApiException(code, status, message);
    }

    private String getErrorMessageFromResponse(Response response) {
        try {
            if (response.body() != null) {
                return response.body().string();
            }
        }
        catch (IOException e) {
            return "Error reading response body";
        }
        return "";
    }

    @Override
    public void close() {
        this.response.close();
    }
}

