/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.service;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiServerSpanExporter
implements SpanExporter {
    private static final Logger exporterLog = LoggerFactory.getLogger(ApiServerSpanExporter.class);
    private final Map<String, Map<String, Object>> eventIdTraceStorage = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, List<String>> sessionToTraceIdsMap = new ConcurrentHashMap<String, List<String>>();
    private final List<SpanData> allExportedSpans = Collections.synchronizedList(new ArrayList());

    public Map<String, Object> getEventTraceAttributes(String eventId) {
        return this.eventIdTraceStorage.get(eventId);
    }

    public Map<String, List<String>> getSessionToTraceIdsMap() {
        return this.sessionToTraceIdsMap;
    }

    public List<SpanData> getAllExportedSpans() {
        return this.allExportedSpans;
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        exporterLog.debug("ApiServerSpanExporter received {} spans to export.", (Object)spans.size());
        ArrayList<SpanData> currentBatch = new ArrayList<SpanData>(spans);
        this.allExportedSpans.addAll(currentBatch);
        for (SpanData span : currentBatch) {
            String spanName = span.getName();
            if ("call_llm".equals(spanName) || "send_data".equals(spanName) || spanName != null && spanName.startsWith("tool_response")) {
                String eventId = (String)span.getAttributes().get(AttributeKey.stringKey((String)"gcp.vertex.agent.event_id"));
                if (eventId != null && !eventId.isEmpty()) {
                    HashMap<String, String> attributesMap = new HashMap<String, String>();
                    span.getAttributes().forEach((key, value) -> attributesMap.put(key.getKey(), (String)value));
                    attributesMap.put("trace_id", span.getSpanContext().getTraceId());
                    attributesMap.put("span_id", span.getSpanContext().getSpanId());
                    attributesMap.putIfAbsent("gcp.vertex.agent.event_id", eventId);
                    exporterLog.debug("Storing event-based trace attributes for event_id: {}", (Object)eventId);
                    this.eventIdTraceStorage.put(eventId, attributesMap);
                } else {
                    exporterLog.trace("Span {} for event-based trace did not have 'gcp.vertex.agent.event_id' attribute or it was empty.", (Object)spanName);
                }
            }
            if (!"call_llm".equals(spanName)) continue;
            String sessionId = (String)span.getAttributes().get(AttributeKey.stringKey((String)"gcp.vertex.agent.session_id"));
            if (sessionId != null && !sessionId.isEmpty()) {
                String traceId = span.getSpanContext().getTraceId();
                this.sessionToTraceIdsMap.computeIfAbsent(sessionId, k -> Collections.synchronizedList(new ArrayList())).add(traceId);
                exporterLog.trace("Associated trace_id {} with session_id {} for session tracing", (Object)traceId, (Object)sessionId);
                continue;
            }
            exporterLog.trace("Span {} for session trace did not have 'gcp.vertex.agent.session_id' attribute.", (Object)spanName);
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        exporterLog.debug("Shutting down ApiServerSpanExporter.");
        return CompletableResultCode.ofSuccess();
    }
}

