/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.controller;

import com.google.adk.agents.RunConfig;
import com.google.adk.events.Event;
import com.google.adk.runner.Runner;
import com.google.adk.web.dto.AgentRunRequest;
import com.google.adk.web.service.RunnerService;
import com.google.common.collect.Lists;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
public class ExecutionController {
    private static final Logger log = LoggerFactory.getLogger(ExecutionController.class);
    private final RunnerService runnerService;
    private final ExecutorService sseExecutor = Executors.newCachedThreadPool();

    @Autowired
    public ExecutionController(RunnerService runnerService) {
        this.runnerService = runnerService;
    }

    @PostMapping(value={"/run"})
    public List<Event> agentRun(@RequestBody AgentRunRequest request) {
        if (request.appName == null || request.appName.trim().isEmpty()) {
            log.warn("appName cannot be null or empty in POST /run request.");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "appName cannot be null or empty");
        }
        if (request.sessionId == null || request.sessionId.trim().isEmpty()) {
            log.warn("sessionId cannot be null or empty in POST /run request.");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "sessionId cannot be null or empty");
        }
        log.info("Request received for POST /run for session: {}", (Object)request.sessionId);
        Runner runner = this.runnerService.getRunner(request.appName);
        try {
            RunConfig runConfig = RunConfig.builder().setStreamingMode(RunConfig.StreamingMode.NONE).build();
            Flowable eventStream = runner.runAsync(request.userId, request.sessionId, request.newMessage, runConfig);
            ArrayList events = Lists.newArrayList((Iterable)eventStream.blockingIterable());
            log.info("Agent run for session {} generated {} events.", (Object)request.sessionId, (Object)events.size());
            return events;
        }
        catch (Exception e) {
            log.error("Error during agent run for session {}", (Object)request.sessionId, (Object)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Agent run failed", (Throwable)e);
        }
    }

    @PostMapping(value={"/run_sse"}, produces={"text/event-stream"})
    public SseEmitter agentRunSse(@RequestBody AgentRunRequest request) {
        SseEmitter emitter = new SseEmitter();
        if (request.appName == null || request.appName.trim().isEmpty()) {
            log.warn("appName cannot be null or empty in SseEmitter request for appName: {}, session: {}", (Object)request.appName, (Object)request.sessionId);
            emitter.completeWithError((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "appName cannot be null or empty"));
            return emitter;
        }
        if (request.sessionId == null || request.sessionId.trim().isEmpty()) {
            log.warn("sessionId cannot be null or empty in SseEmitter request for appName: {}, session: {}", (Object)request.appName, (Object)request.sessionId);
            emitter.completeWithError((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "sessionId cannot be null or empty"));
            return emitter;
        }
        log.info("SseEmitter Request received for POST /run_sse_emitter for session: {}", (Object)request.sessionId);
        String sessionId = request.sessionId;
        this.sseExecutor.execute(() -> {
            Runner runner;
            try {
                runner = this.runnerService.getRunner(request.appName);
            }
            catch (ResponseStatusException e) {
                log.warn("Setup failed for SseEmitter request for session {}: {}", (Object)sessionId, (Object)e.getMessage());
                try {
                    emitter.completeWithError((Throwable)e);
                }
                catch (Exception ex) {
                    log.warn("Error completing emitter after setup failure for session {}: {}", (Object)sessionId, (Object)ex.getMessage());
                }
                return;
            }
            RunConfig runConfig = RunConfig.builder().setStreamingMode(request.getStreaming() ? RunConfig.StreamingMode.SSE : RunConfig.StreamingMode.NONE).build();
            Flowable eventFlowable = runner.runAsync(request.userId, request.sessionId, request.newMessage, runConfig);
            Disposable disposable = eventFlowable.observeOn(Schedulers.io()).subscribe(event -> {
                try {
                    log.debug("SseEmitter: Sending event {} for session {}", (Object)event.id(), (Object)sessionId);
                    emitter.send(SseEmitter.event().data((Object)event.toJson()));
                }
                catch (IOException e) {
                    log.error("SseEmitter: IOException sending event for session {}: {}", (Object)sessionId, (Object)e.getMessage());
                    throw new RuntimeException("Failed to send event", e);
                }
                catch (Exception e) {
                    log.error("SseEmitter: Unexpected error sending event for session {}: {}", new Object[]{sessionId, e.getMessage(), e});
                    throw new RuntimeException("Unexpected error sending event", e);
                }
            }, error -> {
                log.error("SseEmitter: Stream error for session {}: {}", new Object[]{sessionId, error.getMessage(), error});
                try {
                    emitter.completeWithError(error);
                }
                catch (Exception ex) {
                    log.warn("Error completing emitter after stream error for session {}: {}", (Object)sessionId, (Object)ex.getMessage());
                }
            }, () -> {
                log.debug("SseEmitter: Stream completed normally for session: {}", (Object)sessionId);
                try {
                    emitter.complete();
                }
                catch (Exception ex) {
                    log.warn("Error completing emitter after normal completion for session {}: {}", (Object)sessionId, (Object)ex.getMessage());
                }
            });
            emitter.onCompletion(() -> {
                log.debug("SseEmitter: onCompletion callback for session: {}. Disposing subscription.", (Object)sessionId);
                if (!disposable.isDisposed()) {
                    disposable.dispose();
                }
            });
            emitter.onTimeout(() -> {
                log.debug("SseEmitter: onTimeout callback for session: {}. Disposing subscription and completing.", (Object)sessionId);
                if (!disposable.isDisposed()) {
                    disposable.dispose();
                }
                emitter.complete();
            });
        });
        log.debug("SseEmitter: Returning emitter for session: {}", (Object)sessionId);
        return emitter;
    }
}

