/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.controller;

import com.google.adk.web.service.ApiServerSpanExporter;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DebugController {
    private static final Logger log = LoggerFactory.getLogger(DebugController.class);
    private final ApiServerSpanExporter apiServerSpanExporter;

    @Autowired
    public DebugController(ApiServerSpanExporter apiServerSpanExporter) {
        this.apiServerSpanExporter = apiServerSpanExporter;
    }

    @GetMapping(value={"/debug/trace/{eventId}"})
    public ResponseEntity<?> getTraceDict(@PathVariable String eventId) {
        log.info("Request received for GET /debug/trace/{}", (Object)eventId);
        Map<String, Object> traceData = this.apiServerSpanExporter.getEventTraceAttributes(eventId);
        if (traceData == null) {
            log.warn("Trace not found for eventId: {}", (Object)eventId);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Collections.singletonMap("message", "Trace not found for eventId: " + eventId));
        }
        log.info("Returning trace data for eventId: {}", (Object)eventId);
        return ResponseEntity.ok(traceData);
    }

    @GetMapping(value={"/debug/trace/session/{sessionId}"})
    public ResponseEntity<Object> getSessionTrace(@PathVariable String sessionId) {
        log.info("Request received for GET /debug/trace/session/{}", (Object)sessionId);
        List<String> traceIdsForSession = this.apiServerSpanExporter.getSessionToTraceIdsMap().get(sessionId);
        if (traceIdsForSession == null || traceIdsForSession.isEmpty()) {
            log.warn("No trace IDs found for session ID: {}", (Object)sessionId);
            return ResponseEntity.ok(Collections.emptyList());
        }
        ArrayList<SpanData> allSpansSnapshot = new ArrayList<SpanData>(this.apiServerSpanExporter.getAllExportedSpans());
        if (allSpansSnapshot.isEmpty()) {
            log.warn("No spans have been exported yet overall.");
            return ResponseEntity.ok(Collections.emptyList());
        }
        HashSet<String> relevantTraceIds = new HashSet<String>(traceIdsForSession);
        ArrayList resultSpans = new ArrayList();
        for (SpanData span : allSpansSnapshot) {
            if (!relevantTraceIds.contains(span.getSpanContext().getTraceId())) continue;
            HashMap<String, Object> spanMap = new HashMap<String, Object>();
            spanMap.put("name", span.getName());
            spanMap.put("span_id", span.getSpanContext().getSpanId());
            spanMap.put("trace_id", span.getSpanContext().getTraceId());
            spanMap.put("start_time", span.getStartEpochNanos());
            spanMap.put("end_time", span.getEndEpochNanos());
            HashMap attributesMap = new HashMap();
            span.getAttributes().forEach((key, value) -> attributesMap.put(key.getKey(), value));
            spanMap.put("attributes", attributesMap);
            String parentSpanId = span.getParentSpanId();
            if (SpanId.isValid((CharSequence)parentSpanId)) {
                spanMap.put("parent_span_id", parentSpanId);
            } else {
                spanMap.put("parent_span_id", null);
            }
            resultSpans.add(spanMap);
        }
        log.info("Returning {} spans for session ID: {}", (Object)resultSpans.size(), (Object)sessionId);
        return ResponseEntity.ok(resultSpans);
    }
}

