/*
 * Decompiled with CFR 0.152.
 */
package com.google.adk.web.controller;

import com.google.adk.artifacts.BaseArtifactService;
import com.google.adk.artifacts.ListArtifactsResponse;
import com.google.common.collect.ImmutableList;
import com.google.genai.types.Part;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class ArtifactController {
    private static final Logger log = LoggerFactory.getLogger(ArtifactController.class);
    private final BaseArtifactService artifactService;

    @Autowired
    public ArtifactController(BaseArtifactService artifactService) {
        this.artifactService = artifactService;
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts/{artifactName}"})
    public Part loadArtifact(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String artifactName, @RequestParam(required=false) Integer version) {
        String versionStr = version == null ? "latest" : String.valueOf(version);
        log.info("Request received to load artifact: app={}, user={}, session={}, artifact={}, version={}", new Object[]{appName, userId, sessionId, artifactName, versionStr});
        Maybe artifactMaybe = this.artifactService.loadArtifact(appName, userId, sessionId, artifactName, Optional.ofNullable(version));
        Part artifact = (Part)artifactMaybe.blockingGet();
        if (artifact == null) {
            log.warn("Artifact not found: app={}, user={}, session={}, artifact={}, version={}", new Object[]{appName, userId, sessionId, artifactName, versionStr});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Artifact not found");
        }
        log.debug("Artifact {} version {} loaded successfully.", (Object)artifactName, (Object)versionStr);
        return artifact;
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts/{artifactName}/versions/{versionId}"})
    public Part loadArtifactVersion(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String artifactName, @PathVariable int versionId) {
        log.info("Request received to load artifact version: app={}, user={}, session={}, artifact={}, version={}", new Object[]{appName, userId, sessionId, artifactName, versionId});
        Maybe artifactMaybe = this.artifactService.loadArtifact(appName, userId, sessionId, artifactName, Optional.of(versionId));
        Part artifact = (Part)artifactMaybe.blockingGet();
        if (artifact == null) {
            log.warn("Artifact version not found: app={}, user={}, session={}, artifact={}, version={}", new Object[]{appName, userId, sessionId, artifactName, versionId});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Artifact version not found");
        }
        log.debug("Artifact {} version {} loaded successfully.", (Object)artifactName, (Object)versionId);
        return artifact;
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts"})
    public List<String> listArtifactNames(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId) {
        log.info("Request received to list artifact names for app={}, user={}, session={}", new Object[]{appName, userId, sessionId});
        Single responseSingle = this.artifactService.listArtifactKeys(appName, userId, sessionId);
        ListArtifactsResponse response = (ListArtifactsResponse)responseSingle.blockingGet();
        ImmutableList filenames = response != null && response.filenames() != null ? response.filenames() : Collections.emptyList();
        log.info("Found {} artifact names for session {}", (Object)filenames.size(), (Object)sessionId);
        return filenames;
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts/{artifactName}/versions"})
    public List<Integer> listArtifactVersions(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String artifactName) {
        log.info("Request received to list versions for artifact: app={}, user={}, session={}, artifact={}", new Object[]{appName, userId, sessionId, artifactName});
        Single versionsSingle = this.artifactService.listVersions(appName, userId, sessionId, artifactName);
        ImmutableList versions = (ImmutableList)versionsSingle.blockingGet();
        log.info("Found {} versions for artifact {}", (Object)(versions != null ? versions.size() : 0), (Object)artifactName);
        return versions != null ? versions : Collections.emptyList();
    }

    @DeleteMapping(value={"/apps/{appName}/users/{userId}/sessions/{sessionId}/artifacts/{artifactName}"})
    public ResponseEntity<Void> deleteArtifact(@PathVariable String appName, @PathVariable String userId, @PathVariable String sessionId, @PathVariable String artifactName) {
        log.info("Request received to delete artifact: app={}, user={}, session={}, artifact={}", new Object[]{appName, userId, sessionId, artifactName});
        try {
            this.artifactService.deleteArtifact(appName, userId, sessionId, artifactName);
            log.info("Artifact deleted successfully: {}", (Object)artifactName);
            return ResponseEntity.noContent().build();
        }
        catch (Exception e) {
            log.error("Error deleting artifact {}", (Object)artifactName, (Object)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error deleting artifact", (Throwable)e);
        }
    }
}

