/*
 * Decompiled with CFR 0.152.
 */
package com.goebl.simplify;

import com.goebl.simplify.AbstractSimplify;
import com.goebl.simplify.Point;
import com.goebl.simplify.Point3D;
import com.goebl.simplify.Point3DExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simplify3D<T>
extends AbstractSimplify<T> {
    private final Point3DExtractor<T> pointExtractor;

    public Simplify3D(T[] sampleArray) {
        super(sampleArray);
        this.pointExtractor = new Point3DExtractor<T>(){

            @Override
            public double getX(T point) {
                return ((Point)point).getX();
            }

            @Override
            public double getY(T point) {
                return ((Point)point).getY();
            }

            @Override
            public double getZ(T point) {
                return ((Point3D)point).getZ();
            }
        };
    }

    public Simplify3D(T[] sampleArray, Point3DExtractor<T> pointExtractor) {
        super(sampleArray);
        this.pointExtractor = pointExtractor;
    }

    @Override
    public double getSquareDistance(T p1, T p2) {
        double dx = this.pointExtractor.getX(p1) - this.pointExtractor.getX(p2);
        double dy = this.pointExtractor.getY(p1) - this.pointExtractor.getY(p2);
        double dz = this.pointExtractor.getZ(p1) - this.pointExtractor.getZ(p2);
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    public double getSquareSegmentDistance(T p0, T p1, T p2) {
        double x1 = this.pointExtractor.getX(p1);
        double y1 = this.pointExtractor.getY(p1);
        double z1 = this.pointExtractor.getZ(p1);
        double x2 = this.pointExtractor.getX(p2);
        double y2 = this.pointExtractor.getY(p2);
        double z2 = this.pointExtractor.getZ(p2);
        double x0 = this.pointExtractor.getX(p0);
        double y0 = this.pointExtractor.getY(p0);
        double z0 = this.pointExtractor.getZ(p0);
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            double t = ((x0 - x1) * dx + (y0 - y1) * dy + (z0 - z1) * dz) / (dx * dx + dy * dy + dz * dz);
            if (t > 1.0) {
                x1 = x2;
                y1 = y2;
                z1 = z2;
            } else if (t > 0.0) {
                x1 += dx * t;
                y1 += dy * t;
                z1 += dz * t;
            }
        }
        dx = x0 - x1;
        dy = y0 - y1;
        dz = z0 - z1;
        return dx * dx + dy * dy + dz * dz;
    }
}

