/*
 * Decompiled with CFR 0.152.
 */
package com.goebl.simplify;

import java.util.ArrayList;
import java.util.BitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSimplify<T> {
    private T[] sampleArray;

    protected AbstractSimplify(T[] sampleArray) {
        this.sampleArray = sampleArray;
    }

    public T[] simplify(T[] points, double tolerance, boolean highestQuality) {
        double sqTolerance = tolerance * tolerance;
        if (!highestQuality) {
            points = this.simplifyRadialDistance(points, sqTolerance);
        }
        points = this.simplifyDouglasPeucker(points, sqTolerance);
        return points;
    }

    T[] simplifyRadialDistance(T[] points, double sqTolerance) {
        Object point = null;
        T prevPoint = points[0];
        ArrayList<T> newPoints = new ArrayList<T>();
        newPoints.add(prevPoint);
        for (int i = 1; i < points.length; ++i) {
            point = points[i];
            if (!(this.getSquareDistance(point, prevPoint) > sqTolerance)) continue;
            newPoints.add(point);
            prevPoint = point;
        }
        if (prevPoint != point) {
            newPoints.add(point);
        }
        return newPoints.toArray(this.sampleArray);
    }

    T[] simplifyDouglasPeucker(T[] points, double sqTolerance) {
        int index;
        BitSet bitSet = new BitSet(points.length);
        bitSet.set(0);
        bitSet.set(points.length - 1);
        ArrayList<Range> stack = new ArrayList<Range>();
        stack.add(new Range(0, points.length - 1));
        while (!stack.isEmpty()) {
            Range range = (Range)stack.remove(stack.size() - 1);
            index = -1;
            double maxSqDist = 0.0;
            for (int i = range.first + 1; i < range.last; ++i) {
                double sqDist = this.getSquareSegmentDistance(points[i], points[range.first], points[range.last]);
                if (!(sqDist > maxSqDist)) continue;
                index = i;
                maxSqDist = sqDist;
            }
            if (!(maxSqDist > sqTolerance)) continue;
            bitSet.set(index);
            stack.add(new Range(range.first, index));
            stack.add(new Range(index, range.last));
        }
        ArrayList<T> newPoints = new ArrayList<T>(bitSet.cardinality());
        index = bitSet.nextSetBit(0);
        while (index >= 0) {
            newPoints.add(points[index]);
            index = bitSet.nextSetBit(index + 1);
        }
        return newPoints.toArray(this.sampleArray);
    }

    public abstract double getSquareDistance(T var1, T var2);

    public abstract double getSquareSegmentDistance(T var1, T var2, T var3);

    private static class Range {
        int first;
        int last;

        private Range(int first, int last) {
            this.first = first;
            this.last = last;
        }
    }
}

