/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.taucher2003.t2003_utils.tjda.page;

import com.gitlab.taucher2003.t2003_utils.tjda.page.Paginated;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.callbacks.IReplyCallback;
import net.dv8tion.jda.api.interactions.components.ActionComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import org.jetbrains.annotations.NotNull;

public class PaginationManager
extends ListenerAdapter {
    private static final String PREVIOUS_PAGE_ID = "pagination:previous";
    private static final String NEXT_PAGE_ID = "pagination:next";
    private final Map<Long, Paginated> paginations = new ConcurrentHashMap<Long, Paginated>();

    public void paginate(IReplyCallback interaction, Paginated paginated) {
        paginated.movePage(0);
        paginated.getPageEmbed().thenAccept(embed -> ((ReplyCallbackAction)interaction.replyEmbeds(embed, new MessageEmbed[0]).addActionRow(this.getPaginationButtons(paginated))).flatMap(InteractionHook::retrieveOriginal).queue(message -> this.paginations.put(message.getIdLong(), paginated)));
    }

    public void paginate(MessageChannel channel, Paginated paginated) {
        paginated.movePage(0);
        paginated.getPageEmbed().thenAccept(embed -> ((MessageCreateAction)channel.sendMessageEmbeds(embed, new MessageEmbed[0]).setActionRow(this.getPaginationButtons(paginated))).queue(message -> this.paginations.put(message.getIdLong(), paginated)));
    }

    private List<ActionComponent> getPaginationButtons(Paginated paginated) {
        return List.of(Button.of((ButtonStyle)ButtonStyle.PRIMARY, (String)PREVIOUS_PAGE_ID, (Emoji)Emoji.fromUnicode((String)"\u2b05")).withDisabled(!paginated.hasPrevious()), Button.of((ButtonStyle)ButtonStyle.SECONDARY, (String)"pagination:page", (String)(paginated.currentPage() + 1 + "/" + paginated.maxPages())), Button.of((ButtonStyle)ButtonStyle.PRIMARY, (String)NEXT_PAGE_ID, (Emoji)Emoji.fromUnicode((String)"\u27a1\ufe0f")).withDisabled(!paginated.hasNext()));
    }

    public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
        event.deferEdit().queue();
        event.getHook().retrieveOriginal().queue(message -> {
            if (!this.paginations.containsKey(message.getIdLong())) {
                return;
            }
            Paginated paginated = this.paginations.get(message.getIdLong());
            if (!paginated.canInteract(event.getUser())) {
                return;
            }
            String buttonId = event.getButton().getId();
            if (NEXT_PAGE_ID.equals(buttonId) && paginated.hasNext()) {
                paginated.moveNext();
            } else if (PREVIOUS_PAGE_ID.equals(buttonId) && paginated.hasPrevious()) {
                paginated.movePrevious();
            }
            this.sendPage(paginated, (Message)message);
        });
    }

    private void sendPage(Paginated paginated, Message message) {
        paginated.getPageEmbed().thenAccept(embed -> ((MessageEditAction)((MessageEditAction)message.editMessageEmbeds(new MessageEmbed[0]).setEmbeds(new MessageEmbed[]{embed})).setActionRow(this.getPaginationButtons(paginated))).queue());
    }
}

